/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.validation.standard;

import org.wso2.carbon.dataservices.core.validation.standard.GenericValidator;

public class DoubleRangeValidator
extends GenericValidator {
    private double minimum;
    private double maximum;
    private boolean hasMin;
    private boolean hasMax;

    public DoubleRangeValidator(double minimum, double maximum, boolean hasMin, boolean hasMax) {
        super("The double value range expected is [" + minimum + "," + maximum + "]");
        this.minimum = minimum;
        this.maximum = maximum;
        this.hasMin = hasMin;
        this.hasMax = hasMax;
    }

    public double getMinimum() {
        return this.minimum;
    }

    public double getMaximum() {
        return this.maximum;
    }

    public boolean isHasMin() {
        return this.hasMin;
    }

    public boolean isHasMax() {
        return this.hasMax;
    }

    @Override
    protected boolean validateScalar(String value) {
        try {
            double doubleVal = Double.parseDouble(value);
            double min = this.getMinimum();
            if (this.isHasMin() && doubleVal < min) {
                return false;
            }
            double max = this.getMaximum();
            return !this.isHasMax() || !(doubleVal > max);
        }
        catch (Exception e) {
            return false;
        }
    }
}

