/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.engine;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.wso2.carbon.dataservices.core.DataServiceFault;
import org.wso2.carbon.dataservices.core.engine.CallQueryGroup;
import org.wso2.carbon.dataservices.core.engine.ExternalParamCollection;
import org.wso2.carbon.dataservices.core.engine.OutputElement;
import org.wso2.carbon.dataservices.core.engine.Result;
import org.wso2.carbon.dataservices.core.engine.StaticOutputElement;

public class OutputElementGroup
extends OutputElement {
    private String name;
    private Set<String> requiredRoles;
    private List<StaticOutputElement> attributeEntries;
    private List<StaticOutputElement> elementEntries;
    private List<CallQueryGroup> callQueryGroupEntries;
    private List<OutputElementGroup> elementGroupEntries;
    private List<OutputElement> allElements;
    private Result parentResult;
    private String arrayName;
    private ThreadLocal<List<StaticOutputElement>> roleAttributeEntries = new ThreadLocal();
    private ThreadLocal<List<OutputElement>> roleAllElements = new ThreadLocal();

    public OutputElementGroup(String name, String namespace, Set<String> requiredRoles, String arrayName) {
        super(namespace);
        this.name = name;
        this.requiredRoles = requiredRoles;
        this.arrayName = arrayName;
        this.allElements = new ArrayList<OutputElement>();
        this.elementEntries = new ArrayList<StaticOutputElement>();
        this.callQueryGroupEntries = new ArrayList<CallQueryGroup>();
        this.elementGroupEntries = new ArrayList<OutputElementGroup>();
        this.attributeEntries = new ArrayList<StaticOutputElement>();
    }

    public void init() throws DataServiceFault {
        for (CallQueryGroup cqGroup : this.getCallQueryGroupEntries()) {
            cqGroup.init();
        }
        for (OutputElementGroup groups : this.getOutputElementGroupEntries()) {
            groups.init();
        }
    }

    public Result getParentResult() {
        return this.parentResult;
    }

    public void setParentResult(Result parentResult) {
        this.parentResult = parentResult;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getArrayName() {
        return this.arrayName;
    }

    @Override
    public void executeElement(XMLStreamWriter xmlWriter, ExternalParamCollection params, int queryLevel) throws DataServiceFault {
        try {
            ++queryLevel;
            if (this.getName() != null) {
                this.startWrapperElement(xmlWriter, this.getNamespace(), this.getName(), this.getParentResult().getResultType());
            }
            List<StaticOutputElement> attributes = this.getAttributeEntriesForCurrentRole();
            for (StaticOutputElement oe : attributes) {
                oe.execute(xmlWriter, params, queryLevel);
            }
            List<OutputElement> elements = this.getAllElementsForCurrentRole();
            for (OutputElement oe : elements) {
                if (oe instanceof OutputElementGroup) {
                    ((OutputElementGroup)oe).applyUserRoles(oe.getRequiredRoles());
                }
                oe.execute(xmlWriter, params, queryLevel);
            }
            if (this.getName() != null) {
                this.endElement(xmlWriter);
            }
        }
        catch (XMLStreamException e) {
            throw new DataServiceFault(e, "Error in XML generation at OutputElementGroup.execute");
        }
    }

    @Override
    public Set<String> getRequiredRoles() {
        return this.requiredRoles;
    }

    @Override
    public boolean isOptional() {
        return this.getRequiredRoles() != null && this.getRequiredRoles().size() > 0;
    }

    public void applyUserRoles(Set<String> userRoles) {
        ArrayList<StaticOutputElement> attrs = new ArrayList<StaticOutputElement>(this.getAttributeEntries());
        Iterator attrItr = attrs.iterator();
        while (attrItr.hasNext()) {
            StaticOutputElement attr = (StaticOutputElement)attrItr.next();
            if (attr.getRequiredRoles() == null || this.rolesCompatible(userRoles, attr.getRequiredRoles())) continue;
            attrItr.remove();
        }
        this.roleAttributeEntries.set(attrs);
        ArrayList<OutputElement> els = new ArrayList<OutputElement>(this.getAllElements());
        Iterator elItr = els.iterator();
        while (elItr.hasNext()) {
            OutputElement el = (OutputElement)elItr.next();
            if (el.getRequiredRoles() == null || this.rolesCompatible(userRoles, el.getRequiredRoles())) continue;
            elItr.remove();
        }
        this.roleAllElements.set(els);
    }

    private boolean rolesCompatible(Set<String> userRoles, Set<String> requiredRoles) {
        if (requiredRoles == null || requiredRoles.size() == 0) {
            return true;
        }
        if (userRoles == null || userRoles.size() == 0) {
            return false;
        }
        HashSet<String> intersection = new HashSet<String>(userRoles);
        intersection.retainAll(requiredRoles);
        return !intersection.isEmpty();
    }

    public void addAttributeEntry(StaticOutputElement attr) throws DataServiceFault {
        if (this.getAttributeEntries().contains(attr)) {
            throw new DataServiceFault("Error while adding attributes. Cannot use same attribute name more than once");
        }
        this.getAttributeEntries().add(attr);
    }

    public void addElementEntry(StaticOutputElement el) throws DataServiceFault {
        if (this.getElementEntries().contains(el)) {
            throw new DataServiceFault("Error while adding elements. Cannot use same element name more than once");
        }
        this.getElementEntries().add(el);
        this.getAllElements().add(el);
    }

    public void addCallQueryGroupEntry(CallQueryGroup callQueryGroup) {
        this.getCallQueryGroupEntries().add(callQueryGroup);
        this.getAllElements().add(callQueryGroup);
    }

    public void addOutputElementGroupEntry(OutputElementGroup outputElementGroup) {
        this.getOutputElementGroupEntries().add(outputElementGroup);
        this.getAllElements().add(outputElementGroup);
    }

    public List<StaticOutputElement> getAttributeEntries() {
        return this.attributeEntries;
    }

    public List<StaticOutputElement> getElementEntries() {
        return this.elementEntries;
    }

    public List<CallQueryGroup> getCallQueryGroupEntries() {
        return this.callQueryGroupEntries;
    }

    public List<OutputElementGroup> getOutputElementGroupEntries() {
        return this.elementGroupEntries;
    }

    public List<OutputElement> getAllElements() {
        return this.allElements;
    }

    public List<StaticOutputElement> getAttributeEntriesForCurrentRole() {
        return this.roleAttributeEntries.get();
    }

    public List<OutputElement> getAllElementsForCurrentRole() {
        return this.roleAllElements.get();
    }
}

