/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.engine;

import java.util.Set;
import javax.xml.stream.XMLStreamWriter;
import org.wso2.carbon.dataservices.core.DBUtils;
import org.wso2.carbon.dataservices.core.DataServiceFault;
import org.wso2.carbon.dataservices.core.engine.ExternalParam;
import org.wso2.carbon.dataservices.core.engine.ExternalParamCollection;
import org.wso2.carbon.dataservices.core.engine.ParamValue;
import org.wso2.carbon.dataservices.core.engine.XMLWriterHelper;

public abstract class OutputElement
extends XMLWriterHelper {
    private String arrayName;
    private String name;
    private String paramType;
    private String param;

    public OutputElement(String namespace) {
        super(namespace);
    }

    public void execute(XMLStreamWriter xmlWriter, ExternalParamCollection params, int queryLevel) throws DataServiceFault {
        if (this.getArrayName() == null) {
            this.executeElement(xmlWriter, params, queryLevel);
        } else {
            ExternalParam exParam = this.getExternalParam(params);
            if (exParam == null) {
                throw new DataServiceFault("The array '" + this.getArrayName() + "' does not exist");
            }
            ParamValue paramValue = exParam.getValue();
            String name = exParam.getName();
            String type = exParam.getType();
            if (!DBUtils.isSQLArray(paramValue)) {
                throw new DataServiceFault("Parameter does not corresponding to an array");
            }
            for (ParamValue value : paramValue.getArrayValue()) {
                ExternalParamCollection tmpParams = new ExternalParamCollection();
                tmpParams.addParam(new ExternalParam(name, value, type));
                this.executeElement(xmlWriter, tmpParams, queryLevel);
            }
        }
    }

    protected abstract void executeElement(XMLStreamWriter var1, ExternalParamCollection var2, int var3) throws DataServiceFault;

    public abstract Set<String> getRequiredRoles();

    public abstract boolean isOptional();

    public String getArrayName() {
        return this.arrayName;
    }

    public String getParam() {
        return this.param;
    }

    public String getName() {
        return this.name;
    }

    public String getParamType() {
        return this.paramType;
    }

    private ExternalParam getExternalParam(ExternalParamCollection params) {
        ExternalParam exParam = params.getParam(OutputElement.getParamName(this.getArrayName()));
        if (exParam == null) {
            exParam = params.getParam(this.getParamType(), this.getParam());
        }
        return exParam;
    }

    private static String getParamName(String paramName) {
        String udtObjName = DBUtils.extractUDTObjectName(paramName);
        if (udtObjName != null) {
            return udtObjName.toLowerCase();
        }
        return paramName.toLowerCase();
    }
}

