/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.engine;

import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.wso2.carbon.dataservices.core.DBUtils;
import org.wso2.carbon.dataservices.core.description.config.Config;
import org.wso2.carbon.dataservices.core.description.config.ConfigSerializer;
import org.wso2.carbon.dataservices.core.description.event.EventTrigger;
import org.wso2.carbon.dataservices.core.description.event.EventTriggerSerializer;
import org.wso2.carbon.dataservices.core.description.operation.OperationSerializer;
import org.wso2.carbon.dataservices.core.description.query.Query;
import org.wso2.carbon.dataservices.core.description.query.QuerySerializer;
import org.wso2.carbon.dataservices.core.description.resource.Resource;
import org.wso2.carbon.dataservices.core.description.resource.ResourceSerializer;
import org.wso2.carbon.dataservices.core.engine.DataService;

public class DataServiceSerializer {
    public static OMElement serializeDataService(DataService dataService) {
        OMFactory fac = DBUtils.getOMFactory();
        OMElement dataEl = fac.createOMElement(new QName("data"));
        if (dataService.getName() != null) {
            dataEl.addAttribute("name", dataService.getName(), null);
        }
        if (dataService.getServiceNamespace() != null) {
            dataEl.addAttribute("serviceNamespace", dataService.getServiceNamespace(), null);
        }
        if (dataService.getDescription() != null) {
            dataEl.addAttribute("description", dataService.getDescription(), null);
        }
        if (dataService.getServiceStatus() != null) {
            dataEl.addAttribute("serviceStatus", dataService.getServiceStatus(), null);
        }
        dataEl.addAttribute("enableBatchRequests", Boolean.toString(dataService.isBatchRequestsEnabled()), null);
        dataEl.addAttribute("enableBoxcarring", Boolean.toString(dataService.isBoxcarringEnabled()), null);
        for (Config config : dataService.getConfigs().values()) {
            dataEl.addChild((OMNode)ConfigSerializer.serializeConfig(config));
        }
        for (EventTrigger eventTrigger : dataService.getEventTriggers().values()) {
            dataEl.addChild((OMNode)EventTriggerSerializer.serializeEventTrigger(eventTrigger));
        }
        for (Query query : dataService.getQueries().values()) {
            dataEl.addChild((OMNode)QuerySerializer.serializeQuery(query));
        }
        for (String opName : dataService.getOperationNames()) {
            dataEl.addChild((OMNode)OperationSerializer.serializeOperation(dataService.getOperation(opName)));
        }
        Set<Resource.ResourceID> resourceIds = dataService.getResourceIds();
        for (Resource.ResourceID resourceId : resourceIds) {
            dataEl.addChild((OMNode)ResourceSerializer.serializeResource(dataService.getResource(resourceId)));
        }
        fac.createOMDocument().addChild((OMNode)dataEl);
        return dataEl;
    }
}

