/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.description.resource;

import javax.xml.stream.XMLStreamWriter;
import org.wso2.carbon.dataservices.core.DataServiceFault;
import org.wso2.carbon.dataservices.core.engine.CallQueryGroup;
import org.wso2.carbon.dataservices.core.engine.CallableRequest;
import org.wso2.carbon.dataservices.core.engine.DataService;
import org.wso2.carbon.dataservices.core.engine.ExternalParamCollection;

public class Resource
extends CallableRequest {
    private DataService dataService;
    private ResourceID resourceId;

    public Resource(DataService dataService, ResourceID resourceId, String description, CallQueryGroup callQueryGroup, boolean disableStreamingRequest, boolean disableStreamingEffective) {
        super(Resource.generateRequestName(resourceId.getPath(), resourceId.getMethod()), description, callQueryGroup, false, disableStreamingRequest, disableStreamingEffective);
        this.dataService = dataService;
        this.resourceId = resourceId;
    }

    public static String generateRequestName(String path, String method) {
        String pathWithoutSlashes = path.replaceAll("/", "_");
        String pathWithoutLeftBraces = pathWithoutSlashes.replaceAll("\\{", "");
        String pathWithoutRightBraces = pathWithoutLeftBraces.replaceAll("\\}", "");
        String requestName = "_" + method + pathWithoutRightBraces;
        return requestName.toLowerCase();
    }

    public DataService getDataService() {
        return this.dataService;
    }

    public ResourceID getResourceId() {
        return this.resourceId;
    }

    @Override
    public void execute(XMLStreamWriter xmlWriter, ExternalParamCollection params) throws DataServiceFault {
        this.getCallQueryGroup().execute(xmlWriter, params, 0);
    }

    public static class ResourceID {
        private String path;
        private String method;
        private int hashCode;

        public ResourceID(String path, String method) {
            this.path = path;
            this.method = method;
            this.hashCode = Resource.generateRequestName(this.path, this.method).hashCode();
        }

        public String getPath() {
            return this.path;
        }

        public String getMethod() {
            return this.method;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object rhs) {
            if (!(rhs instanceof ResourceID)) {
                return false;
            }
            return this.hashCode() == rhs.hashCode();
        }
    }
}

