/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.description.query;

import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.QuerySolutionMap;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamWriter;
import org.wso2.carbon.dataservices.core.DataServiceFault;
import org.wso2.carbon.dataservices.core.description.config.RDFConfig;
import org.wso2.carbon.dataservices.core.description.event.EventTrigger;
import org.wso2.carbon.dataservices.core.description.query.SparqlQueryBase;
import org.wso2.carbon.dataservices.core.engine.DataEntry;
import org.wso2.carbon.dataservices.core.engine.DataService;
import org.wso2.carbon.dataservices.core.engine.InternalParam;
import org.wso2.carbon.dataservices.core.engine.InternalParamCollection;
import org.wso2.carbon.dataservices.core.engine.QueryParam;
import org.wso2.carbon.dataservices.core.engine.Result;

public class RdfFileQuery
extends SparqlQueryBase {
    private RDFConfig config;

    public RdfFileQuery(DataService dataService, String queryId, String configId, String query, List<QueryParam> queryParams, Result result, EventTrigger inputEventTrigger, EventTrigger outputEventTrigger, Map<String, String> advancedProperties, String inputNamespace) throws DataServiceFault {
        super(dataService, queryId, configId, query, queryParams, result, inputEventTrigger, outputEventTrigger, advancedProperties, inputNamespace);
        try {
            this.config = (RDFConfig)this.getDataService().getConfig(this.getConfigId());
        }
        catch (ClassCastException e) {
            throw new DataServiceFault(e, "Configuration is not a RDF config:" + this.getConfigId());
        }
    }

    public RDFConfig getConfig() {
        return this.config;
    }

    @Override
    public QueryExecution getQueryExecution() throws IOException, DataServiceFault {
        return QueryExecutionFactory.create((String)this.getQuery(), (Model)this.config.createRDFModel());
    }

    @Override
    public void processQuery(XMLStreamWriter xmlWriter, InternalParamCollection params, int queryLevel) throws DataServiceFault {
        try {
            QuerySolutionMap queryMap = new QuerySolutionMap();
            Model model = this.getModelForValidation();
            for (InternalParam param : params.getParams()) {
                queryMap.add(param.getName(), this.convertTypeLiteral(model, param));
            }
            QueryExecution qe = this.getQueryExecution();
            qe.setInitialBinding((QuerySolution)queryMap);
            ResultSet results = qe.execSelect();
            while (results.hasNext()) {
                DataEntry dataEntry = this.getDataEntryFromRS(results);
                this.writeResultEntry(xmlWriter, dataEntry, params, queryLevel);
            }
        }
        catch (Exception e) {
            throw new DataServiceFault(e, "Error in 'SparqlQueryBase.processQuery'");
        }
    }
}

