/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.description.query;

import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamWriter;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.wso2.carbon.dataservices.core.DBUtils;
import org.wso2.carbon.dataservices.core.DataServiceFault;
import org.wso2.carbon.dataservices.core.description.config.ExcelConfig;
import org.wso2.carbon.dataservices.core.description.event.EventTrigger;
import org.wso2.carbon.dataservices.core.description.query.Query;
import org.wso2.carbon.dataservices.core.engine.DataEntry;
import org.wso2.carbon.dataservices.core.engine.DataService;
import org.wso2.carbon.dataservices.core.engine.InternalParamCollection;
import org.wso2.carbon.dataservices.core.engine.ParamValue;
import org.wso2.carbon.dataservices.core.engine.QueryParam;
import org.wso2.carbon.dataservices.core.engine.Result;

public class ExcelQuery
extends Query {
    private ExcelConfig config;
    private String workbookName;
    private boolean hasHeader;
    private int startingRow;
    private int maxRowCount;
    private Map<Integer, String> columnMappings;

    public ExcelQuery(DataService dataService, String queryId, List<QueryParam> queryParams, String configId, String workbookName, boolean hasHeader, int startingRow, int maxRowCount, Result result, EventTrigger inputEventTrigger, EventTrigger outputEventTrigger, Map<String, String> advancedProperties, String inputNamespace) throws DataServiceFault {
        super(dataService, queryId, queryParams, result, configId, inputEventTrigger, outputEventTrigger, advancedProperties, inputNamespace);
        try {
            this.config = (ExcelConfig)this.getDataService().getConfig(this.getConfigId());
        }
        catch (ClassCastException e) {
            throw new DataServiceFault(e, "Configuration is not an Excel config:" + this.getConfigId());
        }
        this.workbookName = workbookName;
        this.hasHeader = hasHeader;
        this.startingRow = startingRow;
        this.maxRowCount = maxRowCount;
        try {
            this.columnMappings = DBUtils.createColumnMappings(this.getHeader());
        }
        catch (Exception e) {
            throw new DataServiceFault(e, "Error in creating Excel column mappings.");
        }
    }

    public Map<Integer, String> getColumnMappings() {
        return this.columnMappings;
    }

    private String[] getHeader() throws Exception {
        if (!this.isHasHeader()) {
            return null;
        }
        Workbook wb = this.getConfig().createWorkbook();
        Sheet sheet = wb.getSheet(this.getWorkbookName());
        String[] header = this.extractRowData(sheet.getRow(0));
        return header;
    }

    private String[] extractRowData(Row row) {
        if (row == null || row.getLastCellNum() == -1) {
            return null;
        }
        String[] data = new String[row.getLastCellNum()];
        block7: for (int i = 0; i < data.length; ++i) {
            Cell cell = row.getCell(i);
            if (cell == null) {
                data[i] = "";
                continue;
            }
            switch (cell.getCellType()) {
                case 1: {
                    data[i] = cell.getRichStringCellValue().getString();
                    continue block7;
                }
                case 3: {
                    data[i] = "";
                    continue block7;
                }
                case 4: {
                    data[i] = String.valueOf(cell.getBooleanCellValue());
                    continue block7;
                }
                case 2: {
                    data[i] = "{formula}";
                    continue block7;
                }
                case 0: {
                    data[i] = this.processNumericValue(cell.getNumericCellValue());
                }
            }
        }
        return data;
    }

    private String processNumericValue(double val) {
        if (val == (double)((long)val)) {
            return String.valueOf((long)val);
        }
        return String.valueOf(val);
    }

    public ExcelConfig getConfig() {
        return this.config;
    }

    public boolean isHasHeader() {
        return this.hasHeader;
    }

    public int getMaxRowCount() {
        return this.maxRowCount;
    }

    public int getStartingRow() {
        return this.startingRow;
    }

    public String getWorkbookName() {
        return this.workbookName;
    }

    @Override
    public void runQuery(XMLStreamWriter xmlWriter, InternalParamCollection params, int queryLevel) throws DataServiceFault {
        try {
            String[] record;
            Workbook wb = this.getConfig().createWorkbook();
            Sheet sheet = wb.getSheet(this.getWorkbookName());
            int maxCount = this.getMaxRowCount();
            int i = this.getStartingRow() - 1;
            Map<Integer, String> columnsMap = this.getColumnMappings();
            boolean useColumnNumbers = this.isUsingColumnNumbers();
            for (int count = 0; (record = this.extractRowData(sheet.getRow(i))) != null && (maxCount == -1 || count < maxCount); ++count) {
                DataEntry dataEntry = new DataEntry();
                for (int j = 0; j < record.length; ++j) {
                    dataEntry.addValue(useColumnNumbers ? Integer.toString(i + 1) : columnsMap.get(j + 1), new ParamValue(record[j]));
                }
                this.writeResultEntry(xmlWriter, dataEntry, params, queryLevel);
                ++i;
            }
        }
        catch (Exception e) {
            throw new DataServiceFault(e, "Error in ExcelQuery.runQuery.");
        }
    }
}

