/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.description.config;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.webharvest.definition.ScraperConfiguration;
import org.webharvest.runtime.Scraper;
import org.webharvest.runtime.variables.Variable;
import org.wso2.carbon.dataservices.core.DBUtils;
import org.wso2.carbon.dataservices.core.DataServiceFault;
import org.wso2.carbon.dataservices.core.description.config.Config;
import org.wso2.carbon.dataservices.core.engine.DataService;
import org.xml.sax.InputSource;

public class WebConfig
extends Config {
    private static final Log log = LogFactory.getLog(WebConfig.class);
    private String webHarvestConfigPath = this.getProperty("web_harvest_config");

    public WebConfig(DataService dataService, String configId, Map<String, String> properties) {
        super(dataService, configId, "WEB_CONFIG", properties);
    }

    public Scraper getScraperConfig() throws DataServiceFault, IOException {
        try {
            InputStream in = !this.webHarvestConfigPath.trim().startsWith("<config>") ? DBUtils.getInputStreamFromPath(this.webHarvestConfigPath) : new ByteArrayInputStream(this.webHarvestConfigPath.getBytes());
            InputSource inputSource = new InputSource(in);
            ScraperConfiguration scraperConfiguration = new ScraperConfiguration(inputSource);
            Scraper scraper = new Scraper(scraperConfiguration, "");
            return scraper;
        }
        catch (FileNotFoundException e) {
            throw new DataServiceFault(e, "Error in reading web harvest configuration");
        }
    }

    public Variable getScrapedResult(String queryVariable) throws DataServiceFault {
        try {
            Scraper scraper = this.getScraperConfig();
            scraper.execute();
            return (Variable)scraper.getContext().get((Object)queryVariable);
        }
        catch (Exception e) {
            throw new DataServiceFault(e, "Error in Scraper Execution");
        }
    }

    @Override
    public boolean isActive() {
        try {
            Scraper scraper = this.getScraperConfig();
            return scraper != null;
        }
        catch (Exception e) {
            log.error((Object)"Error in checking Web config availability", (Throwable)e);
            return false;
        }
    }

    @Override
    public void close() {
    }
}

