/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.description.config;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.dataservices.core.DBUtils;
import org.wso2.carbon.dataservices.core.DataServiceFault;
import org.wso2.carbon.dataservices.core.description.config.Config;
import org.wso2.carbon.dataservices.core.description.config.ExcelConfig;
import org.wso2.carbon.dataservices.core.engine.DataService;

public class RDFConfig
extends Config {
    private static final Log log = LogFactory.getLog(ExcelConfig.class);
    private String rdfDataSourcePath = this.getProperty("rdf_datasource").trim();

    public RDFConfig(DataService dataService, String configId, Map<String, String> properties) {
        super(dataService, configId, "RDF", properties);
    }

    public Model createRDFModel() throws IOException, DataServiceFault {
        InputStream in = DBUtils.getInputStreamFromPath(this.getRDFDataSourcePath());
        Model model = ModelFactory.createMemModelMaker().createDefaultModel();
        model.read(in, null);
        return model;
    }

    public String getRDFDataSourcePath() {
        return this.rdfDataSourcePath;
    }

    @Override
    public boolean isActive() {
        try {
            Model model = this.createRDFModel();
            return model != null;
        }
        catch (Exception e) {
            log.error((Object)"Error in checking RDF config availability", (Throwable)e);
            return false;
        }
    }

    @Override
    public void close() {
    }
}

