/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core;

import java.io.File;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.axis2.deployment.util.Utils;
import org.apache.axis2.description.AxisService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.dataservices.core.DBDeployer;

public class FaultyServiceRectifier
implements Runnable {
    private static final Log log = LogFactory.getLog(FaultyServiceRectifier.class);
    private ConfigurationContext configurationCtx;
    private DeploymentFileData deploymentFileData;

    public FaultyServiceRectifier(AxisService service, DeploymentFileData deploymentData, ConfigurationContext configCtx) {
        this.deploymentFileData = deploymentData;
        this.configurationCtx = configCtx;
    }

    public static String getServiceNameFromPath(String repoDir, File deploymentFile) {
        String heirarchy = Utils.getServiceHierarchy((String)deploymentFile.getAbsolutePath(), (String)repoDir);
        String name = deploymentFile.getName();
        int index = name.lastIndexOf(".dbs");
        if (index == -1) {
            return null;
        }
        name = name.substring(0, index);
        return heirarchy + name;
    }

    @Override
    public void run() {
        String deploymentFilePath = null;
        try {
            deploymentFilePath = this.deploymentFileData.getFile().getAbsolutePath();
            File file = new File(deploymentFilePath);
            if (file.isFile()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Trying to re-establish faulty database connection for data services :" + deploymentFilePath));
                }
                DBDeployer dbDeployer = (DBDeployer)((Object)this.configurationCtx.getProperty("org.wso2.ws.dataservice.dataservice.deployer"));
                if (this.configurationCtx.getAxisConfiguration().getService(FaultyServiceRectifier.getServiceNameFromPath(dbDeployer.getRepoDir(), file)) != null) {
                    return;
                }
                this.configurationCtx.getAxisConfiguration().removeFaultyService(deploymentFilePath);
                dbDeployer.deploy(this.deploymentFileData);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Deployment file " + deploymentFilePath + " does not exist.Removing timer task"));
            }
        }
        catch (Exception e) {
            log.error((Object)"Error in faulty service rectifier", (Throwable)e);
        }
    }
}

