/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.task;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;
import org.wso2.carbon.dataservices.task.DSTask;
import org.wso2.carbon.dataservices.task.DSTaskConstants;
import org.wso2.carbon.dataservices.task.DSTaskInfo;
import org.wso2.carbon.ntask.core.TaskInfo;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DSTaskUtils {
    public static DSTaskInfo convert(TaskInfo taskInfo) {
        DSTaskInfo dsTaskInfo = new DSTaskInfo();
        dsTaskInfo.setName(taskInfo.getName());
        Map taskProps = taskInfo.getProperties();
        dsTaskInfo.setServiceName((String)taskProps.get(DSTaskConstants.DATA_SERVICE_NAME));
        dsTaskInfo.setOperationName((String)taskProps.get(DSTaskConstants.DATA_SERVICE_OPERATION_NAME));
        TaskInfo.TriggerInfo triggerInfo = taskInfo.getTriggerInfo();
        dsTaskInfo.setCronExpression(triggerInfo.getCronExpression());
        dsTaskInfo.setStartTime(DSTaskUtils.dateToCal(triggerInfo.getStartTime()));
        dsTaskInfo.setEndTime(DSTaskUtils.dateToCal(triggerInfo.getEndTime()));
        dsTaskInfo.setTaskCount(triggerInfo.getRepeatCount());
        dsTaskInfo.setTaskInterval(triggerInfo.getIntervalMillis());
        return dsTaskInfo;
    }

    public static TaskInfo convert(DSTaskInfo dsTaskInfo) {
        TaskInfo.TriggerInfo triggerInfo = new TaskInfo.TriggerInfo();
        triggerInfo.setCronExpression(dsTaskInfo.getCronExpression());
        if (dsTaskInfo.getStartTime() != null) {
            triggerInfo.setStartTime(dsTaskInfo.getStartTime().getTime());
        }
        if (dsTaskInfo.getEndTime() != null) {
            triggerInfo.setEndTime(dsTaskInfo.getEndTime().getTime());
        }
        triggerInfo.setIntervalMillis(dsTaskInfo.getTaskInterval());
        triggerInfo.setRepeatCount(dsTaskInfo.getTaskCount());
        HashMap<String, String> props = new HashMap<String, String>();
        props.put(DSTaskConstants.DATA_SERVICE_NAME, dsTaskInfo.getServiceName());
        props.put(DSTaskConstants.DATA_SERVICE_OPERATION_NAME, dsTaskInfo.getOperationName());
        props.put("SERVICE_ACTION", "urn:" + dsTaskInfo.getOperationName());
        return new TaskInfo(dsTaskInfo.getName(), DSTask.class.getName(), props, triggerInfo);
    }

    private static Calendar dateToCal(Date date) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal;
    }

    public static String getTenantDomainFromId(int tid) {
        SuperTenantCarbonContext.startTenantFlow();
        SuperTenantCarbonContext.getCurrentContext().setTenantId(tid);
        String tenantDomain = SuperTenantCarbonContext.getCurrentContext().getTenantDomain();
        SuperTenantCarbonContext.endTenantFlow();
        return tenantDomain;
    }

    public static String extractHTTPEPR(AxisService axisService) {
        for (String epr : axisService.getEPRs()) {
            if (!epr.startsWith("http:")) continue;
            return epr;
        }
        return null;
    }

    public static boolean isInOutMEPInOperation(AxisService axisService, String opName) {
        AxisOperation operation;
        Parameter param = axisService.getParameter("org.wso2.ws.dataservice.dataservice.obj");
        return param != null && ("http://www.w3.org/ns/wsdl/in-out".equals((operation = axisService.getOperation(new QName(opName))).getMessageExchangePattern()) || "http://www.w3.org/ns/wsdl/out-only".equals(operation.getMessageExchangePattern()));
    }

    public static List<String> getOutOnlyOperationsList(String dbsContent) {
        ArrayList<String> outOnlyOperations = new ArrayList<String>();
        Document doc = DSTaskUtils.getDocument(dbsContent);
        Element root = doc.getDocumentElement();
        NodeList elements = root.getChildNodes();
        HashMap<String, Node> operations = new HashMap<String, Node>();
        HashMap<String, Node> queries = new HashMap<String, Node>();
        for (int i = 0; i < elements.getLength(); ++i) {
            NamedNodeMap attributes;
            Node n = elements.item(i);
            if ("operation".equals(n.getNodeName()) && (attributes = n.getAttributes()) != null) {
                String opName = attributes.getNamedItem("name").getFirstChild().getNodeValue();
                operations.put(opName, n);
            }
            if (!"query".equals(n.getNodeName()) || (attributes = n.getAttributes()) == null) continue;
            String queryName = attributes.getNamedItem("id").getFirstChild().getNodeValue();
            queries.put(queryName, n);
        }
        for (Map.Entry entry : operations.entrySet()) {
            NodeList children = ((Node)entry.getValue()).getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (!"call-query".equals(child.getNodeName())) continue;
                String queryName = child.getAttributes().getNamedItem("href").getFirstChild().getNodeValue();
                if (DSTaskUtils.hasInputParams((String)entry.getKey(), operations) || !DSTaskUtils.hasResult(queryName, queries)) continue;
                outOnlyOperations.add((String)entry.getKey());
            }
        }
        return outOnlyOperations;
    }

    private static boolean hasResult(String queryName, Map<String, Node> queries) {
        Node query = queries.get(queryName);
        if (query != null) {
            NodeList subEls = query.getChildNodes();
            for (int i = 0; i < subEls.getLength(); ++i) {
                Node n = subEls.item(i);
                if (!"result".equals(n.getNodeName())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean hasInputParams(String operationName, Map<String, Node> operations) {
        Node operation = operations.get(operationName);
        if (operation != null) {
            NodeList subEls = operation.getChildNodes();
            for (int i = 0; i < subEls.getLength(); ++i) {
                Node n = subEls.item(i);
                if (!"with-param".equals(n.getNodeName())) continue;
                return true;
            }
        }
        return false;
    }

    private static Document getDocument(String content) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document doc = null;
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            InputSource is = new InputSource(new StringReader(content));
            doc = builder.parse(is);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return doc;
    }

    public static boolean isBoxcarringOp(String opName) {
        return "begin_boxcar".equals(opName) || "end_boxcar".equals(opName) || "abort_boxcar".equals(opName);
    }
}

