/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.xqj;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.Properties;
import javax.xml.stream.XMLStreamReader;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.ContentHandlerProxy;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.TreeReceiver;
import net.sf.saxon.expr.TailIterator;
import net.sf.saxon.javax.xml.xquery.XQCommonHandler;
import net.sf.saxon.javax.xml.xquery.XQConnection;
import net.sf.saxon.javax.xml.xquery.XQException;
import net.sf.saxon.javax.xml.xquery.XQItem;
import net.sf.saxon.javax.xml.xquery.XQItemType;
import net.sf.saxon.javax.xml.xquery.XQResultSequence;
import net.sf.saxon.javax.xml.xquery.XQWarning;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pull.PullFromIterator;
import net.sf.saxon.pull.PullToStax;
import net.sf.saxon.query.QueryResult;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Value;
import net.sf.saxon.xqj.SaxonXQConnection;
import net.sf.saxon.xqj.SaxonXQItem;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;

public class SaxonXQSequence
implements XQResultSequence {
    private Value value;
    private Configuration config;
    private int position;
    private boolean closed;
    private SaxonXQConnection connection;

    SaxonXQSequence(Value value, Configuration configuration) {
        this.value = value;
        this.config = configuration;
    }

    SaxonXQSequence(Value value, Configuration configuration, SaxonXQConnection saxonXQConnection) {
        this.value = value;
        this.config = configuration;
        this.connection = saxonXQConnection;
    }

    Value getValue() {
        return this.value;
    }

    Configuration getConfiguration() {
        return this.getConfiguration();
    }

    public boolean absolute(int n) throws XQException {
        try {
            if (n > 0) {
                if (n <= this.value.getLength()) {
                    this.position = n;
                    return true;
                }
                this.position = -1;
                return false;
            }
            if (n < 0) {
                if (-n <= this.value.getLength()) {
                    this.position = this.value.getLength() + n + 1;
                    return true;
                }
                this.position = 0;
                return false;
            }
            this.position = 0;
            return false;
        }
        catch (XPathException xPathException) {
            throw new XQException(xPathException.getMessage(), (Throwable)xPathException, null, null);
        }
    }

    public void afterLast() throws XQException {
        this.position = -1;
    }

    public void beforeFirst() throws XQException {
        this.position = 0;
    }

    public void close() throws XQException {
        this.closed = true;
        this.value = null;
    }

    public int count() throws XQException {
        try {
            return this.value.getLength();
        }
        catch (XPathException xPathException) {
            throw new XQException(xPathException.getMessage(), (Throwable)xPathException, null, null);
        }
    }

    public boolean first() throws XQException {
        try {
            if (this.value.getLength() == 0) {
                this.position = 0;
                return false;
            }
            this.position = 1;
            return true;
        }
        catch (XPathException xPathException) {
            throw new XQException(xPathException.getMessage(), (Throwable)xPathException, null, null);
        }
    }

    public XQItem getItem() throws XQException {
        try {
            SaxonXQItem saxonXQItem = new SaxonXQItem(this.value.itemAt(this.position - 1), this.config);
            saxonXQItem.setConnection(this.connection);
            return saxonXQItem;
        }
        catch (XPathException xPathException) {
            throw new XQException(xPathException.getMessage(), (Throwable)xPathException, null, null);
        }
    }

    public int getPosition() throws XQException {
        try {
            if (this.position >= 0) {
                return this.position;
            }
            return this.value.getLength();
        }
        catch (XPathException xPathException) {
            throw new XQException(xPathException.getMessage(), (Throwable)xPathException, null, null);
        }
    }

    public XMLStreamReader getSequenceAsStream() throws XQException {
        return new PullToStax(new PullFromIterator(this.iterateRemainder()));
    }

    public String getSequenceAsString(Properties properties) throws XQException {
        StringWriter stringWriter = new StringWriter();
        this.writeSequence(stringWriter, properties);
        return stringWriter.toString();
    }

    public boolean isAfterLast() throws XQException {
        return this.position < 0;
    }

    public boolean isBeforeFirst() throws XQException {
        return this.position == 0;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isFirst() throws XQException {
        return this.position == 1;
    }

    public boolean isLast() throws XQException {
        try {
            return this.position == this.value.getLength();
        }
        catch (XPathException xPathException) {
            throw new XQException(xPathException.getMessage(), (Throwable)xPathException, null, null);
        }
    }

    public boolean isOnItem() throws XQException {
        return this.position >= 1;
    }

    public boolean isScrollable() throws XQException {
        return true;
    }

    public boolean last() throws XQException {
        try {
            int n = this.value.getLength();
            if (n == 0) {
                this.position = -1;
                return false;
            }
            this.position = 0;
            return true;
        }
        catch (XPathException xPathException) {
            throw new XQException(xPathException.getMessage(), (Throwable)xPathException, null, null);
        }
    }

    public boolean next() throws XQException {
        try {
            if (this.position == this.value.getLength()) {
                this.position = -1;
                return false;
            }
            ++this.position;
            return true;
        }
        catch (XPathException xPathException) {
            throw new XQException(xPathException.getMessage(), (Throwable)xPathException, null, null);
        }
    }

    public boolean previous() throws XQException {
        --this.position;
        return this.position != 0;
    }

    public boolean relative(int n) throws XQException {
        try {
            this.position += n;
            if (this.position <= 0) {
                this.position = 0;
                return false;
            }
            if (this.position > this.value.getLength()) {
                this.position = -1;
                return false;
            }
            return true;
        }
        catch (XPathException xPathException) {
            throw new XQException(xPathException.getMessage(), (Throwable)xPathException, null, null);
        }
    }

    public void writeSequence(OutputStream outputStream, Properties properties) throws XQException {
        try {
            QueryResult.serializeSequence(this.iterateRemainder(), this.config, outputStream, properties);
            this.position = -1;
        }
        catch (XPathException xPathException) {
            throw new XQException(xPathException.getMessage(), (Throwable)xPathException, null, null);
        }
    }

    public void writeSequence(Writer writer, Properties properties) throws XQException {
        try {
            PrintWriter printWriter = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
            QueryResult.serializeSequence(this.iterateRemainder(), this.config, printWriter, properties);
            this.position = -1;
        }
        catch (XPathException xPathException) {
            throw new XQException(xPathException.getMessage(), (Throwable)xPathException, null, null);
        }
    }

    public void writeSequenceToSAX(ContentHandler contentHandler) throws XQException {
        try {
            Item item;
            PipelineConfiguration pipelineConfiguration = this.config.makePipelineConfiguration();
            SequenceIterator sequenceIterator = this.iterateRemainder();
            ContentHandlerProxy contentHandlerProxy = new ContentHandlerProxy();
            contentHandlerProxy.setUnderlyingContentHandler(contentHandler);
            contentHandlerProxy.setPipelineConfiguration(pipelineConfiguration);
            TreeReceiver treeReceiver = new TreeReceiver(contentHandlerProxy);
            treeReceiver.open();
            while ((item = sequenceIterator.next()) != null) {
                treeReceiver.append(item, 0, 2);
            }
            treeReceiver.close();
        }
        catch (XPathException xPathException) {
            throw new XQException(xPathException.getMessage(), (Throwable)xPathException, null, null);
        }
    }

    public String getAtomicValue() throws XQException {
        return this.getCurrentItem().getAtomicValue();
    }

    public boolean getBoolean() throws XQException {
        return this.getCurrentItem().getBoolean();
    }

    public byte getByte() throws XQException {
        return this.getCurrentItem().getByte();
    }

    public double getDouble() throws XQException {
        return this.getCurrentItem().getDouble();
    }

    public float getFloat() throws XQException {
        return this.getCurrentItem().getFloat();
    }

    public int getInt() throws XQException {
        return this.getCurrentItem().getInt();
    }

    public XMLStreamReader getItemAsStream() throws XQException {
        return this.getCurrentItem().getItemAsStream();
    }

    public String getItemAsString() throws XQException {
        return this.getCurrentItem().getItemAsString();
    }

    public XQItemType getItemType() throws XQException {
        return this.getCurrentItem().getItemType();
    }

    public long getLong() throws XQException {
        return this.getCurrentItem().getLong();
    }

    public Node getNode() throws XQException {
        return this.getCurrentItem().getNode();
    }

    public URI getNodeUri() throws XQException {
        return this.getCurrentItem().getNodeUri();
    }

    public Object getObject() throws XQException {
        return this.getCurrentItem().getObject();
    }

    public Object getObject(XQCommonHandler xQCommonHandler) throws XQException {
        return this.getCurrentItem().getObject(xQCommonHandler);
    }

    public short getShort() throws XQException {
        return this.getCurrentItem().getShort();
    }

    public boolean instanceOf(XQItemType xQItemType) throws XQException {
        return this.getCurrentItem().instanceOf(xQItemType);
    }

    public void writeItem(OutputStream outputStream, Properties properties) throws XQException {
        this.getCurrentItem().writeItem(outputStream, properties);
    }

    public void writeItem(Writer writer, Properties properties) throws XQException {
        this.getCurrentItem().writeItem(writer, properties);
    }

    public void writeItemToSAX(ContentHandler contentHandler) throws XQException {
        this.getCurrentItem().writeItemToSAX(contentHandler);
    }

    private SaxonXQItem getCurrentItem() throws XQException {
        if (this.closed) {
            throw new XQException("Sequence is closed");
        }
        if (this.position == 0) {
            throw new XQException("Sequence is positioned before first item");
        }
        if (this.position < 0) {
            throw new XQException("Sequence is positioned after last item");
        }
        try {
            return new SaxonXQItem(this.value.itemAt(this.position - 1), this.config);
        }
        catch (XPathException xPathException) {
            throw new XQException(xPathException.getMessage(), (Throwable)xPathException, null, null);
        }
    }

    public void clearWarnings() {
    }

    public XQConnection getConnection() {
        return this.connection;
    }

    public XQWarning getWarnings() {
        return null;
    }

    private SequenceIterator iterateRemainder() throws XQException {
        try {
            if (this.position == 0) {
                return this.value.iterate();
            }
            if (this.position < 0) {
                return EmptyIterator.getInstance();
            }
            return TailIterator.make(this.value.iterate(), this.position);
        }
        catch (XPathException xPathException) {
            throw new XQException(xPathException.getMessage(), (Throwable)xPathException, null, null);
        }
    }
}

