/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.dom;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.AugmentedSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.dom.DocumentOverNodeInfo;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Sender;
import net.sf.saxon.tinytree.TinyBuilder;
import net.sf.saxon.tinytree.TinyDocumentImpl;
import net.sf.saxon.trans.XPathException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DocumentBuilderImpl
extends DocumentBuilder {
    private Configuration config;
    private EntityResolver entityResolver;
    private ErrorHandler errorHandler;
    private boolean xIncludeAware;
    private boolean validating;
    private int stripSpace = 13;

    public void setConfiguration(Configuration configuration) {
        this.config = configuration;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public boolean isNamespaceAware() {
        return true;
    }

    public void setValidating(boolean bl) {
        this.validating = bl;
    }

    public boolean isValidating() {
        return this.validating;
    }

    public Document newDocument() {
        return new DocumentOverNodeInfo();
    }

    public Document parse(InputSource inputSource) throws SAXException {
        try {
            Object object;
            TinyBuilder tinyBuilder = new TinyBuilder();
            if (this.config == null) {
                this.config = new Configuration();
            }
            PipelineConfiguration pipelineConfiguration = this.config.makePipelineConfiguration();
            tinyBuilder.setPipelineConfiguration(pipelineConfiguration);
            SAXSource sAXSource = new SAXSource(inputSource);
            if (this.entityResolver != null) {
                object = sAXSource.getXMLReader();
                if (object == null) {
                    object = this.config.getSourceParser();
                }
                object.setEntityResolver(this.entityResolver);
            }
            if (this.errorHandler != null) {
                object = sAXSource.getXMLReader();
                if (object == null) {
                    object = this.config.getSourceParser();
                }
                object.setErrorHandler(this.errorHandler);
            }
            sAXSource.setSystemId(inputSource.getSystemId());
            object = sAXSource;
            if (this.xIncludeAware) {
                object = AugmentedSource.makeAugmentedSource((Source)object);
                ((AugmentedSource)object).setXIncludeAware(true);
            }
            if (this.validating) {
                object = AugmentedSource.makeAugmentedSource((Source)object);
                ((AugmentedSource)object).setDTDValidationMode(1);
            }
            if (this.stripSpace != 13) {
                object = AugmentedSource.makeAugmentedSource((Source)object);
                ((AugmentedSource)object).setStripSpace(this.stripSpace);
            }
            new Sender(pipelineConfiguration).send(sAXSource, tinyBuilder);
            TinyDocumentImpl tinyDocumentImpl = (TinyDocumentImpl)tinyBuilder.getCurrentRoot();
            return (Document)((Object)DocumentOverNodeInfo.wrap(tinyDocumentImpl));
        }
        catch (XPathException xPathException) {
            throw new SAXException(xPathException);
        }
    }

    public Document parse(File file) throws SAXException, IOException {
        if (file == null) {
            throw new IllegalArgumentException("File cannot be null");
        }
        String string = file.toURI().toString();
        InputSource inputSource = new InputSource(string);
        return this.parse(inputSource);
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public DOMImplementation getDOMImplementation() {
        return this.newDocument().getImplementation();
    }

    public void setXIncludeAware(boolean bl) {
        this.xIncludeAware = bl;
    }

    public boolean isXIncludeAware() {
        return this.xIncludeAware;
    }

    public void setStripSpace(int n) {
        this.stripSpace = n;
    }

    public int getStripSpace() {
        return this.stripSpace;
    }
}

