/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.query.Domain;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.util.QueryMapper;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Map1;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelQueryUtil {
    private ModelQueryUtil() {
    }

    public static ExtendedIterator<List<? extends RDFNode>> queryBindingsWith(final Model model, Model query, Resource[] variables) {
        Map1<Domain, List<? extends RDFNode>> mm = new Map1<Domain, List<? extends RDFNode>>(){

            @Override
            public List<? extends RDFNode> map1(Domain x) {
                return ModelQueryUtil.mappy(model, x);
            }
        };
        QueryMapper qm = new QueryMapper(query, variables);
        return qm.getQuery().executeBindings(model.getGraph(), qm.getVariables()).mapWith(mm);
    }

    public static RDFNode asRDF(Model m, Node n) {
        return m.asRDFNode(n);
    }

    public static List<RDFNode> mappy(Model m, Domain L) {
        ArrayList<RDFNode> result = new ArrayList<RDFNode>(L.size());
        for (int i = 0; i < L.size(); ++i) {
            result.add(ModelQueryUtil.asRDF(m, L.get(i)));
        }
        return result;
    }
}

