/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.util.graph;

import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.sparql.util.PlainGraphMem;
import com.hp.hpl.jena.sparql.util.RefBoolean;
import com.hp.hpl.jena.sparql.util.graph.GraphSink;

public class GraphFactory {
    private static RefBoolean usePlainGraph = new RefBoolean(ARQ.strictGraph);

    public static Graph createGraph() {
        return Factory.createGraphMem();
    }

    public static Graph createDefaultGraph() {
        return usePlainGraph.getValue() ? GraphFactory.createPlainGraph() : GraphFactory.createJenaDefaultGraph();
    }

    public static Graph createJenaDefaultGraph() {
        return Factory.createDefaultGraph();
    }

    public static Graph createPlainGraph() {
        return new PlainGraphMem();
    }

    public static Graph sinkGraph() {
        return new GraphSink();
    }

    public static Model makeJenaDefaultModel() {
        return ModelFactory.createDefaultModel();
    }

    public static Model makeDefaultModel() {
        return ModelFactory.createModelForGraph(GraphFactory.createDefaultGraph());
    }

    public static Model makePlainModel() {
        return ModelFactory.createModelForGraph(GraphFactory.createPlainGraph());
    }
}

