/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.util.graph;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.util.ALog;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.Collection;
import java.util.Comparator;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphContainerUtils {
    private static final Node RDFtype = RDF.type.asNode();
    private static final Node BAG = RDF.Bag.asNode();
    private static final Node ALT = RDF.Alt.asNode();
    private static final Node SEQ = RDF.Seq.asNode();
    private static final String membershipPattern = RDF.getURI() + "_(\\d+)";
    private static final int NOT_FOUND = -9999;
    static Pattern pattern = Pattern.compile(membershipPattern);
    static ContainerOrder order = new ContainerOrder();

    public static Collection<Node> containerMembers(Graph graph, Node container2) {
        return GraphContainerUtils.containerMembers(graph, container2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<Node> containerMembers(Graph graph, Node container2, Node containerType) {
        if (!GraphContainerUtils.isContainer(graph, container2, containerType)) {
            return null;
        }
        ExtendedIterator<Triple> iter = graph.find(container2, Node.ANY, Node.ANY);
        TreeMap<Integer, Node> triples = new TreeMap<Integer, Node>(order);
        try {
            while (iter.hasNext()) {
                Triple t = (Triple)iter.next();
                int index = GraphContainerUtils.getIndex(t);
                if (index == -9999) continue;
                triples.put(new Integer(index), t.getObject());
            }
        }
        finally {
            iter.close();
        }
        return triples.values();
    }

    public static boolean isContainerMember(Graph graph, Node container2, Node containerType, Node member) {
        return GraphContainerUtils.countContainerMember(graph, container2, containerType, member, true) != 0;
    }

    public static int countContainerMember(Graph graph, Node container2, Node containerType, Node member) {
        return GraphContainerUtils.countContainerMember(graph, container2, containerType, member, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int countContainerMember(Graph graph, Node container2, Node containerType, Node member, boolean stopEarly) {
        if (graph == null) {
            ALog.warn(GraphContainerUtils.class, "containerMember called with null graph");
            return 0;
        }
        if (container2 == null) {
            ALog.warn(GraphContainerUtils.class, "containerMember called with null list");
            return 0;
        }
        if (member == null) {
            ALog.warn(GraphContainerUtils.class, "containerMember called with null member");
            return 0;
        }
        if (!GraphContainerUtils.isContainer(graph, container2, containerType)) {
            return 0;
        }
        int count = 0;
        ExtendedIterator<Triple> iter = graph.find(container2, Node.ANY, member);
        try {
            block10: {
                while (iter.hasNext()) {
                    Triple t = (Triple)iter.next();
                    Node p = t.getPredicate();
                    String u = p.getURI();
                    if (!u.matches(membershipPattern)) continue;
                    ++count;
                    if (!stopEarly) {
                        continue;
                    }
                    break block10;
                }
                return count;
            }
            int n = count;
            return n;
        }
        finally {
            iter.close();
        }
    }

    public static boolean isContainer(Graph graph, Node container2, Node containerType) {
        if (containerType == null) {
            return GraphContainerUtils.isContainer(graph, container2, BAG) || GraphContainerUtils.isContainer(graph, container2, ALT) || GraphContainerUtils.isContainer(graph, container2, SEQ);
        }
        return graph.contains(container2, RDFtype, containerType);
    }

    private static int getIndex(Triple triple) {
        String u = triple.getPredicate().getURI();
        Matcher m = pattern.matcher(u);
        if (!m.find()) {
            return -9999;
        }
        String index = m.group(1);
        return Integer.parseInt(index);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ContainerOrder
    implements Comparator<Integer> {
        private ContainerOrder() {
        }

        @Override
        public int compare(Integer i1, Integer i2) {
            int index2;
            int index1 = i1;
            if (index1 < (index2 = i2.intValue())) {
                return -1;
            }
            if (index1 > index2) {
                return 1;
            }
            return 0;
        }
    }
}

