/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.util;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.util.StringUtils;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.MapFilter;
import com.hp.hpl.jena.util.iterator.MapFilterIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeUtils {
    public static boolean isStringLiteral(Node literal) {
        if (!literal.isLiteral()) {
            return false;
        }
        RDFDatatype dType = literal.getLiteralDatatype();
        String langTag = literal.getLiteralLanguage();
        if (langTag == null || !langTag.equals("")) {
            return false;
        }
        return dType == null || dType.equals(XSDDatatype.XSDstring);
    }

    public static boolean hasLang(Node node) {
        if (!node.isLiteral()) {
            return false;
        }
        String x = node.getLiteralLanguage();
        if (x == null) {
            return false;
        }
        return !x.equals("");
    }

    public static String stringLiteral(Node literal) {
        if (!NodeUtils.isStringLiteral(literal)) {
            return null;
        }
        return literal.getLiteralLexicalForm();
    }

    public static Iterator<String> nodesToURIs(Iterator<Node> iter) {
        MapFilter<Node, String> mapper = new MapFilter<Node, String>(){

            @Override
            public String accept(Node x) {
                return x.getURI();
            }
        };
        ExtendedIterator<Node> eIter = WrappedIterator.create(iter);
        MapFilterIterator<Node, String> conv = new MapFilterIterator<Node, String>(mapper, eIter);
        return conv;
    }

    public static int compareRDFTerms(Node node1, Node node2) {
        if (node1 == null) {
            if (node2 == null) {
                return 0;
            }
            return -1;
        }
        if (node2 == null) {
            return 1;
        }
        if (node1.isLiteral() && node2.isLiteral()) {
            return NodeUtils.compareLiteralsBySyntax(node1, node2);
        }
        if (node1.isBlank()) {
            if (node2.isBlank()) {
                String s1 = node1.getBlankNodeId().getLabelString();
                String s2 = node2.getBlankNodeId().getLabelString();
                return StringUtils.strCompare(s1, s2);
            }
            return -1;
        }
        if (node2.isBlank()) {
            return 1;
        }
        if (node1.isURI()) {
            if (node2.isURI()) {
                String s1 = node1.getURI();
                String s2 = node2.getURI();
                return StringUtils.strCompare(s1, s2);
            }
            return -1;
        }
        if (node2.isURI()) {
            return 1;
        }
        throw new ARQInternalErrorException("Compare: " + node1 + "  " + node2);
    }

    private static int compareLiteralsBySyntax(Node node1, Node node2) {
        String lex2;
        if (node1 == null || !node1.isLiteral() || node2 == null || !node2.isLiteral()) {
            throw new ARQInternalErrorException("compareLiteralsBySyntax called with non-literal: (" + node1 + "," + node2 + ")");
        }
        if (node1.equals(node2)) {
            return 0;
        }
        String lex1 = node1.getLiteralLexicalForm();
        int x = StringUtils.strCompare(lex1, lex2 = node2.getLiteralLexicalForm());
        if (x != 0) {
            return x;
        }
        String lang1 = node1.getLiteralLanguage();
        String lang2 = node2.getLiteralLanguage();
        String dt1 = node1.getLiteralDatatypeURI();
        String dt2 = node2.getLiteralDatatypeURI();
        if (lang1 == null) {
            throw new ARQInternalErrorException("Language tag is null: " + node1);
        }
        if (lang2 == null) {
            throw new ARQInternalErrorException("Language tag is null: " + node2);
        }
        if (NodeUtils.simpleLiteral(node1)) {
            return -1;
        }
        if (NodeUtils.simpleLiteral(node2)) {
            return 1;
        }
        if (!lang1.equals("") && dt2 != null) {
            return -1;
        }
        if (dt1 != null && !lang2.equals("")) {
            return 1;
        }
        if (dt1 == null && dt2 == null) {
            x = StringUtils.strCompareIgnoreCase(lang1, lang2);
            if (x != 0) {
                return x;
            }
            x = StringUtils.strCompare(lang1, lang2);
            if (x != 0) {
                return x;
            }
            throw new ARQInternalErrorException("compareLiteralsBySyntax: lexical form and languages tags identical on non.equals literals");
        }
        return StringUtils.strCompare(dt1, dt2);
    }

    private static boolean simpleLiteral(Node node) {
        return node.getLiteralDatatypeURI() == null && node.getLiteralLanguage().equals("");
    }
}

