/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprEvalException;
import com.hp.hpl.jena.sparql.expr.ExprFunction2;
import com.hp.hpl.jena.sparql.expr.NodeValue;

public class E_StrDatatype
extends ExprFunction2 {
    private static final String symbol = "strdt";

    public E_StrDatatype(Expr expr1, Expr expr2) {
        super(expr1, expr2, symbol);
    }

    public NodeValue eval(NodeValue v1, NodeValue v2) {
        if (!v1.isString()) {
            throw new ExprEvalException("Not a string (arg 1): " + v1);
        }
        if (!v2.isIRI()) {
            throw new ExprEvalException("Not an IRI (arg 2): " + v2);
        }
        String lex = v1.asString();
        Node dt = v2.asNode();
        Node n = Node.createLiteral(lex, null, Node.getType(dt.getURI()));
        return NodeValue.makeNode(n);
    }

    public Expr copy(Expr expr1, Expr expr2) {
        return new E_StrDatatype(expr1, expr2);
    }
}

