/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.iri.IRI;
import com.hp.hpl.jena.iri.IRIFactory;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprEvalException;
import com.hp.hpl.jena.sparql.expr.ExprFunction1;
import com.hp.hpl.jena.sparql.expr.NodeValue;

public class E_IRI
extends ExprFunction1 {
    private static final String symbol = "IRI";
    private static final IRIFactory iriFactory = IRIFactory.iriImplementation();

    public E_IRI(Expr expr) {
        super(expr, symbol);
    }

    public E_IRI(Expr expr, String altSymbol) {
        super(expr, altSymbol);
    }

    public NodeValue eval(NodeValue v) {
        if (v.isIRI()) {
            return v;
        }
        if (v.isString()) {
            IRI iri = iriFactory.create(v.getString());
            if (!iri.isAbsolute()) {
                throw new ExprEvalException("Relative IRI string: " + v.getString());
            }
            return NodeValue.makeNode(Node.createURI(iri.toString()));
        }
        throw new ExprEvalException("Can't make an IRI from " + v);
    }

    public Expr copy(Expr expr) {
        return new E_IRI(expr);
    }
}

