/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.main;

import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.op.OpExt;
import com.hp.hpl.jena.sparql.algebra.op.OpJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpModifier;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.main.VarFinder;
import com.hp.hpl.jena.sparql.util.SetUtils;
import java.util.Set;

public class JoinClassifier {
    static final boolean print = false;

    public static boolean isLinear(OpJoin join) {
        return JoinClassifier.isLinear(join.getLeft(), join.getRight());
    }

    public static boolean isLinear(Op left, Op right) {
        left = JoinClassifier.effectiveOp(left);
        if ((right = JoinClassifier.effectiveOp(right)) instanceof OpModifier) {
            return false;
        }
        return JoinClassifier.check(left, right);
    }

    private static boolean check(Op op, Op other) {
        VarFinder vfLeft = new VarFinder(op);
        Set<Var> vLeftFixed = vfLeft.getFixed();
        Set<Var> vLeftOpt = vfLeft.getOpt();
        VarFinder vfRight = new VarFinder(other);
        Set<Var> vRightFixed = vfRight.getFixed();
        Set<Var> vRightOpt = vfRight.getOpt();
        Set<Var> vRightFilter = vfRight.getFilter();
        vLeftOpt = SetUtils.difference(vLeftOpt, vLeftFixed);
        vRightOpt = SetUtils.difference(vRightOpt, vRightFixed);
        vRightFilter = SetUtils.difference(vRightFilter, vRightFixed);
        boolean r11 = SetUtils.intersectionP(vRightOpt, vLeftFixed);
        boolean r12 = SetUtils.intersectionP(vRightOpt, vLeftOpt);
        boolean bad1 = r11 || r12;
        boolean bad2 = SetUtils.intersectionP(vRightFilter, vLeftFixed);
        return !bad1 && !bad2;
    }

    public static Op effectiveOp(Op op) {
        if (op instanceof OpExt) {
            op = ((OpExt)op).effectiveOp();
        }
        return op;
    }
}

