/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.http;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecException;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.sparql.algebra.OpAsQuery;
import com.hp.hpl.jena.sparql.algebra.op.OpService;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.http.HttpQuery;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIteratorResultSet;
import java.io.InputStream;

public class Service {
    public static QueryIterator exec(OpService op) {
        if (!op.getService().isURI()) {
            throw new QueryExecException("Service URI not bound: " + op.getService());
        }
        Query query = OpAsQuery.asQuery(op.getSubOp());
        HttpQuery httpQuery = new HttpQuery(op.getService().getURI());
        httpQuery.addParam("query", query.toString());
        httpQuery.setAccept("application/sparql-results+xml");
        InputStream in = httpQuery.exec();
        ResultSet rs = ResultSetFactory.fromXML(in);
        return new QueryIteratorResultSet(rs);
    }
}

