/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.core;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprEvalException;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.function.FunctionEnv;
import com.hp.hpl.jena.sparql.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VarExprList {
    private List<Var> vars;
    private Map<Var, Expr> exprs;

    public VarExprList(List<Var> vars) {
        this.vars = vars;
        this.exprs = new HashMap<Var, Expr>();
    }

    public VarExprList(VarExprList other) {
        this.vars = new ArrayList<Var>(other.vars);
        this.exprs = new HashMap<Var, Expr>(other.exprs);
    }

    public VarExprList() {
        this.vars = new ArrayList<Var>();
        this.exprs = new HashMap<Var, Expr>();
    }

    public List<Var> getVars() {
        return this.vars;
    }

    public Map<Var, Expr> getExprs() {
        return this.exprs;
    }

    public boolean contains(Var var) {
        return this.vars.contains(var);
    }

    public boolean hasExpr(Var var) {
        return this.exprs.containsKey(var);
    }

    public Expr getExpr(Var var) {
        return this.exprs.get(var);
    }

    public Node get(Var var, Binding binding, FunctionEnv funcEnv) {
        Expr expr = this.exprs.get(var);
        if (expr == null) {
            return binding.get(var);
        }
        try {
            NodeValue nv = expr.eval(binding, funcEnv);
            if (nv == null) {
                return null;
            }
            return nv.asNode();
        }
        catch (ExprEvalException ex) {
            return null;
        }
    }

    public void add(Var var) {
        if (!this.vars.contains(var)) {
            this.vars.add(var);
        }
    }

    public void add(Var var, Expr expr) {
        if (var == null) {
            throw new ARQInternalErrorException("Attempt to add a named expression with a null variable");
        }
        if (this.exprs.containsKey(var)) {
            throw new ARQInternalErrorException("Attempt to assign an expression again");
        }
        this.add(var);
        this.exprs.put(var, expr);
    }

    public void addAll(VarExprList other) {
        for (Var v : other.vars) {
            Expr e2 = other.getExpr(v);
            this.add(v, e2);
        }
    }

    public int size() {
        return this.vars.size();
    }

    public boolean isEmpty() {
        return this.vars.isEmpty();
    }

    public int hashCode() {
        int x = ((Object)this.vars).hashCode() ^ ((Object)this.exprs).hashCode();
        return ((Object)this.vars).hashCode() ^ ((Object)this.exprs).hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof VarExprList)) {
            return false;
        }
        VarExprList x = (VarExprList)other;
        return Utils.equal(this.vars, x.vars) && Utils.equal(this.exprs, x.exprs);
    }

    public String toString() {
        return this.vars.toString() + " // " + this.exprs.toString();
    }
}

