/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.sqlparser;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.wso2.carbon.dataservices.core.DataServiceFault;
import org.wso2.carbon.dataservices.core.sqlparser.analysers.AnalyzerFactory;
import org.wso2.carbon.dataservices.core.sqlparser.analysers.KeyWordAnalyzer;
import org.wso2.carbon.dataservices.core.sqlparser.mappers.SelectMapper;

public class SQLParserUtil {
    public static List<String> keyWords = new ArrayList<String>();
    public static List<String> operators = new ArrayList<String>();
    public static List<String> delimiters = new ArrayList<String>();
    public static List<String> specialFunctions = new ArrayList<String>();
    public static List<String> stringFunctions = new ArrayList<String>();
    public static List<String> aggregateFunctions = new ArrayList<String>();

    public static List<String> getKeyWords() {
        return keyWords;
    }

    public static List<String> getOperators() {
        return operators;
    }

    public static List<String> getDelimiters() {
        return delimiters;
    }

    public static List<String> getSpecialFunctions() {
        return specialFunctions;
    }

    public static boolean isAggregateFunction(String token) {
        return aggregateFunctions.contains(token);
    }

    public static boolean isStringFunction(String token) {
        return stringFunctions.contains(token);
    }

    public static Queue<String> getTokens(String sql) {
        StringBuilder token = new StringBuilder();
        LinkedList<String> tokenQueue = new LinkedList<String>();
        char[] inputCharacters = new char[sql.length()];
        sql.getChars(0, sql.length(), inputCharacters, 0);
        for (char c : inputCharacters) {
            if (!delimiters.contains(Character.valueOf(c).toString()) && !operators.contains(Character.valueOf(c).toString())) {
                token.append(c);
                continue;
            }
            if (token.length() > 0) {
                tokenQueue.add(token.toString());
            }
            if (!Character.valueOf(c).toString().equals(" ")) {
                tokenQueue.add("" + c);
            }
            token = new StringBuilder();
        }
        if (token.length() > 0) {
            tokenQueue.add(token.toString());
        }
        return tokenQueue;
    }

    public static List<String> extractOutputColumns(String sql) throws DataServiceFault {
        Queue<String> syntaxQueue = null;
        LinkedList<String> tmpQueue = new LinkedList<String>();
        Queue<String> tokens = SQLParserUtil.getTokens(sql);
        if (!tokens.isEmpty() && tokens.peek().toUpperCase().equals("SELECT")) {
            tokens.poll();
            while (!tokens.isEmpty() && !tokens.peek().toUpperCase().equals("FROM")) {
                tmpQueue.add(tokens.poll());
            }
            KeyWordAnalyzer analyser = AnalyzerFactory.createAnalyzer("SELECT", tmpQueue);
            analyser.analyseStatement();
            syntaxQueue = analyser.getSyntaxQueue();
            tmpQueue.clear();
        }
        tokens.clear();
        return new SelectMapper(syntaxQueue).getColumns();
    }

    public static List<String> extractInputMappingNames(String sql) {
        int paramCount = 0;
        boolean isColon = false;
        ArrayList<String> inputMappings = new ArrayList<String>();
        Queue<String> tokens = SQLParserUtil.getTokens(sql);
        for (String token : tokens) {
            if (token != null && token.startsWith(":")) {
                isColon = true;
                continue;
            }
            if ("?".equals(token)) {
                StringBuilder paramName = new StringBuilder();
                paramName.append("param").append(paramCount);
                inputMappings.add(paramCount, paramName.toString());
                ++paramCount;
            }
            if (!isColon || ",".equals(token) || inputMappings.contains(token)) continue;
            inputMappings.add(paramCount, token);
            isColon = false;
            ++paramCount;
        }
        return inputMappings;
    }

    static {
        keyWords.add("COUNT");
        keyWords.add("SELECT");
        keyWords.add("FROM");
        keyWords.add("WHERE");
        keyWords.add("MAX");
        keyWords.add("INSERT");
        keyWords.add("INTO");
        keyWords.add("VALUES");
        keyWords.add("GROUP BY");
        keyWords.add("ORDER_BY");
        keyWords.add("DISTINCT");
        keyWords.add("UPDATE");
        keyWords.add("SET");
        keyWords.add("IN");
        keyWords.add("AND");
        keyWords.add("DELAYED");
        keyWords.add("LOW_PRIORITY");
        keyWords.add("HIGH_PRIORITY");
        keyWords.add("ON");
        keyWords.add("DUPLICATE");
        keyWords.add("KEY");
        keyWords.add("LAST_INSERT_ID");
        keyWords.add("ALL");
        keyWords.add("DISTINCTROW");
        keyWords.add("STRAIGHT_JOIN");
        keyWords.add("SQL_SMALL_RESULT");
        keyWords.add("SQL_BIG_RESULT");
        keyWords.add("SQL_BUFFER_RESULT");
        keyWords.add("SQL_CACHE");
        keyWords.add("SQL_NO_CACHE");
        keyWords.add("SQL_CALC_FOUND_ROWS");
        keyWords.add("ASC");
        keyWords.add("DESC");
        keyWords.add("OFFSET");
        keyWords.add("LIMIT");
        keyWords.add("WITH");
        keyWords.add("ROLLUP");
        keyWords.add("PROCEDURE");
        keyWords.add("OUTFILE");
        keyWords.add("DUMPFILE");
        keyWords.add("LOCK");
        keyWords.add("SHARE");
        keyWords.add("MODE");
        keyWords.add("CONCAT");
        keyWords.add("AS");
        keyWords.add("AVG");
        keyWords.add("MIN");
        keyWords.add("IS");
        keyWords.add("NULL");
        keyWords.add("LIKE");
        keyWords.add("OR");
        keyWords.add("JOIN");
        keyWords.add("INNER");
        keyWords.add("SUM");
        operators.add("=");
        operators.add("-");
        operators.add("+");
        operators.add("/");
        operators.add("*");
        operators.add(">");
        operators.add("/");
        delimiters.add(",");
        delimiters.add("<");
        delimiters.add("'");
        delimiters.add(";");
        delimiters.add(":");
        delimiters.add(".");
        delimiters.add("{");
        delimiters.add("(");
        delimiters.add("}");
        delimiters.add(")");
        delimiters.add("`");
        delimiters.add(" ");
        aggregateFunctions.add("AVG");
        aggregateFunctions.add("MAX");
        aggregateFunctions.add("MIN");
        aggregateFunctions.add("COUNT");
        aggregateFunctions.add("SUM");
        stringFunctions.add("TRIM");
        stringFunctions.add("RTRIM");
        stringFunctions.add("LTRIM");
        stringFunctions.add("SUBSTR");
        stringFunctions.add("CONCAT");
        specialFunctions.add("OR");
        specialFunctions.add("AND");
        specialFunctions.add("IS");
        specialFunctions.add("LIKE");
        specialFunctions.add("NOT");
        specialFunctions.add("NULL");
        specialFunctions.add("IN");
    }
}

