/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.script;

import java.util.ArrayList;
import java.util.List;

public class DynamicSqlUtils {
    public String getSelectAll(String tableName, String colomNames) {
        StringBuffer statement = new StringBuffer();
        statement.append("SELECT" + colomNames + "  FROM ");
        statement.append(tableName);
        return new String(statement);
    }

    public String getSelectByKey(String tableName, String pKey, String colomNames) {
        StringBuffer statement = new StringBuffer();
        statement.append("SELECT " + colomNames + " FROM ");
        statement.append(tableName);
        statement.append(" WHERE ");
        statement.append(pKey).append("=?");
        return new String(statement);
    }

    public String getInsertStatement(String tableName, List<String> param) {
        StringBuffer statement = new StringBuffer();
        statement.append("INSERT INTO ");
        statement.append(tableName);
        statement.append("(");
        int last = param.size();
        int index = 1;
        for (String par : param) {
            statement.append(par);
            if (index != last) {
                statement.append(",");
            }
            ++index;
        }
        statement.append(")");
        statement.append(" VALUES");
        statement.append("(");
        index = 1;
        for (String par : param) {
            statement.append('?');
            if (index != last) {
                statement.append(",");
            }
            ++index;
        }
        statement.append(")");
        return new String(statement);
    }

    public String getUpdateStatement(String tableName, List<String> param2, String pKey) {
        ArrayList<String> param = new ArrayList<String>();
        for (String par : param2) {
            if (par.equals(pKey)) continue;
            param.add(par);
        }
        StringBuffer statement = new StringBuffer();
        statement.append("UPDATE ");
        statement.append(tableName);
        statement.append(" SET ");
        int last = param.size();
        int index = 1;
        for (String par : param) {
            statement.append(par).append("=?");
            if (index != last) {
                statement.append(",");
            }
            ++index;
        }
        statement.append(" WHERE ");
        statement.append(pKey).append("=?");
        return new String(statement);
    }

    public String getDeleteStatement(String tableName, String pKey) {
        StringBuffer statement = new StringBuffer();
        statement.append("DELETE FROM ");
        statement.append(tableName);
        statement.append(" WHERE ");
        statement.append(pKey).append("=?");
        return new String(statement);
    }

    public String getProcedureInvokeStatement(String proceName) {
        return "call " + proceName + "(?)";
    }
}

