/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.engine;

import java.sql.Array;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axis2.databinding.types.NCName;
import org.wso2.carbon.dataservices.common.DBConstants;
import org.wso2.carbon.dataservices.core.DBUtils;
import org.wso2.carbon.dataservices.core.DSSessionManager;
import org.wso2.carbon.dataservices.core.DataServiceFault;
import org.wso2.carbon.dataservices.core.boxcarring.TLParamStore;
import org.wso2.carbon.dataservices.core.engine.DataService;
import org.wso2.carbon.dataservices.core.engine.ExternalParam;
import org.wso2.carbon.dataservices.core.engine.ExternalParamCollection;
import org.wso2.carbon.dataservices.core.engine.OutputElement;
import org.wso2.carbon.dataservices.core.engine.ParamValue;

public class StaticOutputElement
extends OutputElement {
    private String name;
    private String param;
    private String originalParam;
    private String paramType;
    private String elementType;
    private QName xsdType;
    private Set<String> requiredRoles;
    private int resultType;
    private int dataCategory;
    private String export;
    private int exportType;
    private boolean hasConstantValue;
    private String arrayName;
    private boolean isUserDefinedObj;
    private UDT udtInfo;

    public StaticOutputElement(DataService dataService, String name, String param, String originalParam, String paramType, String elementType, String namespace, QName xsdType, Set<String> requiredRoles, int dataCategory, int resultType, String export, int exportType, String arrayName) throws DataServiceFault {
        super(namespace);
        this.name = name;
        this.param = param;
        this.originalParam = originalParam;
        this.paramType = paramType;
        this.elementType = elementType;
        this.xsdType = xsdType;
        this.requiredRoles = requiredRoles;
        this.dataCategory = dataCategory;
        this.resultType = resultType;
        this.export = export;
        this.exportType = exportType;
        this.hasConstantValue = "value".equals(paramType);
        this.arrayName = arrayName;
        this.udtInfo = this.processParamForUserDefinedObjects(this.getParam());
        if (this.getArrayName() != null || this.getUDTInfo() != null) {
            this.isUserDefinedObj = true;
        }
        if (!NCName.isValid((String)this.name)) {
            throw new DataServiceFault("Invalid output " + this.elementType + " name: '" + this.name + "', must be an NCName.");
        }
    }

    @Override
    public String getArrayName() {
        return this.arrayName;
    }

    public boolean hasConstantValue() {
        return this.hasConstantValue;
    }

    public String getExport() {
        return this.export;
    }

    public int getExportType() {
        return this.exportType;
    }

    public int getDataCategory() {
        return this.dataCategory;
    }

    public int getResultType() {
        return this.resultType;
    }

    public String getOriginalParam() {
        return this.originalParam;
    }

    @Override
    public Set<String> getRequiredRoles() {
        return this.requiredRoles;
    }

    @Override
    public boolean isOptional() {
        return this.getRequiredRoles() != null && this.getRequiredRoles().size() > 0;
    }

    public QName getXsdType() {
        return this.xsdType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getParam() {
        return this.param;
    }

    @Override
    public String getParamType() {
        return this.paramType;
    }

    public String getElementType() {
        return this.elementType;
    }

    public boolean isUserDefinedObj() {
        return this.isUserDefinedObj;
    }

    public UDT getUDTInfo() {
        return this.udtInfo;
    }

    private UDT processParamForUserDefinedObjects(String param) throws DataServiceFault {
        String udtColumnName = DBUtils.extractUDTObjectName(param);
        if (udtColumnName != null) {
            List<Integer> indices = DBUtils.getNestedIndices(param.substring(udtColumnName.length() + 1, param.length()));
            return new UDT(udtColumnName, indices);
        }
        return null;
    }

    private ParamValue getParamValue(ExternalParamCollection params) throws DataServiceFault {
        if (this.getParamType().equals("rdf-ref-uri")) {
            return new ParamValue(this.getParam());
        }
        ExternalParam paramObj = this.getParamObj(params);
        if (paramObj == null) {
            if (this.getParamType().equals("column")) {
                paramObj = params.getParam("query-param", this.getParam());
            } else if (this.getParamType().equals("query-param")) {
                paramObj = params.getParam("column", this.getParam());
            }
        }
        if (paramObj != null) {
            return paramObj.getValue();
        }
        throw new DataServiceFault(DBConstants.FaultCodes.INCOMPATIBLE_PARAMETERS_ERROR, "Error in 'StaticOutputElement.execute', cannot find parameter with type:" + this.getParamType() + " name:" + this.getOriginalParam());
    }

    private void exportParam(String exportName, String value, int type) {
        ParamValue paramVal = TLParamStore.getParam(exportName);
        if (paramVal == null || paramVal.getValueType() != type) {
            paramVal = new ParamValue(type);
            TLParamStore.addParam(exportName, paramVal);
        }
        if (type == 2) {
            paramVal.addToArrayValue(new ParamValue(value));
        } else if (type == 1) {
            paramVal.setScalarValue(value);
        }
    }

    @Override
    public void executeElement(XMLStreamWriter xmlWriter, ExternalParamCollection params, int queryLevel) throws DataServiceFault {
        ParamValue paramValue = this.hasConstantValue() ? new ParamValue(this.getParam()) : this.getParamValue(params);
        if (this.getExport() != null && DSSessionManager.isBoxcarring()) {
            this.exportParam(this.getExport(), paramValue.toString(), this.getExportType());
        }
        try {
            if (this.getElementType().equals("element")) {
                this.writeResultElement(xmlWriter, this.getName(), paramValue, this.getXsdType(), this.getDataCategory(), this.getResultType(), params);
            } else if (this.getElementType().equals("attribute")) {
                this.addAttribute(xmlWriter, this.getName(), paramValue, this.getXsdType(), this.getResultType());
            }
        }
        catch (XMLStreamException e) {
            throw new DataServiceFault(e, "Error in XML generation at StaticOutputElement.execute");
        }
    }

    private ExternalParam getParamObj(ExternalParamCollection params) throws DataServiceFault {
        ExternalParam exParam = params.getParam(this.getParamType(), this.getParam());
        if (exParam != null) {
            return exParam;
        }
        if (this.isUserDefinedObj()) {
            exParam = params.getParam(this.getParamType(), this.getUDTInfo().getUDTObjName());
            ParamValue value = exParam.getValue();
            if (DBUtils.isUDT(value)) {
                ParamValue processedParamValue = this.getUDTAttributeValue(value, 0);
                return new ExternalParam(this.getParam(), processedParamValue, this.getParamType());
            }
            if (DBUtils.isSQLArray(value)) {
                ParamValue processedParamValue = new ParamValue(2);
                this.getExternalParamFromArray(processedParamValue, value);
                return new ExternalParam(this.getParam(), processedParamValue, this.getParamType());
            }
        }
        return exParam;
    }

    private void getExternalParamFromArray(ParamValue processedParamValue, ParamValue rawParamValue) throws DataServiceFault {
        for (ParamValue value : rawParamValue.getArrayValue()) {
            if (DBUtils.isUDT(value)) {
                processedParamValue.getArrayValue().add(this.getUDTAttributeValue(value, 0));
            }
            if (DBUtils.isSQLArray(value)) {
                this.getExternalParamFromArray(processedParamValue, value);
                continue;
            }
            processedParamValue.getArrayValue().add(value);
        }
    }

    private ParamValue getUDTAttributeValue(ParamValue value, int i) throws DataServiceFault {
        if (this.getUDTInfo() == null) {
            throw new DataServiceFault("Output element '" + this.getName() + "' cannot be resolved to a UDT");
        }
        List<Integer> indices = this.getUDTInfo().getIndices();
        if (DBUtils.isUDT(value)) {
            Object tmpVal;
            try {
                tmpVal = value.getUdt().getAttributes()[indices.get(i)];
            }
            catch (SQLException e) {
                throw new DataServiceFault(e, "Unable to retrieve UDT attribute value referred by the given index");
            }
            if (tmpVal instanceof Struct) {
                value = new ParamValue((Struct)tmpVal);
            } else if (tmpVal instanceof Array) {
                try {
                    value = DBUtils.processSQLArray((Array)tmpVal, new ParamValue(2));
                }
                catch (SQLException e) {
                    throw new DataServiceFault(e, "Unable to process the SQL Array");
                }
            } else {
                value = new ParamValue(String.valueOf(tmpVal));
            }
        } else if (DBUtils.isSQLArray(value)) {
            ParamValue processedParamValue = new ParamValue(2);
            for (ParamValue paramVal : value.getArrayValue()) {
                if (DBUtils.isUDT(paramVal)) {
                    try {
                        processedParamValue.getArrayValue().add(new ParamValue(String.valueOf(paramVal.getUdt().getAttributes()[indices.get(i)])));
                        continue;
                    }
                    catch (SQLException e) {
                        throw new DataServiceFault(e, "Unable to retrieve UDT attribute value referred by the given index");
                    }
                }
                processedParamValue.getArrayValue().add(paramVal);
            }
            value = processedParamValue;
        } else {
            return value;
        }
        if (i <= indices.size()) {
            return this.getUDTAttributeValue(value, i + 1);
        }
        return value;
    }

    public boolean equals(Object o) {
        return o instanceof StaticOutputElement && ((StaticOutputElement)o).getName().equals(this.getName());
    }

    private class UDT {
        private String udtObjName;
        private List<Integer> indices;

        public UDT(String udtObjName, List<Integer> indices) {
            this.udtObjName = udtObjName;
            this.indices = indices;
        }

        public String getUDTObjName() {
            return this.udtObjName;
        }

        public List<Integer> getIndices() {
            return this.indices;
        }
    }
}

