/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.engine;

import java.sql.SQLException;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ParamValue {
    public static final int PARAM_VALUE_SCALAR = 1;
    public static final int PARAM_VALUE_ARRAY = 2;
    public static final int PARAM_VALUE_UDT = 3;
    private int valueType;
    private List<ParamValue> arrayValue;
    private String scalarValue;
    private Struct udt;
    private static final Log log = LogFactory.getLog(ParamValue.class);

    public ParamValue(int valueType) {
        this.valueType = valueType;
        this.scalarValue = null;
        this.arrayValue = new ArrayList<ParamValue>();
        this.udt = null;
    }

    public ParamValue(String scalarValue) {
        this.valueType = 1;
        this.scalarValue = scalarValue;
    }

    public ParamValue(Struct udt) {
        this.valueType = 3;
        this.udt = udt;
    }

    public static ParamValue convertFromScalarToArray(ParamValue value) {
        ParamValue newVal = new ParamValue(2);
        newVal.addArrayValue(value);
        return newVal;
    }

    public int getValueType() {
        return this.valueType;
    }

    public String getScalarValue() {
        if (this.getValueType() == 1) {
            return this.scalarValue;
        }
        if (this.getValueType() == 2) {
            if (this.getArrayValue().size() > 0) {
                return this.arrayValue.get(0).getScalarValue();
            }
            return null;
        }
        return null;
    }

    public String getValueAsString() {
        if (this.getValueType() == 1) {
            return this.getScalarValue();
        }
        if (this.getValueType() == 2) {
            StringBuffer strBuff = new StringBuffer();
            strBuff.append("{");
            for (int i = 0; i < this.arrayValue.size(); ++i) {
                strBuff.append(this.arrayValue.get(i));
                if (i + 1 >= this.arrayValue.size()) continue;
                strBuff.append(",");
            }
            strBuff.append("}");
            return strBuff.toString();
        }
        if (this.getValueType() == 3) {
            String udtName = null;
            try {
                udtName = this.udt.getSQLTypeName();
                if (this.udt.getAttributes() != null) {
                    Object[] udtValues = this.udt.getAttributes();
                    StringBuilder strBuilder = new StringBuilder();
                    strBuilder.append("{");
                    for (int i = 0; i < udtValues.length; ++i) {
                        strBuilder.append(udtValues[i]);
                        if (i + 1 >= udtValues.length) continue;
                        strBuilder.append(",");
                    }
                    strBuilder.append("}");
                    return strBuilder.toString();
                }
                return null;
            }
            catch (SQLException e) {
                String errMessage = "Unable to retrieve values from UDT " + udtName;
                log.error((Object)errMessage, (Throwable)e);
                return null;
            }
        }
        return null;
    }

    public String toString() {
        return this.getValueAsString();
    }

    public void addToArrayValue(ParamValue arrayElement) {
        try {
            this.arrayValue.add(arrayElement);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Trying to add value'" + arrayElement + "' added to an non-array type ParamValue");
        }
    }

    public void setScalarValue(String scalarValue) {
        this.scalarValue = scalarValue;
    }

    public void setArrayValue(List<ParamValue> arrayValue) {
        this.arrayValue = arrayValue;
    }

    public List<ParamValue> getArrayValue() {
        return this.arrayValue;
    }

    public void addArrayValue(ParamValue value) {
        this.arrayValue.add(value);
    }

    public Struct getUdt() {
        return this.udt;
    }
}

