/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.engine;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class DSWrappedXMLStreamWriter
implements XMLStreamWriter {
    private static final int EVENT_SET_DEFAULT_NAMESPACE = 1;
    private static final int EVENT_SET_NAMESPACE_CONTEXT = 2;
    private static final int EVENT_SET_PREFIX = 3;
    private static final int EVENT_WRITE_ATTRIBUTE2 = 4;
    private static final int EVENT_WRITE_ATTRIBUTE3 = 5;
    private static final int EVENT_WRITE_ATTRIBUTE4 = 6;
    private static final int EVENT_WRITE_CDATA = 7;
    private static final int EVENT_WRITE_CHARACTERS1 = 8;
    private static final int EVENT_WRITE_CHARACTERS3 = 9;
    private static final int EVENT_WRITE_COMMENT = 10;
    private static final int EVENT_WRITE_DTD = 11;
    private static final int EVENT_WRITE_DEFAULT_NAMESPACE = 12;
    private static final int EVENT_WRITE_EMPTY_ELEMENT1 = 13;
    private static final int EVENT_WRITE_EMPTY_ELEMENT2 = 14;
    private static final int EVENT_WRITE_EMPTY_ELEMENT3 = 15;
    private static final int EVENT_WRITE_END_ELEMENT = 16;
    private static final int EVENT_WRITE_END_DOCUMENT = 17;
    private static final int EVENT_WRITE_ENTITY_REF = 18;
    private static final int EVENT_WRITE_NAMESPACE = 19;
    private static final int EVENT_WRITE_PROCESSING_INSTRUCTION1 = 20;
    private static final int EVENT_WRITE_PROCESSING_INSTRUCTION2 = 21;
    private static final int EVENT_WRITE_START_DOCUMENT = 22;
    private static final int EVENT_WRITE_START_DOCUMENT1 = 23;
    private static final int EVENT_WRITE_START_DOCUMENT2 = 24;
    private static final int EVENT_WRITE_START_ELEMENT1 = 25;
    private static final int EVENT_WRITE_START_ELEMENT2 = 26;
    private static final int EVENT_WRITE_START_ELEMENT3 = 27;
    private static final int EVENT_FLUSH = 28;
    private static final int EVENT_CLOSE = 29;
    private static final long BUFFER_LIMIT = 200L;
    private static final int INIT_BUFFERRED_EVENT_LIST_SIZE = 30;
    private List<XMLEvent> bufferedEventList;
    private XMLStreamWriter xmlWriter;
    private boolean isBufferring;
    private long dataCount;

    public DSWrappedXMLStreamWriter(XMLStreamWriter xmlWriter) {
        this.xmlWriter = xmlWriter;
        this.bufferedEventList = new ArrayList<XMLEvent>(30);
        this.isBufferring = true;
    }

    private void addEvent(XMLEvent event) throws XMLStreamException {
        this.bufferedEventList.add(event);
        switch (event.eventType) {
            case 4: {
                if (event.values[1] == null) break;
                this.dataCount += (long)((String)event.values[1]).length();
                break;
            }
            case 5: {
                if (event.values[2] == null) break;
                this.dataCount += (long)((String)event.values[2]).length();
                break;
            }
            case 6: {
                if (event.values[3] == null) break;
                this.dataCount += (long)((String)event.values[3]).length();
                break;
            }
            case 8: {
                if (event.values[0] == null) break;
                this.dataCount += (long)((String)event.values[0]).length();
                break;
            }
            case 9: {
                if (event.values[0] == null) break;
                this.dataCount += (long)((char[])event.values[0]).length;
                break;
            }
            case 7: {
                if (event.values[0] == null) break;
                this.dataCount += (long)((String)event.values[0]).length();
            }
        }
        if (this.dataCount > 200L) {
            this.finalizeBuffering();
        }
    }

    public XMLStreamWriter getXMLWriter() {
        return this.xmlWriter;
    }

    @Override
    public void close() throws XMLStreamException {
        if (this.isBufferring) {
            this.addEvent(new XMLEvent(29, new Object[0]));
            this.finalizeBuffering();
        } else {
            this.xmlWriter.close();
        }
    }

    @Override
    public void flush() throws XMLStreamException {
        if (this.isBufferring) {
            this.addEvent(new XMLEvent(28, new Object[0]));
            this.finalizeBuffering();
        } else {
            this.xmlWriter.flush();
        }
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.xmlWriter.getNamespaceContext();
    }

    @Override
    public String getPrefix(String uri) throws XMLStreamException {
        return this.xmlWriter.getPrefix(uri);
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        return this.xmlWriter.getProperty(name);
    }

    @Override
    public void setDefaultNamespace(String uri) throws XMLStreamException {
        if (this.isBufferring) {
            this.addEvent(new XMLEvent(1, uri));
        } else {
            this.xmlWriter.setDefaultNamespace(uri);
        }
    }

    @Override
    public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
        if (this.isBufferring) {
            this.addEvent(new XMLEvent(2, context));
        } else {
            this.xmlWriter.setNamespaceContext(context);
        }
    }

    @Override
    public void setPrefix(String prefix, String uri) throws XMLStreamException {
        if (this.isBufferring) {
            this.addEvent(new XMLEvent(3, prefix, uri));
        } else {
            this.xmlWriter.setPrefix(prefix, uri);
        }
    }

    @Override
    public void writeAttribute(String localName, String value) throws XMLStreamException {
        if (value != null) {
            if (this.isBufferring) {
                this.addEvent(new XMLEvent(4, localName, value));
            } else {
                this.xmlWriter.writeAttribute(localName, value);
            }
        }
    }

    @Override
    public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
        if (value != null) {
            if (this.isBufferring) {
                this.addEvent(new XMLEvent(5, namespaceURI, localName, value));
            } else {
                this.xmlWriter.writeAttribute(namespaceURI, localName, value);
            }
        }
    }

    @Override
    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
        if (value != null) {
            if (this.isBufferring) {
                this.addEvent(new XMLEvent(6, prefix, namespaceURI, localName, value));
            } else {
                this.xmlWriter.writeAttribute(prefix, namespaceURI, localName, value);
            }
        }
    }

    @Override
    public void writeCData(String data) throws XMLStreamException {
        if (this.isBufferring) {
            this.addEvent(new XMLEvent(7, data));
        } else {
            this.xmlWriter.writeCData(data);
        }
    }

    @Override
    public void writeCharacters(String text) throws XMLStreamException {
        if (this.isBufferring) {
            this.addEvent(new XMLEvent(8, text));
        } else {
            this.xmlWriter.writeCharacters(text);
        }
    }

    @Override
    public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
        if (this.isBufferring) {
            this.addEvent(new XMLEvent(9, text, start, len));
        } else {
            this.xmlWriter.writeCharacters(text, start, len);
        }
    }

    @Override
    public void writeComment(String data) throws XMLStreamException {
        if (this.isBufferring) {
            this.addEvent(new XMLEvent(10, data));
        } else {
            this.xmlWriter.writeComment(data);
        }
    }

    @Override
    public void writeDTD(String dtd) throws XMLStreamException {
        if (this.isBufferring) {
            this.addEvent(new XMLEvent(11, dtd));
        } else {
            this.xmlWriter.writeDTD(dtd);
        }
    }

    @Override
    public void writeDefaultNamespace(String namespaceURI) throws XMLStreamException {
        if (this.isBufferring) {
            this.addEvent(new XMLEvent(12, namespaceURI));
        } else {
            this.xmlWriter.writeDefaultNamespace(namespaceURI);
        }
    }

    @Override
    public void writeEmptyElement(String localName) throws XMLStreamException {
        if (this.isBufferring) {
            this.addEvent(new XMLEvent(13, localName));
        } else {
            this.xmlWriter.writeEmptyElement(localName);
        }
    }

    @Override
    public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
        if (this.isBufferring) {
            this.addEvent(new XMLEvent(14, namespaceURI, localName));
        } else {
            this.xmlWriter.writeEmptyElement(namespaceURI, localName);
        }
    }

    @Override
    public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        if (this.isBufferring) {
            this.addEvent(new XMLEvent(15, prefix, localName, namespaceURI));
        } else {
            this.xmlWriter.writeEmptyElement(prefix, localName, namespaceURI);
        }
    }

    @Override
    public void writeEndDocument() throws XMLStreamException {
        if (this.isBufferring) {
            this.addEvent(new XMLEvent(17, new Object[0]));
            this.writeOutInitialXMLEvents();
            this.isBufferring = false;
        } else {
            this.xmlWriter.writeEndDocument();
        }
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        if (this.isBufferring) {
            this.addEvent(new XMLEvent(16, new Object[0]));
        } else {
            this.xmlWriter.writeEndElement();
        }
    }

    @Override
    public void writeEntityRef(String name) throws XMLStreamException {
        if (this.isBufferring) {
            this.addEvent(new XMLEvent(18, name));
        } else {
            this.xmlWriter.writeEntityRef(name);
        }
    }

    @Override
    public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
        if (this.isBufferring) {
            this.addEvent(new XMLEvent(19, prefix, namespaceURI));
        } else {
            this.xmlWriter.writeNamespace(prefix, namespaceURI);
        }
    }

    @Override
    public void writeProcessingInstruction(String target) throws XMLStreamException {
        if (this.isBufferring) {
            this.addEvent(new XMLEvent(20, target));
        } else {
            this.xmlWriter.writeProcessingInstruction(target);
        }
    }

    @Override
    public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
        if (this.isBufferring) {
            this.addEvent(new XMLEvent(21, target, data));
        } else {
            this.xmlWriter.writeProcessingInstruction(target, data);
        }
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
        if (this.isBufferring) {
            this.addEvent(new XMLEvent(22, new Object[0]));
        } else {
            this.xmlWriter.writeStartDocument();
        }
    }

    @Override
    public void writeStartDocument(String version) throws XMLStreamException {
        if (this.isBufferring) {
            this.addEvent(new XMLEvent(23, version));
        } else {
            this.xmlWriter.writeStartDocument(version);
        }
    }

    @Override
    public void writeStartDocument(String encoding, String version) throws XMLStreamException {
        if (this.isBufferring) {
            this.addEvent(new XMLEvent(24, encoding, version));
        } else {
            this.xmlWriter.writeStartDocument(encoding, version);
        }
    }

    @Override
    public void writeStartElement(String localName) throws XMLStreamException {
        if (this.isBufferring) {
            this.addEvent(new XMLEvent(25, localName));
        } else {
            this.xmlWriter.writeStartElement(localName);
        }
    }

    @Override
    public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        if (this.isBufferring) {
            this.addEvent(new XMLEvent(26, namespaceURI, localName));
        } else {
            this.xmlWriter.writeStartElement(namespaceURI, localName);
        }
    }

    @Override
    public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        if (this.isBufferring) {
            this.addEvent(new XMLEvent(27, prefix, localName, namespaceURI));
        } else {
            this.xmlWriter.writeStartElement(prefix, localName, namespaceURI);
        }
    }

    private static void writeXMLEvent(XMLEvent event, XMLStreamWriter targetXMLWriter) throws XMLStreamException {
        switch (event.eventType) {
            case 29: {
                targetXMLWriter.close();
                break;
            }
            case 28: {
                targetXMLWriter.flush();
                break;
            }
            case 1: {
                targetXMLWriter.setDefaultNamespace((String)event.values[0]);
                break;
            }
            case 2: {
                targetXMLWriter.setNamespaceContext((NamespaceContext)event.values[0]);
                break;
            }
            case 3: {
                targetXMLWriter.setPrefix((String)event.values[0], (String)event.values[1]);
                break;
            }
            case 4: {
                targetXMLWriter.writeAttribute((String)event.values[0], (String)event.values[1]);
                break;
            }
            case 5: {
                targetXMLWriter.writeAttribute((String)event.values[0], (String)event.values[1], (String)event.values[2]);
                break;
            }
            case 6: {
                targetXMLWriter.writeAttribute((String)event.values[0], (String)event.values[1], (String)event.values[2], (String)event.values[3]);
                break;
            }
            case 7: {
                targetXMLWriter.writeCData((String)event.values[0]);
                break;
            }
            case 8: {
                if (event.values[0] == null) break;
                targetXMLWriter.writeCharacters((String)event.values[0]);
                break;
            }
            case 9: {
                targetXMLWriter.writeCharacters((char[])event.values[0], (Integer)event.values[1], (Integer)event.values[2]);
                break;
            }
            case 10: {
                targetXMLWriter.writeComment((String)event.values[0]);
                break;
            }
            case 12: {
                targetXMLWriter.writeDefaultNamespace((String)event.values[0]);
                break;
            }
            case 11: {
                targetXMLWriter.writeDTD((String)event.values[0]);
                break;
            }
            case 13: {
                targetXMLWriter.writeEmptyElement((String)event.values[0]);
                break;
            }
            case 14: {
                targetXMLWriter.writeEmptyElement((String)event.values[0], (String)event.values[1]);
                break;
            }
            case 15: {
                targetXMLWriter.writeEmptyElement((String)event.values[0], (String)event.values[1], (String)event.values[2]);
                break;
            }
            case 17: {
                targetXMLWriter.writeEndDocument();
                break;
            }
            case 16: {
                targetXMLWriter.writeEndElement();
                break;
            }
            case 18: {
                targetXMLWriter.writeEntityRef((String)event.values[0]);
                break;
            }
            case 19: {
                targetXMLWriter.writeNamespace((String)event.values[0], (String)event.values[1]);
                break;
            }
            case 20: {
                targetXMLWriter.writeProcessingInstruction((String)event.values[0]);
                break;
            }
            case 21: {
                targetXMLWriter.writeProcessingInstruction((String)event.values[0], (String)event.values[1]);
                break;
            }
            case 22: {
                targetXMLWriter.writeStartDocument();
                break;
            }
            case 23: {
                targetXMLWriter.writeStartDocument((String)event.values[0]);
                break;
            }
            case 24: {
                targetXMLWriter.writeStartDocument((String)event.values[0], (String)event.values[1]);
                break;
            }
            case 25: {
                targetXMLWriter.writeStartElement((String)event.values[0]);
                break;
            }
            case 26: {
                targetXMLWriter.writeStartElement((String)event.values[0], (String)event.values[1]);
                break;
            }
            case 27: {
                targetXMLWriter.writeStartElement((String)event.values[0], (String)event.values[1], (String)event.values[2]);
            }
        }
    }

    private void finalizeBuffering() throws XMLStreamException {
        this.writeOutInitialXMLEvents();
        this.isBufferring = false;
    }

    private void writeOutInitialXMLEvents() throws XMLStreamException {
        for (XMLEvent event : this.bufferedEventList) {
            DSWrappedXMLStreamWriter.writeXMLEvent(event, this.xmlWriter);
        }
    }

    private class XMLEvent {
        public int eventType;
        public Object[] values;

        public XMLEvent(int eventType, Object ... values) {
            this.eventType = eventType;
            this.values = values;
        }
    }
}

