/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.engine;

import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.wso2.carbon.dataservices.core.DataServiceFault;
import org.wso2.carbon.dataservices.core.description.query.Query;
import org.wso2.carbon.dataservices.core.engine.CallQuery;
import org.wso2.carbon.dataservices.core.engine.ExternalParamCollection;
import org.wso2.carbon.dataservices.core.engine.OutputElement;

public class CallQueryGroup
extends OutputElement {
    private List<CallQuery> callQueries;
    private boolean hasResult;
    private String resultWrapper;
    private boolean isInit;

    public CallQueryGroup(List<CallQuery> callQueries) {
        super(null);
        this.callQueries = callQueries;
    }

    public void init() throws DataServiceFault {
        if (!this.isInit) {
            for (CallQuery callQuery : this.getCallQueries()) {
                callQuery.init();
            }
            CallQuery defaultCQ = this.getDefaultCallQuery();
            if (defaultCQ != null) {
                Query defaultQuery = defaultCQ.getQuery();
                this.setNamespace(defaultQuery.getNamespace());
                this.hasResult = defaultQuery.hasResult();
                if (defaultQuery.hasResult()) {
                    this.resultWrapper = defaultQuery.getResult().getElementName();
                    if (this.resultWrapper != null && this.resultWrapper.trim().length() == 0) {
                        this.resultWrapper = null;
                    }
                }
            }
            this.isInit = true;
        }
    }

    public CallQuery getDefaultCallQuery() {
        if (this.getCallQueries().size() > 0) {
            return this.getCallQueries().get(0);
        }
        return null;
    }

    public boolean isHasResult() {
        return this.hasResult;
    }

    public String getResultWrapper() {
        return this.resultWrapper;
    }

    public List<CallQuery> getCallQueries() {
        return this.callQueries;
    }

    @Override
    protected void executeElement(XMLStreamWriter xmlWriter, ExternalParamCollection params, int queryLevel) throws DataServiceFault {
        try {
            if (this.isHasResult()) {
                this.startWrapperElement(xmlWriter, this.getNamespace(), this.getResultWrapper(), this.getDefaultCallQuery().getQuery().getResult().getResultType());
            }
            List<CallQuery> callQueries = this.getCallQueries();
            for (CallQuery callQuery : callQueries) {
                callQuery.executeElement(xmlWriter, params, queryLevel);
            }
            if (this.isHasResult() && this.getResultWrapper() != null) {
                this.endElement(xmlWriter);
            }
        }
        catch (XMLStreamException e) {
            throw new DataServiceFault(e, "Error in CallQueryGroup.execute");
        }
    }

    @Override
    public boolean isOptional() {
        CallQuery defaultCQ = this.getDefaultCallQuery();
        if (defaultCQ != null) {
            return defaultCQ.isOptional();
        }
        return false;
    }

    @Override
    public Set<String> getRequiredRoles() {
        CallQuery defaultCQ = this.getDefaultCallQuery();
        if (defaultCQ != null) {
            return defaultCQ.getRequiredRoles();
        }
        return null;
    }
}

