/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.dispatch;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.wso2.carbon.dataservices.core.DBUtils;
import org.wso2.carbon.dataservices.core.DSSessionManager;
import org.wso2.carbon.dataservices.core.DataServiceFault;
import org.wso2.carbon.dataservices.core.boxcarring.TLParamStore;
import org.wso2.carbon.dataservices.core.dispatch.DataServiceRequest;
import org.wso2.carbon.dataservices.core.engine.DataService;

public class BoxcarringDataServiceRequest
extends DataServiceRequest {
    private DataServiceRequest dsRequest;

    public BoxcarringDataServiceRequest(DataServiceRequest dsRequest) {
        super(dsRequest.getDataService(), dsRequest.getRequestName());
        this.dsRequest = dsRequest;
    }

    public DataServiceRequest getDSRequest() {
        return this.dsRequest;
    }

    @Override
    public OMElement processRequest() throws DataServiceFault {
        if ("begin_boxcar".equals(this.getRequestName())) {
            DSSessionManager.getCurrentRequestBox().clear();
            DSSessionManager.setBoxcarring(true);
        } else {
            if ("end_boxcar".equals(this.getRequestName())) {
                DataService dataService = this.getDSRequest().getDataService();
                try {
                    dataService.beginTransaction();
                    OMElement lastRequestResult = DSSessionManager.getCurrentRequestBox().execute();
                    dataService.endTransaction();
                    OMElement oMElement = lastRequestResult;
                    return oMElement;
                }
                catch (DataServiceFault e) {
                    dataService.rollbackTransaction();
                    throw new DataServiceFault(e, "Error in boxcarring end");
                }
                finally {
                    DSSessionManager.getCurrentRequestBox().clear();
                    DSSessionManager.setBoxcarring(false);
                    TLParamStore.clear();
                }
            }
            if ("abort_boxcar".equals(this.getRequestName())) {
                DSSessionManager.getCurrentRequestBox().clear();
                DSSessionManager.setBoxcarring(false);
            } else {
                DSSessionManager.getCurrentRequestBox().addRequest(this.getDSRequest());
                return this.createBoxcarringRequestResultWrapper();
            }
        }
        return null;
    }

    private OMElement createBoxcarringRequestResultWrapper() {
        String resultWrapper = this.getDataService().getResultWrapperForRequest(this.getRequestName());
        if (resultWrapper == null) {
            return null;
        }
        String ns = this.getDataService().getNamespaceForRequest(this.getRequestName());
        OMFactory fac = DBUtils.getOMFactory();
        OMElement ele = fac.createOMElement(new QName(ns, resultWrapper));
        return ele;
    }
}

