/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.dispatch;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.axiom.om.OMElement;
import org.wso2.carbon.dataservices.core.DBUtils;
import org.wso2.carbon.dataservices.core.DataServiceFault;
import org.wso2.carbon.dataservices.core.dispatch.BatchRequestParticipant;
import org.wso2.carbon.dataservices.core.dispatch.DataServiceRequest;
import org.wso2.carbon.dataservices.core.dispatch.SingleDataServiceRequest;
import org.wso2.carbon.dataservices.core.engine.DataService;
import org.wso2.carbon.dataservices.core.engine.ParamValue;

public class BatchDataServiceRequest
extends DataServiceRequest {
    private List<SingleDataServiceRequest> dsRequests = new ArrayList<SingleDataServiceRequest>();
    private static ThreadLocal<List<BatchRequestParticipant>> batchRequestParticipant = new ThreadLocal<List<BatchRequestParticipant>>(){

        @Override
        protected synchronized List<BatchRequestParticipant> initialValue() {
            return new ArrayList<BatchRequestParticipant>();
        }
    };

    public BatchDataServiceRequest(DataService dataService, String requestName, List<Map<String, ParamValue>> batchParams) {
        super(dataService, requestName);
        for (Map<String, ParamValue> params : batchParams) {
            this.dsRequests.add(new SingleDataServiceRequest(dataService, requestName, params));
        }
    }

    public static void addParticipant(BatchRequestParticipant participant) {
        batchRequestParticipant.get().add(participant);
    }

    private static List<BatchRequestParticipant> getParticipants() {
        return batchRequestParticipant.get();
    }

    private static void releaseParticipantResources() {
        List<BatchRequestParticipant> finList = BatchDataServiceRequest.getParticipants();
        for (BatchRequestParticipant fin : finList) {
            fin.releaseBatchRequestResources();
        }
    }

    private static void clearParticipants() {
        BatchDataServiceRequest.getParticipants().clear();
    }

    public List<SingleDataServiceRequest> getDSRequests() {
        return this.dsRequests;
    }

    @Override
    public OMElement processRequest() throws DataServiceFault {
        DataService dataService = this.getDataService();
        try {
            DBUtils.setBatchProcessing(true);
            List<SingleDataServiceRequest> requests = this.getDSRequests();
            int count = requests.size();
            DBUtils.setBatchRequestCount(count);
            dataService.beginTransaction();
            for (int i = 0; i < count; ++i) {
                DBUtils.setBatchRequestNumber(i);
                requests.get(i).dispatch();
            }
            dataService.endTransaction();
            OMElement oMElement = null;
            return oMElement;
        }
        catch (DataServiceFault e) {
            dataService.rollbackTransaction();
            throw e;
        }
        finally {
            BatchDataServiceRequest.releaseParticipantResources();
            BatchDataServiceRequest.clearParticipants();
            DBUtils.setBatchProcessing(false);
            DBUtils.setBatchRequestCount(0);
            DBUtils.setBatchRequestNumber(0);
        }
    }
}

