/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.description.resource;

import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.wso2.carbon.dataservices.core.DataServiceFault;
import org.wso2.carbon.dataservices.core.description.query.QueryFactory;
import org.wso2.carbon.dataservices.core.description.resource.Resource;
import org.wso2.carbon.dataservices.core.engine.CallQueryGroup;
import org.wso2.carbon.dataservices.core.engine.DataService;

public class ResourceFactory {
    private ResourceFactory() {
    }

    public static Resource createResource(DataService dataService, OMElement resEl) throws DataServiceFault {
        String path = resEl.getAttributeValue(new QName("path"));
        String method = resEl.getAttributeValue(new QName("method"));
        OMElement descEl = resEl.getFirstChildWithName(new QName("description"));
        String description = null;
        if (descEl != null) {
            description = descEl.getText();
        }
        CallQueryGroup callQueryGroup = null;
        List<CallQueryGroup> cqGroups = QueryFactory.createCallQueryGroups(dataService, resEl.getChildrenWithName(new QName("call-query")), resEl.getChildrenWithName(new QName("call-query-group")));
        if (cqGroups.size() > 0) {
            callQueryGroup = cqGroups.get(0);
        }
        Resource.ResourceID resourceId = new Resource.ResourceID(path, method);
        String disableStreamingRequestStr = resEl.getAttributeValue(new QName("disableStreaming"));
        boolean disableStreamingRequest = false;
        if (disableStreamingRequestStr != null) {
            disableStreamingRequest = Boolean.parseBoolean(disableStreamingRequestStr);
        }
        boolean disableStreamingEffective = disableStreamingRequest | dataService.isDisableStreaming();
        Resource resource = new Resource(dataService, resourceId, description, callQueryGroup, disableStreamingRequest, disableStreamingEffective);
        String returnReqStatusStr = resEl.getAttributeValue(new QName("returnRequestStatus"));
        boolean returnReqStatus = false;
        if (returnReqStatusStr != null) {
            returnReqStatus = Boolean.parseBoolean(returnReqStatusStr);
        }
        resource.setReturnRequestStatus(returnReqStatus);
        return resource;
    }
}

