/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.description.query;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Struct;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axis2.databinding.types.Time;
import org.apache.axis2.databinding.utils.ConverterUtil;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.dataservices.common.DBConstants;
import org.wso2.carbon.dataservices.core.DBUtils;
import org.wso2.carbon.dataservices.core.DataServiceFault;
import org.wso2.carbon.dataservices.core.boxcarring.TLConnectionStore;
import org.wso2.carbon.dataservices.core.description.config.SQLConfig;
import org.wso2.carbon.dataservices.core.description.event.EventTrigger;
import org.wso2.carbon.dataservices.core.description.query.Query;
import org.wso2.carbon.dataservices.core.dispatch.BatchDataServiceRequest;
import org.wso2.carbon.dataservices.core.dispatch.BatchRequestParticipant;
import org.wso2.carbon.dataservices.core.engine.DataEntry;
import org.wso2.carbon.dataservices.core.engine.DataService;
import org.wso2.carbon.dataservices.core.engine.InternalParam;
import org.wso2.carbon.dataservices.core.engine.InternalParamCollection;
import org.wso2.carbon.dataservices.core.engine.ParamValue;
import org.wso2.carbon.dataservices.core.engine.QueryParam;
import org.wso2.carbon.dataservices.core.engine.Result;
import org.wso2.carbon.dataservices.core.engine.ResultSetWrapper;

public class SQLQuery
extends Query
implements BatchRequestParticipant {
    private static final Log log = LogFactory.getLog(SQLQuery.class);
    public static final int DS_QUERY_TYPE_NORMAL = 1;
    public static final int DS_QUERY_TYPE_STORED_PROC = 2;
    public static final int ORACLE_REF_CURSOR_TYPE = -10;
    private String query;
    private SQLConfig config;
    private int queryType;
    private List<QueryParam> outQueryParams;
    private List<QueryParam> onlyOutQueryParams;
    private boolean hasOutParams;
    private boolean resultOnlyOutParams;
    private int[] namedParamIndices;
    private List<String> namedParamNames;
    private QueryParam currentRefCursor;
    private boolean hasRefCursor;
    private QueryParam currentSqlArray;
    private boolean hasSqlArrayType;
    private int prevRefCursorOrdinal;
    private boolean arrayTypesEnabled = false;
    private String sql;
    private int paramCount;
    private int optimalRSFetchSize;
    private boolean hasFetchDirection;
    private boolean hasFetchSize;
    private boolean hasMaxFieldSize;
    private boolean hasMaxRows;
    private boolean hasQueryTimeout;
    private int fetchDirection;
    private int fetchSize;
    private int maxFieldSize;
    private int maxRows;
    private int queryTimeout;
    private boolean returnGeneratedKeys;
    private String[] keyColumns;
    private boolean hasBatchQuerySupport;
    private DBConstants.AutoCommit autoCommit;
    private boolean forceStoredProc;
    private boolean forceJDBCBatchReqs;
    private boolean inited;
    private ThreadLocal<PreparedStatement> batchPreparedStatement = new ThreadLocal<PreparedStatement>(){

        @Override
        protected synchronized PreparedStatement initialValue() {
            return null;
        }
    };

    public SQLQuery(DataService dataService, String queryId, String configId, boolean returnGeneratedKeys, String[] keyColumns, String query, List<QueryParam> queryParams, Result result, EventTrigger inputEventTrigger, EventTrigger outputEventTrigger, Map<String, String> advancedProperties, String inputNamespace) throws DataServiceFault {
        super(dataService, queryId, queryParams, result, configId, inputEventTrigger, outputEventTrigger, advancedProperties, inputNamespace);
        this.returnGeneratedKeys = returnGeneratedKeys;
        this.keyColumns = keyColumns;
        this.query = query;
        try {
            this.config = (SQLConfig)this.getDataService().getConfig(this.getConfigId());
        }
        catch (ClassCastException e) {
            throw new DataServiceFault(e, "Configuration is not an SQL config:" + this.getConfigId());
        }
        if (this.getQuery() != null) {
            this.init();
        }
    }

    public void init() throws DataServiceFault {
        this.processAdvancedProps(this.getAdvancedProperties());
        this.queryType = this.retrieveQueryType(this.getQuery());
        this.outQueryParams = this.extractOutQueryParams(this.getQueryParams());
        this.onlyOutQueryParams = this.extractOnlyOutQueryParams(this.getOutQueryParams());
        this.processNamedParams();
        this.sql = this.createSqlFromQueryString(this.getQuery());
        this.paramCount = this.calculateParamCount(this.getSql());
        this.checkRefCursor(this.getQueryParams());
        this.hasOutParams = this.getOutQueryParams().size() > 0;
        this.resultOnlyOutParams = this.calculateResultOnlyOutParams();
        this.optimalRSFetchSize = DBUtils.getOptimalRSFetchSizeForRDBMS(this.getConfig().getProperty("url"));
        try {
            this.hasBatchQuerySupport = this.getDataService().isBatchRequestsEnabled() && (this.isForceJDBCBatchReqs() || this.calculateBatchQuerySupport());
        }
        catch (DataServiceFault e) {
            this.hasBatchQuerySupport = false;
            log.warn((Object)("Unable to determine batch query support for query '" + this.getQueryId() + "' : " + e.getMessage() + " - batch query support is disabled."));
        }
        this.setInited(true);
    }

    private boolean calculateResultOnlyOutParams() {
        return this.getResult() != null && (this.hasRefCursor() || this.hasSqlArrayType() || this.hasOutParams() && this.getResult().getDefaultElementGroup().getAllElements().size() + this.getResult().getDefaultElementGroup().getAttributeEntries().size() == this.getOutQueryParams().size());
    }

    private String extractStoredProcName(boolean skipFirstWord) {
        String sql = this.getSql();
        String[] tokens = SQLQuery.removeSpaces(sql.split("\\s|\\(|\\["));
        if (skipFirstWord) {
            if (tokens.length < 2) {
                return null;
            }
            return tokens[1];
        }
        if (tokens.length < 1) {
            return null;
        }
        return tokens[0];
    }

    private static String[] removeSpaces(String[] vals) {
        ArrayList<String> result = new ArrayList<String>();
        for (String val : vals) {
            if (val.trim().length() <= 0) continue;
            result.add(val);
        }
        return result.toArray(new String[result.size()]);
    }

    private Object[] getStoredProcFuncProps(String name) throws DataServiceFault, SQLException {
        Connection conn = this.getConfig().createConnection();
        DatabaseMetaData md = conn.getMetaData();
        ResultSet rs = md.getProcedureColumns(null, null, name, "%");
        Object[] resultMap = new Object[2];
        if (!rs.next()) {
            rs.close();
            rs = md.getFunctionColumns(null, null, name, "%");
        } else {
            rs.close();
            rs = md.getProcedureColumns(null, null, name, "%");
        }
        resultMap[0] = conn;
        resultMap[1] = rs;
        return resultMap;
    }

    private boolean calculateBatchQuerySupport() throws DataServiceFault {
        ArrayList<Connection> connections = new ArrayList<Connection>();
        if (this.getConfig().hasJDBCBatchUpdateSupport()) {
            if (this.getQueryType() == 2) {
                try {
                    Object[] resultMap = this.getStoredProcFuncProps(this.extractStoredProcName(true));
                    ResultSet rs = (ResultSet)resultMap[1];
                    connections.add((Connection)resultMap[0]);
                    if (!rs.next()) {
                        resultMap = this.getStoredProcFuncProps(this.extractStoredProcName(false));
                        rs = (ResultSet)resultMap[1];
                        connections.add((Connection)resultMap[0]);
                        if (!rs.next()) {
                            throw new DataServiceFault("Cannot find metadata for the stored procedure");
                        }
                    }
                    StoredProcMetadataCollection mdCollection = new StoredProcMetadataCollection(rs);
                    for (StoredProcMetadataEntry entry : mdCollection.getEntries()) {
                        switch (entry.getColumnReturn()) {
                            case 1: {
                                break;
                            }
                            case 5: {
                                if (entry.getColumnDataType() == 4 || entry.getColumnDataType() == -5 || entry.getColumnDataType() == 3) break;
                                boolean bl = false;
                                return bl;
                            }
                            default: {
                                boolean bl = false;
                                return bl;
                            }
                        }
                    }
                    boolean bl = true;
                    return bl;
                }
                catch (Throwable e) {
                    throw new DataServiceFault("Error in retrieving database metadata.");
                }
                finally {
                    for (Connection aCon : connections) {
                        try {
                            aCon.close();
                        }
                        catch (SQLException ignore) {}
                    }
                }
            }
            return true;
        }
        return false;
    }

    public boolean isInited() {
        return this.inited;
    }

    public void setInited(boolean inited) {
        this.inited = inited;
    }

    public DBConstants.AutoCommit getAutoCommit() {
        return this.autoCommit;
    }

    public boolean hasBatchQuerySupport() {
        return this.hasBatchQuerySupport;
    }

    public int getParamCount() {
        return this.paramCount;
    }

    private PreparedStatement getBatchPreparedStatement() {
        return this.batchPreparedStatement.get();
    }

    private void setBatchPreparedStatement(PreparedStatement val) {
        this.batchPreparedStatement.set(val);
    }

    public String[] getKeyColumns() {
        return this.keyColumns;
    }

    public boolean isReturnGeneratedKeys() {
        return this.returnGeneratedKeys;
    }

    public boolean isForceStoredProc() {
        return this.forceStoredProc;
    }

    public boolean isForceJDBCBatchReqs() {
        return this.forceJDBCBatchReqs;
    }

    private void processAdvancedProps(Map<String, String> props) throws DataServiceFault {
        String forceJDBCBatchRequests;
        if (props == null) {
            return;
        }
        String fetchDirectionProp = props.get("fetchDirection");
        if (!DBUtils.isEmptyString(fetchDirectionProp)) {
            if ("forward".equals(fetchDirectionProp = fetchDirectionProp.trim())) {
                this.fetchDirection = 1000;
            } else if ("reverse".equals(fetchDirectionProp)) {
                this.fetchDirection = 1001;
            } else {
                throw new DataServiceFault("Invalid fetch direction: " + fetchDirectionProp + ", valid values are {'" + "forward" + "', '" + "reverse" + "'}");
            }
            this.hasFetchDirection = true;
        } else {
            this.hasFetchDirection = false;
        }
        String fetchSizeProp = props.get("fetchSize");
        if (!DBUtils.isEmptyString(fetchSizeProp)) {
            fetchSizeProp = fetchSizeProp.trim();
            try {
                this.fetchSize = Integer.parseInt(fetchSizeProp);
            }
            catch (NumberFormatException e) {
                throw new DataServiceFault(e, "Invalid fetch size: " + fetchSizeProp + ", fetch size should be an integer");
            }
            this.hasFetchSize = true;
        } else {
            this.hasFetchSize = false;
        }
        String maxFieldSizeProp = props.get("maxFieldSize");
        if (!DBUtils.isEmptyString(maxFieldSizeProp)) {
            maxFieldSizeProp = maxFieldSizeProp.trim();
            try {
                this.maxFieldSize = Integer.parseInt(maxFieldSizeProp);
                if (this.maxFieldSize <= 0) {
                    throw new DataServiceFault("Invalid maximum field size: " + maxFieldSizeProp + ", maximum field size should be a positive integer");
                }
            }
            catch (NumberFormatException e) {
                throw new DataServiceFault(e, "Invalid maximum field size: " + maxFieldSizeProp + ", maximum field size should be a positive integer");
            }
            this.hasMaxFieldSize = true;
        } else {
            this.hasMaxFieldSize = false;
        }
        String maxRowsProp = props.get("maxRows");
        if (!DBUtils.isEmptyString(maxRowsProp)) {
            maxRowsProp = maxRowsProp.trim();
            try {
                this.maxRows = Integer.parseInt(maxRowsProp);
                if (this.maxRows <= 0) {
                    throw new DataServiceFault("Invalid maximum rows: " + maxRowsProp + ", maximum rows should be a positive integer");
                }
            }
            catch (NumberFormatException e) {
                throw new DataServiceFault(e, "Invalid maximum rows: " + maxRowsProp + ", maximum rows should be a positive integer");
            }
            this.hasMaxRows = true;
        } else {
            this.hasMaxRows = false;
        }
        String queryTimeoutProp = props.get("queryTimeout");
        if (!DBUtils.isEmptyString(queryTimeoutProp)) {
            queryTimeoutProp = queryTimeoutProp.trim();
            try {
                this.queryTimeout = Integer.parseInt(queryTimeoutProp);
                if (this.queryTimeout <= 0) {
                    throw new DataServiceFault("Invalid query timeout: " + queryTimeoutProp + ", query timeout be a positive integer");
                }
            }
            catch (NumberFormatException e) {
                throw new DataServiceFault(e, "Invalid query timeout: " + queryTimeoutProp + ", query timeout be a positive integer");
            }
            this.hasQueryTimeout = true;
        } else {
            this.hasQueryTimeout = false;
        }
        String autoCommitProp = props.get("autoCommit");
        if (!DBUtils.isEmptyString(autoCommitProp)) {
            autoCommitProp = autoCommitProp.trim();
            try {
                boolean acBool = Boolean.parseBoolean(autoCommitProp);
                if (acBool) {
                    this.autoCommit = DBConstants.AutoCommit.AUTO_COMMIT_ON;
                }
                this.autoCommit = DBConstants.AutoCommit.AUTO_COMMIT_OFF;
            }
            catch (Exception e) {
                throw new DataServiceFault(e, "Invalid autocommit value: " + autoCommitProp + ", autocommit should be a boolean value");
            }
        } else {
            this.autoCommit = this.getConfig().getAutoCommit();
        }
        String forceStoredProc = props.get("forceStoredProc");
        if (!DBUtils.isEmptyString(forceStoredProc)) {
            this.forceStoredProc = Boolean.parseBoolean(forceStoredProc);
        }
        if (!DBUtils.isEmptyString(forceJDBCBatchRequests = props.get("forceJDBCBatchRequests"))) {
            this.forceJDBCBatchReqs = Boolean.parseBoolean(forceJDBCBatchRequests);
        }
    }

    public List<String> getNamedParamNames() {
        return this.namedParamNames;
    }

    public boolean isHasFetchDirection() {
        return this.hasFetchDirection;
    }

    public boolean isHasFetchSize() {
        return this.hasFetchSize;
    }

    public boolean isHasMaxFieldSize() {
        return this.hasMaxFieldSize;
    }

    public boolean isHasMaxRows() {
        return this.hasMaxRows;
    }

    public boolean isHasQueryTimeout() {
        return this.hasQueryTimeout;
    }

    public int getFetchDirection() {
        return this.fetchDirection;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public int getMaxFieldSize() {
        return this.maxFieldSize;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public QueryParam getCurrentSqlArray() {
        return this.currentSqlArray;
    }

    public int getOptimalRSFetchSize() {
        return this.optimalRSFetchSize;
    }

    private void checkRefCursor(List<QueryParam> queryParams) {
        for (QueryParam queryParam : queryParams) {
            if (!queryParam.getSqlType().equals("ORACLE_REF_CURSOR")) continue;
            this.currentRefCursor = queryParam;
            this.hasRefCursor = true;
            return;
        }
    }

    private String createSqlFromQueryString(String query) {
        List<String> values = this.getNamedParamNames();
        for (String val : values) {
            query = query.replaceAll(":" + val, "?");
        }
        return query;
    }

    public String getSql() {
        return this.sql;
    }

    private List<String> extractParamNames(String query, Set<String> queryParams) {
        ArrayList<String> paramNames = new ArrayList<String>();
        for (int i = 0; i < query.length(); ++i) {
            String tmpParam;
            if (query.charAt(i) == '?') {
                paramNames.add("?");
                continue;
            }
            if (query.charAt(i) != ':' || i + 1 >= query.length() || !queryParams.contains(tmpParam = query.substring(i + 1, query.length()).split(" |,|\\)|\\(|:")[0])) continue;
            paramNames.add(tmpParam);
        }
        return paramNames;
    }

    private void processNamedParams() {
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        for (QueryParam param : this.getQueryParams()) {
            paramMap.put(param.getName(), param.getOrdinal());
        }
        List<String> paramNames = this.extractParamNames(this.getQuery(), paramMap.keySet());
        this.namedParamIndices = new int[paramNames.size()];
        this.namedParamNames = new ArrayList<String>();
        for (int i = 0; i < this.namedParamIndices.length; ++i) {
            if (paramNames.get(i).equals("?")) {
                this.namedParamIndices[i] = i + 1;
                continue;
            }
            String tmpParamName = paramNames.get(i);
            this.namedParamNames.add(tmpParamName);
            this.namedParamIndices[i] = (Integer)paramMap.get(tmpParamName);
        }
    }

    public int[] getNamedParamIndices() {
        return this.namedParamIndices;
    }

    private InternalParamCollection createProcessedNamedParams(InternalParamCollection params) throws DataServiceFault {
        int i;
        InternalParamCollection newParams = new InternalParamCollection();
        int[] indices = this.getNamedParamIndices();
        HashSet<InternalParam> remainingParams = new HashSet<InternalParam>(params.getParams());
        for (i = 0; i < indices.length; ++i) {
            InternalParam tmpParam = params.getParam(indices[i]);
            remainingParams.remove(tmpParam);
            if (tmpParam == null) {
                throw new DataServiceFault("A parameter is expected at position '" + (i + 1) + "' for the SQL query '" + this.getQuery() + "'");
            }
            if (indices[i] < 0) continue;
            newParams.addParam(new InternalParam(tmpParam, i + 1));
        }
        for (InternalParam rparam : remainingParams) {
            newParams.addParam(new InternalParam(rparam, i + 1));
            ++i;
        }
        return newParams;
    }

    public boolean hasOutParams() {
        return this.hasOutParams;
    }

    public boolean isResultOnlyOutParams() {
        return this.resultOnlyOutParams;
    }

    private List<QueryParam> extractOutQueryParams(List<QueryParam> queryParams) {
        ArrayList<QueryParam> inOutQueryParams = new ArrayList<QueryParam>();
        for (QueryParam queryParam : queryParams) {
            if (!queryParam.getType().endsWith("OUT") || queryParam.getSqlType().equals("ORACLE_REF_CURSOR")) continue;
            inOutQueryParams.add(queryParam);
        }
        return inOutQueryParams;
    }

    private List<QueryParam> extractOnlyOutQueryParams(List<QueryParam> queryParams) {
        ArrayList<QueryParam> outQueryParams = new ArrayList<QueryParam>();
        for (QueryParam queryParam : queryParams) {
            if (!queryParam.getType().equals("OUT")) continue;
            outQueryParams.add(queryParam);
        }
        return outQueryParams;
    }

    public List<QueryParam> getOutQueryParams() {
        return this.outQueryParams;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public int getQueryType() {
        return this.queryType;
    }

    public SQLConfig getConfig() {
        return this.config;
    }

    private boolean isValidCreds(String[] creds) {
        return creds != null && creds.length > 1 && creds[0] != null;
    }

    public String[] lookupConnectionCredentials() throws DataServiceFault {
        if (this.getConfig().getPrimaryDynAuth() != null) {
            String user = DBUtils.getCurrentContextUsername();
            String[] creds = this.getConfig().getPrimaryDynAuth().lookupCredentials(user);
            if (this.isValidCreds(creds)) {
                return creds;
            }
            if (this.getConfig().getSecondaryDynAuth() != null && this.isValidCreds(creds = this.getConfig().getSecondaryDynAuth().lookupCredentials(user))) {
                return creds;
            }
            creds = this.getConfig().getPrimaryDynAuth().lookupCredentials("*");
            if (this.isValidCreds(creds)) {
                return creds;
            }
            throw new DataServiceFault("A username/password mapping does not exist for the request user: " + user);
        }
        return new String[]{null, null};
    }

    private Connection createConnection() throws DataServiceFault {
        try {
            String[] creds = this.lookupConnectionCredentials();
            Connection connection = null;
            DataService dataService = this.getDataService();
            if (dataService.isInTransaction() && !dataService.isEnableXA()) {
                connection = TLConnectionStore.getConnection(this.getConfigId(), creds[0]);
                if (connection == null) {
                    connection = this.getConfig().createConnection(creds[0], creds[1]);
                    connection.setAutoCommit(false);
                    TLConnectionStore.addConnection(this.getConfigId(), creds[0], connection);
                }
            } else {
                connection = this.getConfig().createConnection(creds[0], creds[1]);
                if (!dataService.isInTransaction() || !dataService.isEnableXA()) {
                    switch (this.getAutoCommit()) {
                        case AUTO_COMMIT_ON: {
                            connection.setAutoCommit(true);
                            break;
                        }
                        case AUTO_COMMIT_OFF: {
                            connection.setAutoCommit(false);
                        }
                    }
                }
            }
            return connection;
        }
        catch (SQLException e) {
            throw new DataServiceFault(e, "Error in opening DBMS connection.");
        }
    }

    public void finalizeConnection(Connection connection, boolean force) throws DataServiceFault {
        try {
            if (connection == null) {
                return;
            }
            DataService dataService = this.getDataService();
            if (dataService.isEnableXA() && dataService.isInTransaction()) {
                connection.close();
            } else if (!dataService.isInTransaction()) {
                if (!connection.isClosed() && !connection.getAutoCommit()) {
                    connection.commit();
                }
                connection.close();
            } else if (force) {
                connection.close();
            }
        }
        catch (SQLException e) {
            throw new DataServiceFault(e, "Error in DBMS connection finalize.");
        }
    }

    private int retrieveQueryType(String query) {
        if (this.isForceStoredProc()) {
            return 2;
        }
        return this.inferQueryType(query);
    }

    private int inferQueryType(String query) {
        query = query.trim().toUpperCase();
        for (String normalQueryType : DBConstants.SQL_NORMAL_QUERY_TYPES) {
            if (!query.startsWith(normalQueryType)) continue;
            return 1;
        }
        return 2;
    }

    private boolean isJDBCBatchRequest() {
        return DBUtils.isBatchProcessing() && this.hasBatchQuerySupport();
    }

    private boolean isJDBCFirstBatchRequest() {
        return this.isJDBCBatchRequest() && DBUtils.getBatchRequestNumber() == 0;
    }

    private boolean isJDBCLastBatchRequest() {
        return this.isJDBCBatchRequest() && DBUtils.getBatchRequestNumber() + 1 >= DBUtils.getBatchRequestCount();
    }

    private void writeOutGeneratedKeys(Statement stmt, XMLStreamWriter xmlWriter, InternalParamCollection params, int queryLevel) throws DataServiceFault, SQLException {
        ResultSet krs = stmt.getGeneratedKeys();
        while (krs.next()) {
            DataEntry dataEntry = this.getDataEntryFromRS(new ResultSetWrapper(krs));
            this.writeResultEntry(xmlWriter, dataEntry, params, queryLevel);
        }
    }

    private void processNormalQuery(XMLStreamWriter xmlWriter, InternalParamCollection params, int queryLevel) throws DataServiceFault {
        Connection conn = null;
        boolean isError = false;
        try {
            conn = this.createConnection();
            PreparedStatement stmt = this.createProcessedPreparedStatement(1, params, conn);
            if (this.isJDBCFirstBatchRequest()) {
                this.setBatchPreparedStatement(stmt);
                BatchDataServiceRequest.addParticipant(this);
            }
            if (!this.hasResult() || this.hasResult() && this.isReturnGeneratedKeys()) {
                if (this.isJDBCBatchRequest()) {
                    if (this.isJDBCLastBatchRequest()) {
                        stmt.executeBatch();
                        if (this.isReturnGeneratedKeys()) {
                            this.writeOutGeneratedKeys(stmt, xmlWriter, params, queryLevel);
                        }
                        stmt.close();
                    }
                } else {
                    stmt.executeUpdate();
                    if (this.isReturnGeneratedKeys()) {
                        this.writeOutGeneratedKeys(stmt, xmlWriter, params, queryLevel);
                    }
                    stmt.close();
                }
            } else {
                ResultSet rs = stmt.executeQuery();
                while (rs.next()) {
                    DataEntry dataEntry = this.getDataEntryFromRS(new ResultSetWrapper(rs));
                    this.writeResultEntry(xmlWriter, dataEntry, params, queryLevel);
                }
                rs.close();
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            isError = true;
            throw new DataServiceFault(e, DBConstants.FaultCodes.DATABASE_ERROR, "Error in 'SQLQuery.processNormalQuery'");
        }
        finally {
            this.finalizeConnection(conn, isError);
        }
    }

    private void processStoredProcQuery(XMLStreamWriter xmlWriter, InternalParamCollection params, int queryLevel) throws DataServiceFault {
        Connection conn = null;
        boolean isError = false;
        try {
            conn = this.createConnection();
            CallableStatement stmt = (CallableStatement)this.createProcessedPreparedStatement(2, params, conn);
            if (this.isJDBCFirstBatchRequest()) {
                this.setBatchPreparedStatement(stmt);
                BatchDataServiceRequest.addParticipant(this);
            }
            if (!this.hasResult() || this.hasResult() && this.isReturnGeneratedKeys()) {
                if (this.isJDBCBatchRequest()) {
                    if (this.isJDBCLastBatchRequest()) {
                        stmt.executeBatch();
                        if (this.isReturnGeneratedKeys()) {
                            this.writeOutGeneratedKeys(stmt, xmlWriter, params, queryLevel);
                        }
                        stmt.close();
                    }
                } else {
                    stmt.executeUpdate();
                    if (this.isReturnGeneratedKeys()) {
                        this.writeOutGeneratedKeys(stmt, xmlWriter, params, queryLevel);
                    }
                    stmt.close();
                }
            } else {
                ResultSet rs = null;
                if (this.isResultOnlyOutParams()) {
                    stmt.execute();
                    if (this.hasRefCursor()) {
                        rs = (ResultSet)stmt.getObject(this.getCurrentRefCursor().getOrdinal());
                        if (this.arrayTypesEnabled()) {
                            this.getCurrentRefCursor().setOrdinal(this.getPrevRefCusorOrdinal());
                        }
                    }
                } else {
                    rs = this.getFirstRSOfStoredProc(stmt);
                }
                if (rs == null || rs.isClosed() || !rs.next()) {
                    DataEntry outParamDataEntry;
                    if (this.hasOutParams() && (outParamDataEntry = this.getDataEntryFromOutParams(stmt)) != null) {
                        this.writeResultEntry(xmlWriter, outParamDataEntry, params, queryLevel);
                    }
                    if (rs != null && !rs.isClosed()) {
                        rs.close();
                    }
                } else if (this.hasOutParams()) {
                    List<DataEntry> entries = this.getAllDataEntriesFromRS(rs, true);
                    rs.close();
                    DataEntry outParamDataEntry = this.getDataEntryFromOutParams(stmt);
                    for (DataEntry dataEntry : entries) {
                        this.mergeDataEntries(dataEntry, outParamDataEntry);
                        this.writeResultEntry(xmlWriter, dataEntry, params, queryLevel);
                    }
                } else {
                    do {
                        DataEntry dataEntry = this.getDataEntryFromRS(new ResultSetWrapper(rs));
                        this.writeResultEntry(xmlWriter, dataEntry, params, queryLevel);
                    } while (rs.next());
                    rs.close();
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            isError = true;
            throw new DataServiceFault(e, DBConstants.FaultCodes.DATABASE_ERROR, "Error in 'SQLQuery.processStoredProcQuery'");
        }
        finally {
            this.finalizeConnection(conn, isError);
        }
    }

    private List<DataEntry> getAllDataEntriesFromRS(ResultSet rs, boolean rsNextAlreadyCalled) throws SQLException {
        ArrayList<DataEntry> entries = new ArrayList<DataEntry>();
        if (!rsNextAlreadyCalled && !rs.next()) {
            return entries;
        }
        do {
            entries.add(this.getDataEntryFromRS(new ResultSetWrapper(rs)));
        } while (rs.next());
        return entries;
    }

    private ResultSet getFirstRSOfStoredProc(CallableStatement stmt) throws SQLException {
        boolean resultAndNoUpdateCount = stmt.execute();
        ResultSet result = null;
        while (true) {
            if (!resultAndNoUpdateCount) {
                if (stmt.getUpdateCount() == -1) {
                    break;
                }
            } else {
                result = stmt.getResultSet();
                break;
            }
            try {
                resultAndNoUpdateCount = stmt.getMoreResults(2);
            }
            catch (SQLException e) {
                if (result != null) break;
                throw e;
            }
        }
        return result;
    }

    private void mergeDataEntries(DataEntry lhs, DataEntry rhs) {
        lhs.getData().putAll(rhs.getData());
    }

    private DataEntry getDataEntryFromOutParams(CallableStatement stmt) throws DataServiceFault {
        DataEntry dataEntry = new DataEntry();
        for (QueryParam queryParam : this.getOutQueryParams()) {
            String name = queryParam.getName();
            ParamValue value = this.getOutparameterValue(stmt, queryParam.getSqlType(), queryParam.getOrdinal());
            dataEntry.addValue(name, value);
        }
        return dataEntry;
    }

    private DataEntry getDataEntryFromRS(ResultSet rs) throws SQLException {
        DataEntry dataEntry = new DataEntry();
        ResultSetMetaData metaData = rs.getMetaData();
        int columnCount = metaData.getColumnCount();
        boolean useColumnNumbers = this.isUsingColumnNumbers();
        for (int i = 1; i <= columnCount; ++i) {
            ParamValue paramValue;
            int columnType = metaData.getColumnType(i);
            switch (columnType) {
                case -16: 
                case -15: 
                case -9: 
                case -1: 
                case 1: 
                case 12: 
                case 2005: 
                case 2011: {
                    String value = rs.getString(i);
                    paramValue = new ParamValue(value);
                    break;
                }
                case -6: 
                case 4: 
                case 5: {
                    String value = ConverterUtil.convertToString((int)rs.getInt(i));
                    paramValue = new ParamValue(value);
                    break;
                }
                case 8: {
                    String value = ConverterUtil.convertToString((double)rs.getDouble(i));
                    paramValue = new ParamValue(value);
                    break;
                }
                case 6: {
                    String value = ConverterUtil.convertToString((float)rs.getFloat(i));
                    paramValue = new ParamValue(value);
                    break;
                }
                case -7: 
                case 16: {
                    String value = ConverterUtil.convertToString((boolean)rs.getBoolean(i));
                    paramValue = new ParamValue(value);
                    break;
                }
                case 3: {
                    BigDecimal bigDecimal = rs.getBigDecimal(i);
                    String value = bigDecimal != null ? ConverterUtil.convertToString((Object)bigDecimal) : null;
                    paramValue = new ParamValue(value);
                    break;
                }
                case 92: {
                    java.sql.Time sqlTime = rs.getTime(i);
                    String value = sqlTime != null ? this.convertToTimeString(sqlTime) : null;
                    paramValue = new ParamValue(value);
                    break;
                }
                case 91: {
                    Date sqlDate = rs.getDate(i);
                    String value = sqlDate != null ? ConverterUtil.convertToString((java.util.Date)sqlDate) : null;
                    paramValue = new ParamValue(value);
                    break;
                }
                case 93: {
                    Timestamp sqlTimestamp = rs.getTimestamp(i);
                    String value = sqlTimestamp != null ? this.convertToTimestampString(sqlTimestamp) : null;
                    paramValue = new ParamValue(value);
                    break;
                }
                case 2004: {
                    Blob sqlBlob = rs.getBlob(i);
                    String value = sqlBlob != null ? this.getBase64StringFromInputStream(sqlBlob.getBinaryStream()) : null;
                    paramValue = new ParamValue(value);
                    break;
                }
                case -4: 
                case -3: 
                case -2: {
                    InputStream binInStream = rs.getBinaryStream(i);
                    String value = binInStream != null ? this.getBase64StringFromInputStream(binInStream) : null;
                    paramValue = new ParamValue(value);
                    break;
                }
                case 2002: {
                    Struct udt = (Struct)rs.getObject(i);
                    paramValue = new ParamValue(udt);
                    break;
                }
                case 2003: {
                    paramValue = new ParamValue(2);
                    Array dataArray = (Array)rs.getObject(i);
                    if (dataArray == null) break;
                    paramValue = this.processSQLArray(dataArray, paramValue);
                    break;
                }
                default: {
                    String value = rs.getString(i);
                    paramValue = new ParamValue(value);
                }
            }
            dataEntry.addValue(useColumnNumbers ? Integer.toString(i) : metaData.getColumnLabel(i), paramValue);
        }
        return dataEntry;
    }

    private ParamValue processSQLArray(Array dataArray, ParamValue paramValue) throws SQLException {
        ResultSet rs = dataArray.getResultSet();
        while (rs.next()) {
            Object arrayEl = rs.getObject(2);
            if (arrayEl instanceof Struct) {
                paramValue.getArrayValue().add(new ParamValue((Struct)arrayEl));
                continue;
            }
            if (arrayEl instanceof Array) {
                paramValue.getArrayValue().add(this.processSQLArray((Array)arrayEl, new ParamValue(2)));
                continue;
            }
            paramValue.getArrayValue().add(new ParamValue(String.valueOf(arrayEl)));
        }
        rs.close();
        return paramValue;
    }

    private String convertToTimeString(java.sql.Time sqlTime) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(sqlTime.getTime());
        return new Time(cal).toString();
    }

    private String convertToTimestampString(Timestamp sqlTimestamp) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(sqlTimestamp.getTime());
        return ConverterUtil.convertToString((Calendar)cal);
    }

    private String getBase64StringFromInputStream(InputStream in) throws SQLException {
        String strData;
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        try {
            byte[] buff = new byte[512];
            int i = 0;
            while ((i = in.read(buff)) > 0) {
                byteOut.write(buff, 0, i);
            }
            in.close();
            byte[] base64Data = Base64.encodeBase64((byte[])byteOut.toByteArray());
            strData = new String(base64Data, "UTF-8");
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
        return strData;
    }

    private byte[] getBytesFromBase64String(String base64Str) throws SQLException {
        try {
            byte[] data = Base64.decodeBase64((byte[])base64Str.getBytes("UTF-8"));
            return data;
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
    }

    public String createProcessedSql(String sql, InternalParamCollection params, int paramCount) {
        String currentSql = sql;
        int start = 0;
        for (int i = 1; i <= paramCount; ++i) {
            int count;
            InternalParam param = params.getParam(i);
            ParamValue value = param.getValue();
            if (value != null && value.getValueType() == 2) {
                count = value.getArrayValue().size();
                if (this.hasRefCursor()) {
                    this.arrayTypesEnabled = true;
                    int currentRefCursorOrdinal = this.getCurrentRefCursor().getOrdinal();
                    if (i < currentRefCursorOrdinal) {
                        this.prevRefCursorOrdinal = currentRefCursorOrdinal;
                        this.getCurrentRefCursor().setOrdinal(currentRefCursorOrdinal + count - 1);
                    }
                } else if (this.hasSqlArrayType()) {
                    this.arrayTypesEnabled = true;
                    int currentSqlArrayOrdinal = this.getCurrentSqlArray().getOrdinal();
                    if (i < currentSqlArrayOrdinal) {
                        this.prevRefCursorOrdinal = currentSqlArrayOrdinal;
                        this.getCurrentSqlArray().setOrdinal(currentSqlArrayOrdinal + count - 1);
                    }
                }
            } else {
                count = 1;
            }
            Object[] vals = this.expandSQL(start, count, currentSql);
            start = (Integer)vals[0];
            currentSql = (String)vals[1];
        }
        return currentSql;
    }

    private Object[] expandSQL(int start, int count, String sql) {
        int n;
        StringBuilder result = new StringBuilder();
        int end = n = sql.length();
        for (int i = start; i < n; ++i) {
            if (sql.charAt(i) != '?') continue;
            result.append(sql.substring(0, i));
            result.append(this.generateQuestionMarks(count));
            end = result.length() + 1;
            if (i + 1 >= n) break;
            result.append(sql.substring(i + 1));
            break;
        }
        return new Object[]{end, result.toString()};
    }

    private String generateQuestionMarks(int n) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            builder.append("?");
            if (i + 1 >= n) continue;
            builder.append(",");
        }
        return builder.toString();
    }

    private int calculateParamCount(String sql) {
        int n = 0;
        for (char ch : sql.toCharArray()) {
            if (ch != '?') continue;
            ++n;
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private PreparedStatement createProcessedPreparedStatement(int queryType, InternalParamCollection params, Connection conn) throws DataServiceFault {
        try {
            boolean inTheMiddleOfABatch = false;
            PreparedStatement stmt = this.getBatchPreparedStatement();
            if (stmt == null) {
                String processedSQL = this.createProcessedSql(this.getSql(), params, this.getParamCount());
                if (queryType == 1) {
                    stmt = this.isReturnGeneratedKeys() ? (this.getKeyColumns() != null ? conn.prepareStatement(processedSQL, this.getKeyColumns()) : conn.prepareStatement(processedSQL, 1)) : conn.prepareStatement(processedSQL);
                } else {
                    if (queryType != 2) throw new DataServiceFault("Unsupported query type: " + queryType);
                    stmt = conn.prepareCall(processedSQL);
                }
            } else {
                inTheMiddleOfABatch = true;
            }
            if (!inTheMiddleOfABatch) {
                if (this.isHasQueryTimeout()) {
                    stmt.setQueryTimeout(this.getQueryTimeout());
                }
                if (this.isHasFetchDirection()) {
                    stmt.setFetchDirection(this.getFetchDirection());
                }
                if (this.isHasFetchSize()) {
                    stmt.setFetchSize(this.getFetchSize());
                } else if (!this.hasOutParams()) {
                    stmt.setFetchSize(this.getOptimalRSFetchSize());
                }
                if (this.isHasMaxFieldSize()) {
                    stmt.setMaxFieldSize(this.getMaxFieldSize());
                }
                if (this.isHasMaxRows()) {
                    stmt.setMaxRows(this.getMaxRows());
                }
            }
            int currentOrdinal = 0;
            int count = this.getParamCount();
            for (int i = 1; i <= count; ++i) {
                InternalParam param = params.getParam(i);
                ParamValue value = param.getValue();
                if (value != null && value.getValueType() == 2) {
                    for (ParamValue arrayElement : value.getArrayValue()) {
                        this.setParamInPreparedStatement(stmt, param, arrayElement.toString(), queryType, currentOrdinal);
                        ++currentOrdinal;
                    }
                    continue;
                }
                this.setParamInPreparedStatement(stmt, param, value != null ? value.getScalarValue() : null, queryType, currentOrdinal);
                ++currentOrdinal;
            }
            if (!this.isJDBCBatchRequest()) return stmt;
            stmt.addBatch();
            return stmt;
        }
        catch (SQLException e) {
            throw new DataServiceFault(e, "Error in 'createProcessedPreparedStatement'");
        }
    }

    private void setParamInPreparedStatement(PreparedStatement stmt, InternalParam param, String value, int queryType, int index) throws SQLException, DataServiceFault {
        String paramName = param.getName();
        String sqlType = param.getSqlType();
        String paramType = param.getType();
        String structType = param.getStructType();
        if (sqlType == null) {
            this.setDefaultStringValue(value, paramType, stmt, index);
        } else if ("INTEGER".equals(sqlType)) {
            this.setIntValue(queryType, value, paramType, stmt, index);
        } else if ("STRING".equals(sqlType)) {
            this.setStringValue(queryType, value, paramType, stmt, index);
        } else if ("DOUBLE".equals(sqlType)) {
            this.setDoubleValue(queryType, value, paramType, stmt, index);
        } else if ("NUMERIC".equals(sqlType)) {
            this.setNumericValue(queryType, value, paramType, stmt, index);
        } else if ("BIT".equals(sqlType) || "BOOLEAN".equals(sqlType)) {
            this.setBitValue(queryType, value, paramType, stmt, index);
        } else if ("TINYINT".equals(sqlType)) {
            this.setTinyIntValue(queryType, value, paramType, stmt, index);
        } else if ("SMALLINT".equals(sqlType)) {
            this.setSmallIntValue(queryType, value, paramType, stmt, index);
        } else if ("BIGINT".equals(sqlType)) {
            this.setBigIntValue(queryType, value, paramType, stmt, index);
        } else if ("REAL".equals(sqlType)) {
            this.setRealValue(queryType, value, paramType, stmt, index);
        } else if ("DATE".equals(sqlType)) {
            this.setDateValue(queryType, paramName, value, paramType, stmt, index);
        } else if ("TIMESTAMP".equals(sqlType)) {
            this.setTimestampValue(queryType, paramName, value, paramType, stmt, index);
        } else if ("TIME".equals(sqlType)) {
            this.setTimeValue(queryType, paramName, value, paramType, stmt, index);
        } else if ("BINARY".equals(sqlType)) {
            this.setBinaryValue(queryType, paramName, value, paramType, stmt, index);
        } else if ("BLOB".equals(sqlType)) {
            this.setBlobValue(queryType, paramName, value, paramType, stmt, index);
        } else if ("ORACLE_REF_CURSOR".equals(sqlType)) {
            this.setOracleRefCusor(stmt, index);
        } else if ("STRUCT".equals(sqlType)) {
            this.setUserDefinedType(stmt, index, paramType, structType);
        } else if ("ARRAY".equals(sqlType)) {
            this.setArrayValue(stmt, index, paramType, structType);
        } else {
            throw new DataServiceFault("[" + this.getDataService().getName() + "]  Found Unsupported data type : " + sqlType + " as input parameter.");
        }
    }

    private void setArrayValue(PreparedStatement sqlQuery, int i, String paramType, String structType) throws SQLException, DataServiceFault {
        if (!"OUT".equals(paramType)) {
            throw new DataServiceFault("IN or INOUT operations are not supported for SQL Arrays");
        }
        ((CallableStatement)sqlQuery).registerOutParameter(i + 1, 2003, structType);
    }

    private void setDefaultStringValue(String value, String paramType, PreparedStatement sqlQuery, int i) throws SQLException {
        if ("IN".equals(paramType)) {
            sqlQuery.setString(i + 1, value);
        } else if ("INOUT".equals(paramType)) {
            sqlQuery.setString(i + 1, value);
            ((CallableStatement)sqlQuery).registerOutParameter(i + 1, 12);
        } else {
            ((CallableStatement)sqlQuery).registerOutParameter(i + 1, 12);
        }
    }

    private void setTimeValue(int queryType, String paramName, String value, String paramType, PreparedStatement sqlQuery, int i) throws SQLException, DataServiceFault {
        java.sql.Time time = null;
        try {
            if (value != null) {
                time = DBUtils.getTime(value);
            }
        }
        catch (ParseException e) {
            throw new DataServiceFault(e, "Incorrect Time format for parameter : " + paramName + ". Time should be in the format hh:mm:ss");
        }
        if ("IN".equals(paramType)) {
            if (queryType == 1) {
                if (value == null) {
                    sqlQuery.setNull(i + 1, 92);
                } else {
                    sqlQuery.setTime(i + 1, time);
                }
            } else if (value == null) {
                ((CallableStatement)sqlQuery).setNull(i + 1, 92);
            } else {
                ((CallableStatement)sqlQuery).setTime(i + 1, time);
            }
        } else if ("INOUT".equals(paramType)) {
            if (value == null) {
                ((CallableStatement)sqlQuery).setNull(i + 1, 92);
            } else {
                ((CallableStatement)sqlQuery).setTime(i + 1, time);
            }
            ((CallableStatement)sqlQuery).registerOutParameter(i + 1, 92);
        } else {
            ((CallableStatement)sqlQuery).registerOutParameter(i + 1, 92);
        }
    }

    private void setBinaryValue(int queryType, String paramName, String value, String paramType, PreparedStatement sqlQuery, int i) throws SQLException, DataServiceFault {
        if ("IN".equals(paramType)) {
            if (value == null) {
                sqlQuery.setNull(i + 1, -2);
            } else {
                byte[] data = this.getBytesFromBase64String(value);
                sqlQuery.setBinaryStream(i + 1, (InputStream)new ByteArrayInputStream(data), data.length);
            }
        } else if ("INOUT".equals(paramType)) {
            if (value == null) {
                ((CallableStatement)sqlQuery).setNull(i + 1, -2);
            } else {
                byte[] data = this.getBytesFromBase64String(value);
                ((CallableStatement)sqlQuery).setBinaryStream(i + 1, (InputStream)new ByteArrayInputStream(data), data.length);
            }
            ((CallableStatement)sqlQuery).registerOutParameter(i + 1, -2);
        } else {
            ((CallableStatement)sqlQuery).registerOutParameter(i + 1, -2);
        }
    }

    private void setBlobValue(int queryType, String paramName, String value, String paramType, PreparedStatement sqlQuery, int i) throws SQLException, DataServiceFault {
        if ("IN".equals(paramType)) {
            if (value == null) {
                sqlQuery.setNull(i + 1, 2004);
            } else {
                byte[] data = this.getBytesFromBase64String(value);
                sqlQuery.setBlob(i + 1, new ByteArrayInputStream(data), data.length);
            }
        } else if ("INOUT".equals(paramType)) {
            if (value == null) {
                ((CallableStatement)sqlQuery).setNull(i + 1, 2004);
            } else {
                byte[] data = this.getBytesFromBase64String(value);
                ((CallableStatement)sqlQuery).setBlob(i + 1, (InputStream)new ByteArrayInputStream(data), (long)data.length);
            }
            ((CallableStatement)sqlQuery).registerOutParameter(i + 1, 2004);
        } else {
            ((CallableStatement)sqlQuery).registerOutParameter(i + 1, 2004);
        }
    }

    private void setOracleRefCusor(PreparedStatement sqlQuery, int i) throws SQLException, DataServiceFault {
        ((CallableStatement)sqlQuery).registerOutParameter(i + 1, -10);
    }

    private void setUserDefinedType(PreparedStatement sqlQuery, int parameterIndex, String paramType, String structType) throws SQLException, DataServiceFault {
        if (!"OUT".equals(paramType)) {
            throw new DataServiceFault("IN or INOUT operations are not supported for User Defined Types");
        }
        ((CallableStatement)sqlQuery).registerOutParameter(parameterIndex + 1, 2002, structType.toUpperCase());
    }

    private void setTimestampValue(int queryType, String paramName, String value, String paramType, PreparedStatement sqlQuery, int i) throws DataServiceFault, SQLException {
        Timestamp timestamp = null;
        try {
            if (value != null) {
                timestamp = DBUtils.getTimestamp(value);
            }
        }
        catch (ParseException e) {
            throw new DataServiceFault(e, "Incorrect Timestamp format for parameter : " + paramName + ". Timestamp should be in one of following formats " + "yyyy-MM-dd'T'hh:mm:ss.sss'+'hh:mm, " + "yyyy-MM-dd'T'hh:mm:ss.sss'-'hh:mm, " + "yyyy-MM-dd'T'hh:mm:ss.sss'Z', " + "yyyy-MM-dd hh:mm:ss.SSSSSS or " + "yyyy-MM-dd hh:mm:ss");
        }
        if ("IN".equals(paramType)) {
            if (queryType == 1) {
                if (value == null) {
                    sqlQuery.setNull(i + 1, 93);
                } else {
                    sqlQuery.setTimestamp(i + 1, timestamp);
                }
            } else if (value == null) {
                ((CallableStatement)sqlQuery).setNull(i + 1, 93);
            } else {
                ((CallableStatement)sqlQuery).setTimestamp(i + 1, timestamp);
            }
        } else if ("INOUT".equals(paramType)) {
            if (value == null) {
                ((CallableStatement)sqlQuery).setNull(i + 1, 93);
            } else {
                ((CallableStatement)sqlQuery).setTimestamp(i + 1, timestamp);
            }
            ((CallableStatement)sqlQuery).registerOutParameter(i + 1, 93);
        } else {
            ((CallableStatement)sqlQuery).registerOutParameter(i + 1, 93);
        }
    }

    private void setDateValue(int queryType, String paramName, String value, String paramType, PreparedStatement sqlQuery, int i) throws SQLException, DataServiceFault {
        Date val = null;
        if (value != null) {
            val = DBUtils.getDate(value);
        }
        try {
            if ("IN".equals(paramType)) {
                if (queryType == 1) {
                    if (value == null) {
                        sqlQuery.setNull(i + 1, 91);
                    } else {
                        sqlQuery.setDate(i + 1, val);
                    }
                } else if (value == null) {
                    ((CallableStatement)sqlQuery).setNull(i + 1, 91);
                } else {
                    ((CallableStatement)sqlQuery).setDate(i + 1, val);
                }
            } else if ("INOUT".equals(paramType)) {
                if (value == null) {
                    ((CallableStatement)sqlQuery).setNull(i + 1, 91);
                } else {
                    ((CallableStatement)sqlQuery).setDate(i + 1, val);
                }
                ((CallableStatement)sqlQuery).registerOutParameter(i + 1, 91);
            } else {
                ((CallableStatement)sqlQuery).registerOutParameter(i + 1, 91);
            }
        }
        catch (IllegalArgumentException e) {
            throw new DataServiceFault(e, "Incorrect date format for parameter  : " + paramName + ". Date should be in yyyy-mm-dd format.");
        }
    }

    private void setRealValue(int queryType, String value, String paramType, PreparedStatement sqlQuery, int i) throws SQLException {
        Float val = null;
        if (value != null) {
            val = new Float(value);
        }
        if ("IN".equals(paramType)) {
            if (queryType == 1) {
                if (value == null) {
                    sqlQuery.setNull(i + 1, 6);
                } else {
                    sqlQuery.setFloat(i + 1, val.floatValue());
                }
            } else if (value == null) {
                ((CallableStatement)sqlQuery).setNull(i + 1, 6);
            } else {
                ((CallableStatement)sqlQuery).setFloat(i + 1, val.floatValue());
            }
        } else if ("INOUT".equals(paramType)) {
            if (value == null) {
                ((CallableStatement)sqlQuery).setNull(i + 1, 6);
            } else {
                ((CallableStatement)sqlQuery).setFloat(i + 1, val.floatValue());
            }
            ((CallableStatement)sqlQuery).registerOutParameter(i + 1, 6);
        } else {
            ((CallableStatement)sqlQuery).registerOutParameter(i + 1, 6);
        }
    }

    private void setBigIntValue(int queryType, String value, String paramType, PreparedStatement sqlQuery, int i) throws SQLException {
        Long val = null;
        if (value != null) {
            val = new Long(value);
        }
        if ("IN".equals(paramType)) {
            if (queryType == 1) {
                if (value == null) {
                    sqlQuery.setNull(i + 1, -5);
                } else {
                    sqlQuery.setLong(i + 1, val);
                }
            } else if (value == null) {
                ((CallableStatement)sqlQuery).setNull(i + 1, -5);
            } else {
                ((CallableStatement)sqlQuery).setLong(i + 1, (long)val);
            }
        } else if ("INOUT".equals(paramType)) {
            if (value == null) {
                ((CallableStatement)sqlQuery).setNull(i + 1, -5);
            } else {
                ((CallableStatement)sqlQuery).setLong(i + 1, (long)val);
            }
            ((CallableStatement)sqlQuery).registerOutParameter(i + 1, -5);
        } else {
            ((CallableStatement)sqlQuery).registerOutParameter(i + 1, -5);
        }
    }

    private void setSmallIntValue(int queryType, String value, String paramType, PreparedStatement sqlQuery, int i) throws SQLException {
        Short val = null;
        if (value != null) {
            val = new Short(value);
        }
        if ("IN".equals(paramType)) {
            if (queryType == 1) {
                if (value == null) {
                    sqlQuery.setNull(i + 1, 5);
                } else {
                    sqlQuery.setShort(i + 1, val);
                }
            } else if (value == null) {
                ((CallableStatement)sqlQuery).setNull(i + 1, 5);
            } else {
                ((CallableStatement)sqlQuery).setShort(i + 1, (short)val);
            }
        } else if ("INOUT".equals(paramType)) {
            if (value == null) {
                ((CallableStatement)sqlQuery).setNull(i + 1, 5);
            } else {
                ((CallableStatement)sqlQuery).setShort(i + 1, (short)val);
            }
            ((CallableStatement)sqlQuery).registerOutParameter(i + 1, 5);
        } else {
            ((CallableStatement)sqlQuery).registerOutParameter(i + 1, 5);
        }
    }

    private void setTinyIntValue(int queryType, String value, String paramType, PreparedStatement sqlQuery, int i) throws SQLException {
        Byte val = null;
        if (value != null) {
            val = new Byte(value);
        }
        if ("IN".equals(paramType)) {
            if (queryType == 1) {
                if (value == null) {
                    sqlQuery.setNull(i + 1, -6);
                } else {
                    sqlQuery.setByte(i + 1, val);
                }
            } else if (value == null) {
                ((CallableStatement)sqlQuery).setNull(i + 1, -6);
            } else {
                ((CallableStatement)sqlQuery).setByte(i + 1, (byte)val);
            }
        } else if ("INOUT".equals(paramType)) {
            if (value == null) {
                ((CallableStatement)sqlQuery).setNull(i + 1, -6);
            } else {
                ((CallableStatement)sqlQuery).setByte(i + 1, (byte)val);
            }
            ((CallableStatement)sqlQuery).registerOutParameter(i + 1, -6);
        } else {
            ((CallableStatement)sqlQuery).registerOutParameter(i + 1, -6);
        }
    }

    private void setBitValue(int queryType, String value, String paramType, PreparedStatement sqlQuery, int i) throws SQLException {
        Boolean val = null;
        if (value != null) {
            val = Boolean.valueOf(value);
        }
        if ("IN".equals(paramType)) {
            if (queryType == 1) {
                if (value == null) {
                    sqlQuery.setNull(i + 1, -7);
                } else {
                    sqlQuery.setBoolean(i + 1, val);
                }
            } else if (value == null) {
                ((CallableStatement)sqlQuery).setNull(i + 1, -7);
            } else {
                ((CallableStatement)sqlQuery).setBoolean(i + 1, (boolean)val);
            }
        } else if ("INOUT".equals(paramType)) {
            if (value == null) {
                ((CallableStatement)sqlQuery).setNull(i + 1, -7);
            } else {
                ((CallableStatement)sqlQuery).setBoolean(i + 1, (boolean)val);
            }
            ((CallableStatement)sqlQuery).registerOutParameter(i + 1, -7);
        } else {
            ((CallableStatement)sqlQuery).registerOutParameter(i + 1, -7);
        }
    }

    private void setNumericValue(int queryType, String value, String paramType, PreparedStatement sqlQuery, int i) throws SQLException {
        BigDecimal val = null;
        if (value != null) {
            val = new BigDecimal(value);
        }
        if ("IN".equals(paramType)) {
            if (queryType == 1) {
                if (value == null) {
                    sqlQuery.setNull(i + 1, 2);
                } else {
                    sqlQuery.setBigDecimal(i + 1, val);
                }
            } else if (value == null) {
                ((CallableStatement)sqlQuery).setNull(i + 1, 2);
            } else {
                ((CallableStatement)sqlQuery).setBigDecimal(i + 1, val);
            }
        } else if ("INOUT".equals(paramType)) {
            if (value == null) {
                ((CallableStatement)sqlQuery).setNull(i + 1, 2);
            } else {
                ((CallableStatement)sqlQuery).setBigDecimal(i + 1, val);
            }
            ((CallableStatement)sqlQuery).registerOutParameter(i + 1, 2);
        } else {
            ((CallableStatement)sqlQuery).registerOutParameter(i + 1, 2);
        }
    }

    private void setDoubleValue(int queryType, String value, String paramType, PreparedStatement sqlQuery, int i) throws SQLException {
        Double val = null;
        if (value != null) {
            val = Double.parseDouble(value);
        }
        if ("IN".equals(paramType)) {
            if (queryType == 1) {
                if (value == null) {
                    sqlQuery.setNull(i + 1, 8);
                } else {
                    sqlQuery.setDouble(i + 1, val);
                }
            } else if (value == null) {
                ((CallableStatement)sqlQuery).setNull(i + 1, 8);
            } else {
                ((CallableStatement)sqlQuery).setDouble(i + 1, (double)val);
            }
        } else if ("INOUT".equals(paramType)) {
            if (value == null) {
                ((CallableStatement)sqlQuery).setNull(i + 1, 8);
            } else {
                ((CallableStatement)sqlQuery).setDouble(i + 1, (double)val);
            }
            ((CallableStatement)sqlQuery).registerOutParameter(i + 1, 8);
        } else {
            ((CallableStatement)sqlQuery).registerOutParameter(i + 1, 8);
        }
    }

    private void setStringValue(int queryType, String value, String paramType, PreparedStatement sqlQuery, int i) throws SQLException {
        if ("IN".equals(paramType)) {
            if (queryType == 1) {
                if (value == null) {
                    sqlQuery.setNull(i + 1, 12);
                } else {
                    sqlQuery.setString(i + 1, value);
                }
            } else if (value == null) {
                ((CallableStatement)sqlQuery).setNull(i + 1, 12);
            } else {
                ((CallableStatement)sqlQuery).setString(i + 1, value);
            }
        } else if ("INOUT".equals(paramType)) {
            if (value == null) {
                ((CallableStatement)sqlQuery).setNull(i + 1, 12);
            } else {
                ((CallableStatement)sqlQuery).setString(i + 1, value);
            }
            ((CallableStatement)sqlQuery).registerOutParameter(i + 1, 12);
        } else {
            ((CallableStatement)sqlQuery).registerOutParameter(i + 1, 12);
        }
    }

    private void setIntValue(int queryType, String value, String paramType, PreparedStatement sqlQuery, int i) throws SQLException {
        Integer val = null;
        if (value != null) {
            val = Integer.parseInt(value);
        }
        if ("IN".equals(paramType)) {
            if (queryType == 1) {
                if (value == null) {
                    sqlQuery.setNull(i + 1, 4);
                } else {
                    sqlQuery.setInt(i + 1, val);
                }
            } else if (value == null) {
                ((CallableStatement)sqlQuery).setNull(i + 1, 4);
            } else {
                ((CallableStatement)sqlQuery).setInt(i + 1, (int)val);
            }
        } else if ("INOUT".equals(paramType)) {
            if (value == null) {
                ((CallableStatement)sqlQuery).setNull(i + 1, 4);
            } else {
                ((CallableStatement)sqlQuery).setInt(i + 1, (int)val);
            }
            ((CallableStatement)sqlQuery).registerOutParameter(i + 1, 4);
        } else {
            ((CallableStatement)sqlQuery).registerOutParameter(i + 1, 4);
        }
    }

    private ParamValue getOutparameterValue(CallableStatement cs, String type, int ordinal) throws DataServiceFault {
        try {
            if (type.equals("STRING")) {
                String elementValue = cs.getString(ordinal);
                return new ParamValue(elementValue == null ? null : elementValue.toString());
            }
            if (type.equals("DOUBLE")) {
                Double elementValue = cs.getDouble(ordinal);
                return new ParamValue(elementValue == null ? null : ConverterUtil.convertToString((Double)elementValue));
            }
            if (type.equals("BIGINT")) {
                Long elementValue = cs.getLong(ordinal);
                return new ParamValue(elementValue == null ? null : ConverterUtil.convertToString((Long)elementValue));
            }
            if (type.equals("INTEGER")) {
                Integer elementValue = cs.getInt(ordinal);
                return new ParamValue(elementValue == null ? null : ConverterUtil.convertToString((Integer)elementValue));
            }
            if (type.equals("TIME")) {
                java.sql.Time elementValue = cs.getTime(ordinal);
                return new ParamValue(elementValue == null ? null : this.convertToTimeString(elementValue));
            }
            if (type.equals("DATE")) {
                Date elementValue = cs.getDate(ordinal);
                return new ParamValue(elementValue == null ? null : ConverterUtil.convertToString((java.util.Date)elementValue));
            }
            if (type.equals("TIMESTAMP")) {
                Timestamp elementValue = cs.getTimestamp(ordinal);
                return new ParamValue(elementValue == null ? null : this.convertToTimestampString(elementValue));
            }
            if (type.equals("BLOB")) {
                Blob elementValue = cs.getBlob(ordinal);
                return new ParamValue(elementValue == null ? null : this.getBase64StringFromInputStream(elementValue.getBinaryStream()));
            }
            if (type.equals("STRUCT")) {
                Object elementValue = cs.getObject(ordinal);
                return new ParamValue(elementValue == null ? null : (Struct)elementValue);
            }
            if (type.equals("ARRAY")) {
                Array dataArray = cs.getArray(ordinal);
                ParamValue paramValue = new ParamValue(2);
                if (dataArray != null) {
                    this.processSQLArray(dataArray, paramValue);
                }
                return paramValue;
            }
            throw new DataServiceFault("Unsupported data type: " + type);
        }
        catch (SQLException e) {
            throw new DataServiceFault(e, "Error in getting sql output parameter values.");
        }
    }

    public QueryParam getCurrentRefCursor() {
        return this.currentRefCursor;
    }

    public boolean hasRefCursor() {
        return this.hasRefCursor;
    }

    public boolean hasSqlArrayType() {
        return this.hasSqlArrayType;
    }

    public boolean arrayTypesEnabled() {
        return this.arrayTypesEnabled;
    }

    public int getPrevRefCusorOrdinal() {
        return this.prevRefCursorOrdinal;
    }

    @Override
    public void runQuery(XMLStreamWriter xmlWriter, InternalParamCollection params, int queryLevel) throws DataServiceFault {
        if (!this.isInited()) {
            throw new DataServiceFault("The data service query has not been initialised, the data source not available?");
        }
        params = this.createProcessedNamedParams(params);
        int type = this.getQueryType();
        if (type == 1) {
            this.processNormalQuery(xmlWriter, params, queryLevel);
        } else if (type == 2) {
            this.processStoredProcQuery(xmlWriter, params, queryLevel);
        } else {
            throw new DataServiceFault("Unsupported query type: " + type);
        }
    }

    @Override
    public void releaseBatchRequestResources() {
        this.batchPreparedStatement.set(null);
    }

    public class StoredProcMetadataEntry {
        private String procedureCatalog;
        private String procedureSchema;
        private String procedureName;
        private String columnName;
        private short columnReturn;
        private int columnDataType;
        private String columnReturnTypeName;
        private int columnPrecision;
        private int columnByteLength;
        private short columnScale;
        private short columnRadix;
        private short columnNullable;
        private String columnRemarks;

        public StoredProcMetadataEntry(String procedureCatalog, String procedureSchema, String procedureName, String columnName, short columnReturn, int columnDataType, String columnReturnTypeName, int columnPrecision, int columnByteLength, short columnScale, short columnRadix, short columnNullable, String columnRemarks) {
            this.procedureCatalog = procedureCatalog;
            this.procedureSchema = procedureSchema;
            this.procedureName = procedureName;
            this.columnName = columnName;
            this.columnReturn = columnReturn;
            this.columnDataType = columnDataType;
            this.columnReturnTypeName = columnReturnTypeName;
            this.columnPrecision = columnPrecision;
            this.columnByteLength = columnByteLength;
            this.columnScale = columnScale;
            this.columnRadix = columnRadix;
            this.columnNullable = columnNullable;
            this.columnRemarks = columnRemarks;
        }

        public String getProcedureCatalog() {
            return this.procedureCatalog;
        }

        public String getProcedureSchema() {
            return this.procedureSchema;
        }

        public String getProcedureName() {
            return this.procedureName;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public short getColumnReturn() {
            return this.columnReturn;
        }

        public int getColumnDataType() {
            return this.columnDataType;
        }

        public String getColumnReturnTypeName() {
            return this.columnReturnTypeName;
        }

        public int getColumnPrecision() {
            return this.columnPrecision;
        }

        public int getColumnByteLength() {
            return this.columnByteLength;
        }

        public short getColumnScale() {
            return this.columnScale;
        }

        public short getColumnRadix() {
            return this.columnRadix;
        }

        public short getColumnNullable() {
            return this.columnNullable;
        }

        public String getColumnRemarks() {
            return this.columnRemarks;
        }
    }

    private class StoredProcMetadataCollection {
        private List<StoredProcMetadataEntry> entries = new ArrayList<StoredProcMetadataEntry>();

        public StoredProcMetadataCollection(ResultSet rs) throws SQLException {
            do {
                this.entries.add(new StoredProcMetadataEntry(rs.getString(1), rs.getString(2), rs.getString(3), rs.getString(4), rs.getShort(5), rs.getInt(6), rs.getString(7), rs.getInt(8), rs.getInt(9), rs.getShort(10), rs.getShort(11), rs.getShort(12), rs.getString(13)));
            } while (rs.next());
        }

        public List<StoredProcMetadataEntry> getEntries() {
            return this.entries;
        }
    }
}

