/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.description.query;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.QuerySolutionMap;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axis2.databinding.types.Time;
import org.apache.axis2.databinding.utils.ConverterUtil;
import org.wso2.carbon.dataservices.core.DataServiceFault;
import org.wso2.carbon.dataservices.core.description.config.RDFConfig;
import org.wso2.carbon.dataservices.core.description.event.EventTrigger;
import org.wso2.carbon.dataservices.core.description.query.Query;
import org.wso2.carbon.dataservices.core.engine.DataEntry;
import org.wso2.carbon.dataservices.core.engine.DataService;
import org.wso2.carbon.dataservices.core.engine.InternalParam;
import org.wso2.carbon.dataservices.core.engine.InternalParamCollection;
import org.wso2.carbon.dataservices.core.engine.ParamValue;
import org.wso2.carbon.dataservices.core.engine.QueryParam;
import org.wso2.carbon.dataservices.core.engine.Result;

public class SPARQLQuery
extends Query {
    private String query;
    private RDFConfig config;

    public SPARQLQuery(DataService dataService, String queryId, String configId, String query, List<QueryParam> queryParams, Result result, EventTrigger inputEventTrigger, EventTrigger outputEventTrigger, Map<String, String> advancedProperties, String inputNamespace) throws DataServiceFault {
        super(dataService, queryId, queryParams, result, configId, inputEventTrigger, outputEventTrigger, advancedProperties, inputNamespace);
        this.query = query;
        try {
            this.config = (RDFConfig)this.getDataService().getConfig(this.getConfigId());
        }
        catch (ClassCastException e) {
            throw new DataServiceFault(e, "Configuration is not a RDF config:" + this.getConfigId());
        }
    }

    @Override
    public void runQuery(XMLStreamWriter xmlWriter, InternalParamCollection params, int queryLevel) throws DataServiceFault {
        this.processQuery(xmlWriter, params, queryLevel);
    }

    private RDFNode convertTypeLiteral(Model model, InternalParam param) throws DataServiceFault {
        String value = param.getValue().getScalarValue();
        String type = param.getSqlType();
        if (type == null) {
            return model.createTypedLiteral(value);
        }
        if ("INTEGER".equals(type)) {
            return model.createTypedLiteral(value, (RDFDatatype)XSDDatatype.XSDinteger);
        }
        if ("ANYURI".equals(type)) {
            return model.createResource(value);
        }
        if ("DECIMAL".equals(type)) {
            return model.createTypedLiteral(value, (RDFDatatype)XSDDatatype.XSDdecimal);
        }
        if ("DOUBLE".equals(type)) {
            return model.createTypedLiteral(value, (RDFDatatype)XSDDatatype.XSDdouble);
        }
        if ("FLOAT".equals(type)) {
            return model.createTypedLiteral(value, (RDFDatatype)XSDDatatype.XSDfloat);
        }
        if ("STRING".equals(type)) {
            return model.createTypedLiteral(value);
        }
        if ("BOOLEAN".equals(type)) {
            return model.createTypedLiteral(value, (RDFDatatype)XSDDatatype.XSDboolean);
        }
        if ("LONG".equals(type)) {
            return model.createTypedLiteral(value, (RDFDatatype)XSDDatatype.XSDlong);
        }
        if ("DATE".equals(type)) {
            return model.createTypedLiteral(value, (RDFDatatype)XSDDatatype.XSDdate);
        }
        if ("DATETIME".equals(type)) {
            return model.createTypedLiteral(value, (RDFDatatype)XSDDatatype.XSDdateTime);
        }
        if ("TIME".equals(type)) {
            return model.createTypedLiteral(value, (RDFDatatype)XSDDatatype.XSDtime);
        }
        if ("GYEARMONTH".equals(type)) {
            return model.createTypedLiteral(value, (RDFDatatype)XSDDatatype.XSDgYearMonth);
        }
        if ("GYEAR".equals(type)) {
            return model.createTypedLiteral(value, (RDFDatatype)XSDDatatype.XSDgYear);
        }
        if ("GMONTHDAY".equals(type)) {
            return model.createTypedLiteral(value, (RDFDatatype)XSDDatatype.XSDgMonthDay);
        }
        if ("GDAY".equals(type)) {
            return model.createTypedLiteral(value, (RDFDatatype)XSDDatatype.XSDgDay);
        }
        if ("GMONTH".equals(type)) {
            return model.createTypedLiteral(value, (RDFDatatype)XSDDatatype.XSDgMonth);
        }
        if ("HEXBINARY".equals(type)) {
            return model.createTypedLiteral(value, (RDFDatatype)XSDDatatype.XSDhexBinary);
        }
        if ("BASE64BINARY".equals(type)) {
            return model.createTypedLiteral(value, (RDFDatatype)XSDDatatype.XSDbase64Binary);
        }
        if ("QNAME".equals(type)) {
            return model.createTypedLiteral(value, (RDFDatatype)XSDDatatype.XSDQName);
        }
        if ("NOTATION".equals(type)) {
            return model.createTypedLiteral(value, (RDFDatatype)XSDDatatype.XSDNOTATION);
        }
        throw new DataServiceFault("[" + this.getDataService().getName() + "]  Found Unsupported data type : " + type + " as input parameter.");
    }

    private String convertRSToString(QuerySolution soln, String colName) {
        if (soln.getLiteral(colName).getDatatype() == null) {
            return soln.getLiteral(colName).getString();
        }
        String colType = soln.getLiteral(colName).getDatatype().getURI();
        if (colType.equals(XSDDatatype.XSDdecimal.getURI())) {
            return ConverterUtil.convertToString((Object)ConverterUtil.convertToDecimal((String)soln.getLiteral(colName).getString()));
        }
        if (colType.equals(XSDDatatype.XSDdouble.getURI())) {
            return ConverterUtil.convertToString((double)ConverterUtil.convertToDouble((String)soln.getLiteral(colName).getString()));
        }
        if (colType.equals(XSDDatatype.XSDfloat.getURI())) {
            return ConverterUtil.convertToString((float)ConverterUtil.convertToFloat((String)soln.getLiteral(colName).getString()));
        }
        if (colType.equals(XSDDatatype.XSDstring.getURI())) {
            return soln.getLiteral(colName).getString();
        }
        if (colType.equals(XSDDatatype.XSDboolean.getURI())) {
            return ConverterUtil.convertToString((boolean)ConverterUtil.convertToBoolean((String)soln.getLiteral(colName).getString()));
        }
        if (colType.equals(XSDDatatype.XSDlong.getURI())) {
            return ConverterUtil.convertToString((long)ConverterUtil.convertToLong((String)soln.getLiteral(colName).getString()));
        }
        if (colType.equals(XSDDatatype.XSDdate.getURI())) {
            return ConverterUtil.convertToString((Date)ConverterUtil.convertToDate((String)soln.getLiteral(colName).getString()));
        }
        if (colType.equals(XSDDatatype.XSDdateTime.getURI())) {
            return ConverterUtil.convertToString((Calendar)ConverterUtil.convertToDateTime((String)soln.getLiteral(colName).getString()));
        }
        if (colType.equals(XSDDatatype.XSDtime.getURI())) {
            return ConverterUtil.convertToString((Time)ConverterUtil.convertToTime((String)soln.getLiteral(colName).getString()));
        }
        return soln.getLiteral(colName).getString();
    }

    private DataEntry getDataEntryFromRS(ResultSet rs) {
        DataEntry dataEntry = new DataEntry();
        QuerySolution soln = rs.nextSolution();
        boolean useColumnNumbers = this.isUsingColumnNumbers();
        for (int i = 0; i < rs.getResultVars().size(); ++i) {
            String colName = (String)rs.getResultVars().get(i);
            RDFNode node = soln.get(colName);
            String value = node.isLiteral() ? this.convertRSToString(soln, colName) : soln.getResource(colName).getURI();
            dataEntry.addValue(useColumnNumbers ? Integer.toString(i + 1) : colName, new ParamValue(value));
        }
        return dataEntry;
    }

    private void processQuery(XMLStreamWriter xmlWriter, InternalParamCollection params, int queryLevel) throws DataServiceFault {
        try {
            QuerySolutionMap queryMap = new QuerySolutionMap();
            Model model = this.getConfig().createRDFModel();
            for (InternalParam param : params.getParams()) {
                queryMap.add(param.getName(), this.convertTypeLiteral(model, param));
            }
            QueryExecution qe = QueryExecutionFactory.create((String)this.getQuery(), (Model)model);
            qe.setInitialBinding((QuerySolution)queryMap);
            ResultSet results = qe.execSelect();
            while (results.hasNext()) {
                DataEntry dataEntry = this.getDataEntryFromRS(results);
                this.writeResultEntry(xmlWriter, dataEntry, params, queryLevel);
            }
        }
        catch (Exception e) {
            throw new DataServiceFault(e, "Error in 'SPARQLQuery.processQuery'");
        }
    }

    public String getQuery() {
        return this.query;
    }

    public RDFConfig getConfig() {
        return this.config;
    }
}

