/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.description.operation;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.wso2.carbon.dataservices.core.DataServiceFault;
import org.wso2.carbon.dataservices.core.description.operation.Operation;
import org.wso2.carbon.dataservices.core.description.query.QueryFactory;
import org.wso2.carbon.dataservices.core.engine.CallQuery;
import org.wso2.carbon.dataservices.core.engine.CallQueryGroup;
import org.wso2.carbon.dataservices.core.engine.DataService;

public class OperationFactory {
    private OperationFactory() {
    }

    public static Operation createOperation(DataService dataService, OMElement opEl) throws DataServiceFault {
        String name = opEl.getAttributeValue(new QName("name"));
        OMElement descEl = opEl.getFirstChildWithName(new QName("description"));
        String description = null;
        if (descEl != null) {
            description = descEl.getText();
        }
        CallQueryGroup callQueryGroup = null;
        List<CallQueryGroup> cqGroups = QueryFactory.createCallQueryGroups(dataService, opEl.getChildrenWithName(new QName("call-query")), opEl.getChildrenWithName(new QName("call-query-group")));
        if (cqGroups.size() > 0) {
            callQueryGroup = cqGroups.get(0);
        }
        String disableStreamingRequestStr = opEl.getAttributeValue(new QName("disableStreaming"));
        boolean disableStreamingRequest = false;
        if (disableStreamingRequestStr != null) {
            disableStreamingRequest = Boolean.parseBoolean(disableStreamingRequestStr);
        }
        boolean disableStreamingEffective = disableStreamingRequest | dataService.isDisableStreaming();
        Operation operation = new Operation(dataService, name, description, callQueryGroup, false, null, disableStreamingRequest, disableStreamingEffective);
        String returnReqStatusStr = opEl.getAttributeValue(new QName("returnRequestStatus"));
        boolean returnReqStatus = false;
        if (returnReqStatusStr != null) {
            returnReqStatus = Boolean.parseBoolean(returnReqStatusStr);
        }
        operation.setReturnRequestStatus(returnReqStatus);
        return operation;
    }

    public static Operation createBeginBoxcarOperation(DataService dataService) {
        ArrayList<CallQuery> callQueries = new ArrayList<CallQuery>();
        callQueries.add(QueryFactory.createEmptyCallQuery(dataService));
        CallQueryGroup callQueryGroup = new CallQueryGroup(callQueries);
        Operation operation = new Operation(dataService, "begin_boxcar", "Control operation for beginning a boxcarring session", callQueryGroup, false, null, false, false);
        return operation;
    }

    public static Operation createEndBoxcarOperation(DataService dataService) {
        ArrayList<CallQuery> callQueries = new ArrayList<CallQuery>();
        callQueries.add(QueryFactory.createEmptyEndBoxcarCallQuery(dataService));
        CallQueryGroup callQueryGroup = new CallQueryGroup(callQueries);
        Operation operation = new Operation(dataService, "end_boxcar", "Control operation for ending a boxcarring session", callQueryGroup, false, null, false, false);
        return operation;
    }

    public static Operation createAbortBoxcarOperation(DataService dataService) {
        ArrayList<CallQuery> callQueries = new ArrayList<CallQuery>();
        callQueries.add(QueryFactory.createEmptyCallQuery(dataService));
        CallQueryGroup callQueryGroup = new CallQueryGroup(callQueries);
        Operation operation = new Operation(dataService, "abort_boxcar", "Control operation for aborting a boxcarring session", callQueryGroup, false, null, false, false);
        return operation;
    }
}

