/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.description.event;

import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.dataservices.core.DBUtils;
import org.wso2.carbon.dataservices.core.DataServiceFault;
import org.wso2.carbon.dataservices.core.engine.DataService;
import org.wso2.carbon.dataservices.core.internal.DataServicesDSComponent;
import org.wso2.carbon.event.core.EventBroker;
import org.wso2.carbon.event.core.Message;
import org.wso2.carbon.event.core.subscription.Subscription;

public abstract class EventTrigger {
    public static final String EVENT_DISPATCHER_NAME = "wsEventDispatcher";
    private static Log log = LogFactory.getLog(EventTrigger.class);
    private DataService dataService;
    private String language;
    private String triggerId;
    private String expression;
    private String targetTopic;
    private List<String> endpointUrls;

    public EventTrigger(DataService dataService, String language, String triggerId, String expression, String targetTopic, List<String> endpointUrls) throws DataServiceFault {
        this.dataService = dataService;
        this.language = language;
        this.triggerId = triggerId;
        this.expression = expression;
        this.targetTopic = targetTopic;
        this.endpointUrls = endpointUrls;
    }

    public void initEventBroker(EventBroker eventBroker) throws DataServiceFault {
        if (!this.dataService.isServiceInactive()) {
            this.registerSubscribers(eventBroker, this.getTargetTopic(), this.endpointUrls);
        }
    }

    public DataService getDataService() {
        return this.dataService;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getTriggerId() {
        return this.triggerId;
    }

    public String getExpression() {
        return this.expression;
    }

    public String getTargetTopic() {
        return this.targetTopic;
    }

    public List<String> getEndpointUrls() {
        return this.endpointUrls;
    }

    private void registerSubscribers(EventBroker eventBroker, String topic, List<String> endpointUrls) throws DataServiceFault {
        if (eventBroker == null) {
            String msg = "Unable To Register Event Subscribers, Event Broker Not Available.";
            log.error((Object)msg);
            throw new DataServiceFault(msg);
        }
        for (String epr : endpointUrls) {
            try {
                Subscription subscription = new Subscription();
                subscription.setEventSinkURL(epr);
                subscription.setId(UUID.randomUUID().toString());
                subscription.setTopicName(topic);
                subscription.setEventDispatcherName(EVENT_DISPATCHER_NAME);
                subscription.setOwner("wso2.system.user");
                subscription.setProperties(this.getSubscriptionProperties());
                eventBroker.subscribe(subscription);
            }
            catch (Exception e) {
                throw new DataServiceFault(e, "Error in event subscription for EPR: " + epr + " Topic:" + topic);
            }
        }
    }

    private Map<String, String> getSubscriptionProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("dataServiceName", this.getDataService().getName());
        return properties;
    }

    private void sendMessageToTopic(OMElement omMessage, String topic) throws DataServiceFault {
        try {
            EventBroker eventBroker = DataServicesDSComponent.getEventBroker();
            if (eventBroker == null) {
                throw new DataServiceFault("Event broker instance is not available");
            }
            Message message = new Message();
            message.setMessage(omMessage);
            eventBroker.publish(message, topic);
        }
        catch (Exception e) {
            throw new DataServiceFault(e, "Error in publishing event for topic: " + topic + " message:-\n" + omMessage);
        }
    }

    protected abstract boolean evaluate(OMElement var1) throws DataServiceFault;

    private OMElement createEventMessage(DataService dataService, String queryId, OMElement data) {
        OMFactory fac = DBUtils.getOMFactory();
        OMElement result = fac.createOMElement(new QName("data-services-event"));
        OMElement serviceNameEl = fac.createOMElement(new QName("service-name"));
        serviceNameEl.setText(dataService.getName());
        result.addChild((OMNode)serviceNameEl);
        OMElement queryIdEl = fac.createOMElement(new QName("query-id"));
        queryIdEl.setText(queryId);
        result.addChild((OMNode)queryIdEl);
        OMElement timeEl = fac.createOMElement(new QName("time"));
        timeEl.setText(Calendar.getInstance().getTime().toString());
        result.addChild((OMNode)timeEl);
        OMElement contentEl = fac.createOMElement(new QName("content"));
        contentEl.addChild((OMNode)data);
        result.addChild((OMNode)contentEl);
        result = result.cloneOMElement();
        OMDocument doc = fac.createOMDocument();
        doc.addChild((OMNode)result);
        return doc.getOMDocumentElement();
    }

    public void execute(OMElement input, String queryId) throws DataServiceFault {
        if (this.evaluate(input)) {
            this.sendMessageToTopic(this.createEventMessage(this.getDataService(), queryId, input), this.getTargetTopic());
        }
    }
}

