/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.description.config;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import javax.sql.DataSource;
import javax.sql.XAConnection;
import javax.transaction.Transaction;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.dataservices.common.DBConstants;
import org.wso2.carbon.dataservices.core.DBUtils;
import org.wso2.carbon.dataservices.core.DataServiceFault;
import org.wso2.carbon.dataservices.core.auth.ConfigurationBasedAuthenticator;
import org.wso2.carbon.dataservices.core.auth.DynamicUserAuthenticator;
import org.wso2.carbon.dataservices.core.description.config.Config;
import org.wso2.carbon.dataservices.core.engine.DataService;

public abstract class SQLConfig
extends Config {
    private static final Log log = LogFactory.getLog(SQLConfig.class);
    private String validationQuery = this.getProperty("validationQuery");
    private boolean jdbcBatchUpdateSupport;
    private DBConstants.AutoCommit autoCommit;
    private DynamicUserAuthenticator primaryDynAuth;
    private DynamicUserAuthenticator secondaryDynAuth;

    public SQLConfig(DataService dataService, String configId, String type, Map<String, String> properties) throws DataServiceFault {
        super(dataService, configId, type, properties);
        this.processAutoCommitValue();
        this.processDynamicAuth();
    }

    private void processDynamicAuth() throws DataServiceFault {
        String dynAuthClass;
        String dynAuthMapping = this.getProperty("dynamicUserAuthMapping");
        if (!DBUtils.isEmptyString(dynAuthMapping)) {
            OMElement dynUserAuthPropEl;
            try {
                dynUserAuthPropEl = AXIOMUtil.stringToOM((String)dynAuthMapping);
            }
            catch (XMLStreamException e) {
                throw new DataServiceFault(e, "Error in reading dynamic user auth mapping configuration: " + e.getMessage());
            }
            OMElement dynUserAuthConfEl = dynUserAuthPropEl.getFirstElement();
            if (dynUserAuthConfEl == null) {
                throw new DataServiceFault("Invalid dynamic user auth mapping configuration");
            }
            this.primaryDynAuth = new ConfigurationBasedAuthenticator(dynUserAuthConfEl.toString());
        }
        if (!DBUtils.isEmptyString(dynAuthClass = this.getProperty("dynamicUserAuthClass"))) {
            try {
                DynamicUserAuthenticator authObj = (DynamicUserAuthenticator)Class.forName(dynAuthClass).newInstance();
                if (this.primaryDynAuth == null) {
                    this.primaryDynAuth = authObj;
                } else {
                    this.secondaryDynAuth = authObj;
                }
            }
            catch (Exception e) {
                throw new DataServiceFault(e, "Error in creating dynamic user authenticator: " + e.getMessage());
            }
        }
    }

    private void processAutoCommitValue() throws DataServiceFault {
        String autoCommitProp = this.getProperty("autoCommit");
        if (!DBUtils.isEmptyString(autoCommitProp)) {
            autoCommitProp = autoCommitProp.trim();
            try {
                boolean acBool = Boolean.parseBoolean(autoCommitProp);
                if (acBool) {
                    this.autoCommit = DBConstants.AutoCommit.AUTO_COMMIT_ON;
                }
                this.autoCommit = DBConstants.AutoCommit.AUTO_COMMIT_OFF;
            }
            catch (Exception e) {
                throw new DataServiceFault(e, "Invalid autocommit value in config: " + autoCommitProp + ", autocommit should be a boolean value");
            }
        } else {
            this.autoCommit = DBConstants.AutoCommit.DEFAULT;
        }
    }

    public DynamicUserAuthenticator getPrimaryDynAuth() {
        return this.primaryDynAuth;
    }

    public DynamicUserAuthenticator getSecondaryDynAuth() {
        return this.secondaryDynAuth;
    }

    public boolean hasJDBCBatchUpdateSupport() {
        return this.jdbcBatchUpdateSupport;
    }

    public DBConstants.AutoCommit getAutoCommit() {
        return this.autoCommit;
    }

    protected void initSQLDataSource() throws SQLException, DataServiceFault {
        Connection conn = this.createConnection();
        this.jdbcBatchUpdateSupport = conn.getMetaData().supportsBatchUpdates();
        conn.close();
    }

    public abstract DataSource getDataSource() throws DataServiceFault;

    public abstract boolean isStatsAvailable() throws DataServiceFault;

    public abstract int getActiveConnectionCount() throws DataServiceFault;

    public abstract int getIdleConnectionCount() throws DataServiceFault;

    public String getValidationQuery() {
        return this.validationQuery;
    }

    public Connection createConnection() throws SQLException, DataServiceFault {
        return this.createConnection(null, null);
    }

    public Connection createConnection(String user, String pass) throws SQLException, DataServiceFault {
        DataSource ds;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Creating data source connection");
        }
        if ((ds = this.getDataSource()) != null) {
            Connection conn = user != null ? ds.getConnection(user, pass) : ds.getConnection();
            if (this.getDataService().isEnableXA() && this.getDataService().isInTransaction() && conn instanceof XAConnection) {
                try {
                    Transaction tx = this.getDataService().getDSSTxManager().getTransactionManager().getTransaction();
                    tx.enlistResource(((XAConnection)((Object)conn)).getXAResource());
                }
                catch (Exception e) {
                    throw new DataServiceFault(e, "Error in getting current transaction: " + e.getMessage());
                }
            }
            return conn;
        }
        throw new DataServiceFault("The data source is nonexistent");
    }

    @Override
    public boolean isActive() {
        try {
            Connection conn = this.getDataSource().getConnection();
            conn.close();
            return true;
        }
        catch (Exception e) {
            log.error((Object)"Error in checking SQL config availability", (Throwable)e);
            return false;
        }
    }
}

