/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.description.config;

import com.google.gdata.client.GoogleAuthTokenFactory;
import com.google.gdata.client.spreadsheet.SpreadsheetService;
import com.google.gdata.data.IFeed;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.dataservices.core.DBUtils;
import org.wso2.carbon.dataservices.core.DataServiceFault;
import org.wso2.carbon.dataservices.core.description.config.Config;
import org.wso2.carbon.dataservices.core.engine.DataService;
import org.wso2.carbon.dataservices.core.internal.DataServicesDSComponent;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.session.UserRegistry;

public class GSpreadConfig
extends Config {
    private static final Log log = LogFactory.getLog(GSpreadConfig.class);
    public static final String BASE_WORKSHEET_URL = "http://spreadsheets.google.com/feeds/worksheets/";
    public static final String BASE_REGISTRY_AUTH_TOKEN_PATH = "/repository/components/org.wso2.carbon.dataservices.core/services/";
    private String username = this.getProperty("gspread_username");
    private String password = DBUtils.resolvePasswordValue(this.getDataService(), this.getProperty("gspread_password"));
    private String visibility = this.getProperty("gspread_visibility");
    private String key = GSpreadConfig.extractKey(this.getProperty("gspread_datasource"));
    private SpreadsheetService service;

    public GSpreadConfig(DataService dataService, String configId, Map<String, String> properties) throws DataServiceFault {
        super(dataService, configId, "GDATA_SPREADSHEET", properties);
        if (!dataService.isServiceInactive()) {
            this.service = new SpreadsheetService(this.getDataService().getName() + ":" + this.getConfigId());
        }
    }

    public static String extractKey(String documentURL) throws DataServiceFault {
        URI documentURI;
        try {
            documentURI = new URI(documentURL);
        }
        catch (URISyntaxException e) {
            String message = "Document URL Syntax error:" + documentURL;
            log.warn((Object)message, (Throwable)e);
            throw new DataServiceFault(e, message);
        }
        String extractedQuery = documentURI.getQuery();
        int i1 = extractedQuery.lastIndexOf("key=");
        int i2 = extractedQuery.indexOf("&", i1);
        if (i2 < 0) {
            return extractedQuery.substring(i1 + 4);
        }
        return extractedQuery.substring(i1 + 4, i2);
    }

    public String generateWorksheetFeedURL() {
        return BASE_WORKSHEET_URL + this.key + "/" + this.getVisibility() + "/basic";
    }

    public String getKey() {
        return this.key;
    }

    public String getPassword() {
        return this.password;
    }

    private SpreadsheetService getService() {
        return this.service;
    }

    public String getUsername() {
        return this.username;
    }

    public String getVisibility() {
        return this.visibility;
    }

    private String generateAuthTokenResourcePath() {
        StringBuilder userKey = new StringBuilder();
        String userName = this.getUsername();
        userKey.append(userName);
        userKey.append(userName);
        userKey.append(userName);
        String resPath = BASE_REGISTRY_AUTH_TOKEN_PATH + this.getDataService().getName() + "/configs/" + this.getConfigId() + "/user_auth_token/users/" + DBUtils.encodeBase64(userKey.toString());
        return resPath;
    }

    private Resource getAuthTokenResource(Registry registry) throws Exception {
        if (registry == null) {
            return null;
        }
        String resPath = this.generateAuthTokenResourcePath();
        if (!registry.resourceExists(resPath)) {
            return null;
        }
        return registry.get(resPath);
    }

    private String getLocalUserAuthToken(Registry registry) throws Exception {
        Object content;
        Resource authTokenRes = this.getAuthTokenResource(registry);
        if (authTokenRes != null && (content = authTokenRes.getContent()) != null) {
            return new String((byte[])content, "UTF-8");
        }
        return null;
    }

    private void setLocalUserAuthToken(String userToken, Registry registry) throws Exception {
        registry.beginTransaction();
        Resource res = registry.newResource();
        res.setContent((Object)userToken.getBytes("UTF-8"));
        registry.put(this.generateAuthTokenResourcePath(), res);
        registry.commitTransaction();
    }

    public <F extends IFeed> F getFeed(URL feedUrl, Class<F> feedClass) throws Exception {
        try {
            return (F)this.getService().getFeed(feedUrl, feedClass);
        }
        catch (Exception e) {
            if (this.requiresAuth()) {
                UserRegistry registry = null;
                if (DataServicesDSComponent.getRegistryService() == null) {
                    log.warn((Object)"GSpreadConfig.getFeed(): Registry service is not available, authentication keys wont be saved");
                } else {
                    registry = DataServicesDSComponent.getRegistryService().getConfigSystemRegistry(DBUtils.getCurrentTenantId());
                }
                this.authenticate(true, (Registry)registry);
                return (F)this.getService().getFeed(feedUrl, feedClass);
            }
            throw e;
        }
    }

    private boolean requiresAuth() {
        return this.getVisibility() != null && this.getVisibility().equals("private");
    }

    private String getNewUserAuthToken() throws Exception {
        this.getService().setUserCredentials(this.getUsername(), this.getPassword());
        return ((GoogleAuthTokenFactory.UserToken)this.getService().getAuthTokenFactory().getAuthToken()).getValue();
    }

    private void authenticate(boolean refreshToken, Registry registry) throws Exception {
        String userToken;
        if (refreshToken || registry == null || (userToken = this.getLocalUserAuthToken(registry)) == null) {
            userToken = this.getNewUserAuthToken();
            if (registry != null) {
                this.setLocalUserAuthToken(userToken, registry);
            }
        }
        this.getService().setUserToken(userToken);
    }

    @Override
    public boolean isActive() {
        return this.getService() != null;
    }

    @Override
    public void close() {
    }
}

