/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.description.config;

import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.wso2.carbon.dataservices.core.DBUtils;
import org.wso2.carbon.dataservices.core.DataServiceFault;
import org.wso2.carbon.dataservices.core.description.config.CSVConfig;
import org.wso2.carbon.dataservices.core.description.config.CarbonDataSourceConfig;
import org.wso2.carbon.dataservices.core.description.config.Config;
import org.wso2.carbon.dataservices.core.description.config.ExcelConfig;
import org.wso2.carbon.dataservices.core.description.config.GSpreadConfig;
import org.wso2.carbon.dataservices.core.description.config.JNDIConfig;
import org.wso2.carbon.dataservices.core.description.config.RDBMSConfig;
import org.wso2.carbon.dataservices.core.description.config.RDFConfig;
import org.wso2.carbon.dataservices.core.description.config.SparqlEndpointConfig;
import org.wso2.carbon.dataservices.core.description.config.WebConfig;
import org.wso2.carbon.dataservices.core.engine.DataService;

public class ConfigFactory {
    private ConfigFactory() {
    }

    public static Config createConfig(DataService dataService, OMElement configEl) throws DataServiceFault {
        Map<String, String> properties = DBUtils.extractProperties(configEl);
        String configId = ConfigFactory.getConfigId(configEl);
        String configType = ConfigFactory.getConfigType(properties);
        if ("RDBMS".equals(configType)) {
            return ConfigFactory.getRDBMSConfig(dataService, configId, properties);
        }
        if ("JNDI".equals(configType)) {
            return ConfigFactory.getJNDIConfig(dataService, configId, properties);
        }
        if ("EXCEL".equals(configType)) {
            return ConfigFactory.getExcelConfig(dataService, configId, properties);
        }
        if ("RDF".equals(configType)) {
            return ConfigFactory.getRDFConfig(dataService, configId, properties);
        }
        if ("SPARQL".equals(configType)) {
            return ConfigFactory.getSparqlEndpointConfig(dataService, configId, properties);
        }
        if ("CSV".equals(configType)) {
            return ConfigFactory.getCSVConfig(dataService, configId, properties);
        }
        if ("GDATA_SPREADSHEET".equals(configType)) {
            return ConfigFactory.getGSpreadConfig(dataService, configId, properties);
        }
        if ("CARBON_DATASOURCE".equals(configType)) {
            return ConfigFactory.getCarbonDataSourceConfig(dataService, configId, properties);
        }
        if ("WEB_CONFIG".equals(configType)) {
            return ConfigFactory.getWebConfig(dataService, configId, properties);
        }
        return null;
    }

    private static RDBMSConfig getRDBMSConfig(DataService dataService, String configId, Map<String, String> properties) throws DataServiceFault {
        RDBMSConfig config = new RDBMSConfig(dataService, configId, properties);
        return config;
    }

    private static JNDIConfig getJNDIConfig(DataService dataService, String configId, Map<String, String> properties) throws DataServiceFault {
        JNDIConfig config = new JNDIConfig(dataService, configId, properties);
        return config;
    }

    private static ExcelConfig getExcelConfig(DataService dataService, String configId, Map<String, String> properties) throws DataServiceFault {
        ExcelConfig config = new ExcelConfig(dataService, configId, properties);
        return config;
    }

    private static RDFConfig getRDFConfig(DataService dataService, String configId, Map<String, String> properties) throws DataServiceFault {
        RDFConfig config = new RDFConfig(dataService, configId, properties);
        return config;
    }

    private static SparqlEndpointConfig getSparqlEndpointConfig(DataService dataService, String configId, Map<String, String> properties) throws DataServiceFault {
        SparqlEndpointConfig config = new SparqlEndpointConfig(dataService, configId, properties);
        return config;
    }

    private static CSVConfig getCSVConfig(DataService dataService, String configId, Map<String, String> properties) throws DataServiceFault {
        CSVConfig config = new CSVConfig(dataService, configId, properties);
        return config;
    }

    private static WebConfig getWebConfig(DataService dataService, String configId, Map<String, String> properties) throws DataServiceFault {
        WebConfig config = new WebConfig(dataService, configId, properties);
        return config;
    }

    private static GSpreadConfig getGSpreadConfig(DataService dataService, String configId, Map<String, String> properties) throws DataServiceFault {
        GSpreadConfig config = new GSpreadConfig(dataService, configId, properties);
        return config;
    }

    private static CarbonDataSourceConfig getCarbonDataSourceConfig(DataService dataService, String configId, Map<String, String> properties) throws DataServiceFault {
        CarbonDataSourceConfig config = new CarbonDataSourceConfig(dataService, configId, properties);
        return config;
    }

    private static String getConfigId(OMElement configEl) {
        String configId = configEl.getAttributeValue(new QName("id"));
        if (configId == null) {
            configId = "default";
        }
        return configId;
    }

    private static String getConfigType(Map<String, String> properties) throws DataServiceFault {
        if (properties.get("driverClassName") != null || properties.get("org.wso2.ws.dataservice.driver") != null || properties.get("dataSourceClassName") != null || properties.get("org.wso2.ws.dataservice.xa_datasource_class") != null) {
            return "RDBMS";
        }
        if (properties.get("excel_datasource") != null) {
            return "EXCEL";
        }
        if (properties.get("rdf_datasource") != null) {
            return "RDF";
        }
        if (properties.get("sparql_datasource") != null) {
            return "SPARQL";
        }
        if (properties.get("csv_datasource") != null) {
            return "CSV";
        }
        if (properties.get("jndi_resource_name") != null) {
            return "JNDI";
        }
        if (properties.get("gspread_datasource") != null) {
            return "GDATA_SPREADSHEET";
        }
        if (properties.get("carbon_datasource_name") != null) {
            return "CARBON_DATASOURCE";
        }
        if (properties.get("web_harvest_config") != null) {
            return "WEB_CONFIG";
        }
        throw new DataServiceFault("Cannot create config with properties: " + properties);
    }
}

