/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.description.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.dataservices.core.DataServiceFault;
import org.wso2.carbon.dataservices.core.description.config.SQLConfig;
import org.wso2.carbon.dataservices.core.engine.DataService;
import org.wso2.carbon.dataservices.core.internal.DataServicesDSComponent;
import org.wso2.carbon.ndatasource.common.DataSourceException;
import org.wso2.carbon.ndatasource.core.CarbonDataSource;
import org.wso2.carbon.ndatasource.core.DataSourceService;

public class CarbonDataSourceConfig
extends SQLConfig {
    private static final Log log = LogFactory.getLog(CarbonDataSourceConfig.class);
    private DataSource dataSource;
    private String dataSourceName;

    public CarbonDataSourceConfig(DataService dataService, String configId, Map<String, String> properties) throws DataServiceFault {
        super(dataService, configId, "CARBON_DATASOURCE", properties);
        this.dataSourceName = properties.get("carbon_datasource_name");
        this.dataSource = this.initDataSource();
    }

    @Override
    public DataSource getDataSource() {
        return this.dataSource;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    private DataSource initDataSource() throws DataServiceFault {
        DataSourceService dataSourceService = DataServicesDSComponent.getDataSourceService();
        if (dataSourceService == null) {
            throw new DataServiceFault("Carbon DataSource Service is not initialized properly");
        }
        try {
            CarbonDataSource cds = dataSourceService.getDataSource(this.getDataSourceName());
            if (cds == null) {
                throw new DataServiceFault("Cannot find data source with the name: " + this.getDataSourceName());
            }
            Object result = cds.getDSObject();
            if (!(result instanceof DataSource)) {
                throw new DataServiceFault("The data source '" + this.getDataSourceName() + "' is not of type RDBMS");
            }
            return (DataSource)result;
        }
        catch (DataSourceException e) {
            throw new DataServiceFault((Exception)((Object)e), "Error in retrieving data source: " + e.getMessage());
        }
    }

    public static List<String> getCarbonDataSourceNames() {
        DataSourceService dataSourceService = DataServicesDSComponent.getDataSourceService();
        if (dataSourceService == null) {
            log.error((Object)"CarbonDataSourceConfig.getCarbonDataSourceNames(): Carbon data source service is not available, returning empty list");
            return new ArrayList<String>();
        }
        try {
            List dsList = dataSourceService.getAllDataSourcesForType("RDBMS");
            ArrayList<String> result = new ArrayList<String>(dsList.size());
            for (CarbonDataSource cds : dsList) {
                result.add(cds.getDSMInfo().getName());
            }
            return result;
        }
        catch (Exception e) {
            log.error((Object)("Error retrieving data source list, returning empty list: " + e.getMessage()), (Throwable)e);
            return new ArrayList<String>();
        }
    }

    @Override
    public int getActiveConnectionCount() {
        return -1;
    }

    @Override
    public int getIdleConnectionCount() {
        return -1;
    }

    @Override
    public boolean isStatsAvailable() {
        return false;
    }

    @Override
    public void close() {
    }
}

