/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core.auth;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.wso2.carbon.dataservices.common.conf.DynamicAuthConfiguration;
import org.wso2.carbon.dataservices.core.DataServiceFault;
import org.wso2.carbon.dataservices.core.auth.DynamicUserAuthenticator;

public class ConfigurationBasedAuthenticator
implements DynamicUserAuthenticator {
    private Map<String, String[]> credentialsMap;

    public ConfigurationBasedAuthenticator(String xmlConfig) throws DataServiceFault {
        try {
            JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{DynamicAuthConfiguration.class});
            Unmarshaller unmarshaller = ctx.createUnmarshaller();
            DynamicAuthConfiguration conf = (DynamicAuthConfiguration)unmarshaller.unmarshal((InputStream)new ByteArrayInputStream(xmlConfig.getBytes()));
            this.credentialsMap = new HashMap<String, String[]>();
            for (DynamicAuthConfiguration.Entry entry : conf.getEntries()) {
                this.credentialsMap.put(entry.getRequest(), new String[]{entry.getUsername(), entry.getPassword()});
            }
        }
        catch (Exception e) {
            throw new DataServiceFault(e, "Error in creating ConfigurationBasedAuthenticator: " + e.getMessage());
        }
    }

    public Map<String, String[]> getCredentialsMap() {
        return this.credentialsMap;
    }

    @Override
    public String[] lookupCredentials(String user) throws DataServiceFault {
        return this.getCredentialsMap().get(user);
    }
}

