/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core;

import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.wso2.carbon.dataservices.common.DBConstants;
import org.wso2.carbon.dataservices.core.engine.DataService;
import org.wso2.carbon.dataservices.core.engine.ParamValue;

public class DataServiceFault
extends Exception {
    private static final long serialVersionUID = 1L;
    private String code;
    private String dsFaultMessage;
    private DataService sourceDataService;
    private String currentRequestName;
    private Map<String, ParamValue> currentParams;

    public DataServiceFault(Exception nestedException, String code, String dsFaultMessage) {
        super(nestedException);
        this.code = code;
        this.dsFaultMessage = dsFaultMessage;
        if (this.code == null) {
            this.code = DataServiceFault.extractFaultCode(nestedException);
        }
    }

    public static String extractFaultCode(Throwable throwable) {
        if (throwable instanceof DataServiceFault) {
            return ((DataServiceFault)throwable).getCode();
        }
        if (throwable instanceof XMLStreamException) {
            return DataServiceFault.extractFaultCode(((XMLStreamException)throwable).getNestedException());
        }
        if (throwable != null) {
            Throwable cause = throwable.getCause();
            if (cause != null) {
                return DataServiceFault.extractFaultCode(cause);
            }
            return DBConstants.FaultCodes.UNKNOWN_ERROR;
        }
        return DBConstants.FaultCodes.UNKNOWN_ERROR;
    }

    public DataServiceFault(Exception nestedException) {
        this(nestedException, null, null);
    }

    public DataServiceFault(Exception nestedException, String dsFaultMessage) {
        this(nestedException, null, dsFaultMessage);
    }

    public DataServiceFault(String code, String dsFaultMessage) {
        this(null, code, dsFaultMessage);
    }

    public DataServiceFault(String dsFaultMessage) {
        this(null, null, dsFaultMessage);
    }

    public String getCode() {
        return this.code;
    }

    public String getDsFaultMessage() {
        return this.dsFaultMessage;
    }

    @Override
    public String getMessage() {
        return this.getFullMessage();
    }

    public String getFullMessage() {
        StringBuffer buff = new StringBuffer();
        if (this.getDsFaultMessage() != null) {
            buff.append("DS Fault Message: " + this.getDsFaultMessage() + "\n");
        }
        if (this.getCode() != null) {
            buff.append("DS Code: " + this.getCode() + "\n");
        }
        if (this.getSourceDataService() != null) {
            buff.append("Source Data Service:-\n");
            buff.append(this.getSourceDataService().toString());
        }
        if (this.getCurrentRequestName() != null) {
            buff.append("Current Request Name: " + this.getCurrentRequestName() + "\n");
        }
        if (this.getCurrentParams() != null) {
            buff.append("Current Params: " + this.getCurrentParams() + "\n");
        }
        if (this.getCause() != null) {
            buff.append("Nested Exception:-\n" + this.getCause() + "\n");
        }
        return buff.toString();
    }

    @Override
    public String toString() {
        return this.getFullMessage();
    }

    public Map<String, ParamValue> getCurrentParams() {
        return this.currentParams;
    }

    public void setCurrentParams(Map<String, ParamValue> currentParams) {
        this.currentParams = currentParams;
    }

    public String getCurrentRequestName() {
        return this.currentRequestName;
    }

    public void setCurrentRequestName(String currentRequestName) {
        this.currentRequestName = currentRequestName;
    }

    public DataService getSourceDataService() {
        return this.sourceDataService;
    }

    public void setSourceDataService(DataService sourceDataService) {
        this.sourceDataService = sourceDataService;
    }
}

