/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.core;

import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.wso2.carbon.dataservices.core.DBUtils;
import org.wso2.carbon.dataservices.core.DataServiceFault;
import org.wso2.carbon.dataservices.core.description.config.ConfigFactory;
import org.wso2.carbon.dataservices.core.description.event.EventTriggerFactory;
import org.wso2.carbon.dataservices.core.description.operation.Operation;
import org.wso2.carbon.dataservices.core.description.operation.OperationFactory;
import org.wso2.carbon.dataservices.core.description.query.QueryFactory;
import org.wso2.carbon.dataservices.core.description.resource.ResourceFactory;
import org.wso2.carbon.dataservices.core.engine.CallableRequest;
import org.wso2.carbon.dataservices.core.engine.DataService;
import org.wso2.carbon.dataservices.core.engine.Result;
import org.wso2.carbon.dataservices.core.internal.DataServicesDSComponent;
import org.wso2.securevault.SecretResolver;
import org.wso2.securevault.SecretResolverFactory;

public class DataServiceFactory {
    public static DataService createDataService(OMElement dbsElement, String dsLocation) throws DataServiceFault {
        DataService dataService = null;
        try {
            String boxcarringEnabledStr;
            String serviceGroup;
            String defaultNamespace;
            String serviceName = dbsElement.getAttributeValue(new QName("name"));
            String serviceNamespace = dbsElement.getAttributeValue(new QName("serviceNamespace"));
            if (DBUtils.isEmptyString(serviceNamespace)) {
                serviceNamespace = "http://ws.wso2.org/dataservice";
            }
            if (DBUtils.isEmptyString(defaultNamespace = dbsElement.getAttributeValue(new QName("baseURI")))) {
                defaultNamespace = serviceNamespace;
            }
            if (DBUtils.isEmptyString(serviceGroup = dbsElement.getAttributeValue(new QName("serviceGroup")))) {
                serviceGroup = serviceName;
            }
            OMElement descEl = dbsElement.getFirstChildWithName(new QName("description"));
            String description = null;
            if (descEl != null) {
                description = descEl.getText();
            }
            String serviceStatus = dbsElement.getAttributeValue(new QName("serviceStatus"));
            boolean batchRequestsEnabled = false;
            boolean boxcarringEnabled = false;
            String batchRequestsEnabledStr = dbsElement.getAttributeValue(new QName("enableBatchRequests"));
            if (batchRequestsEnabledStr != null) {
                batchRequestsEnabled = Boolean.parseBoolean(batchRequestsEnabledStr);
            }
            if ((boxcarringEnabledStr = dbsElement.getAttributeValue(new QName("enableBoxcarring"))) != null) {
                boxcarringEnabled = Boolean.parseBoolean(boxcarringEnabledStr);
            }
            boolean disableStreaming = false;
            String disableStreamingStr = dbsElement.getAttributeValue(new QName("disableStreaming"));
            if (disableStreamingStr != null) {
                disableStreaming = Boolean.parseBoolean(disableStreamingStr);
            }
            boolean enableDTP = false;
            String enableDTPStr = dbsElement.getAttributeValue(new QName("enableDTP"));
            if (enableDTPStr != null) {
                enableDTP = Boolean.parseBoolean(enableDTPStr);
            }
            String userTxJNDIName = dbsElement.getAttributeValue(new QName("txManagerJNDIName"));
            dataService = new DataService(serviceName, description, defaultNamespace, dsLocation, serviceStatus, batchRequestsEnabled, boxcarringEnabled, enableDTP, userTxJNDIName);
            dataService.setServiceNamespace(serviceNamespace);
            dataService.setDisableStreaming(disableStreaming);
            Iterator passwordMngrItr = dbsElement.getChildrenWithName(new QName("passwordManager"));
            if (passwordMngrItr.hasNext()) {
                SecretResolver secretResolver = SecretResolverFactory.create((OMElement)dbsElement, (boolean)false);
                dataService.setSecretResolver(secretResolver);
            }
            Iterator itr = dbsElement.getChildrenWithName(new QName("config"));
            while (itr.hasNext()) {
                dataService.addConfig(ConfigFactory.createConfig(dataService, (OMElement)itr.next()));
            }
            itr = dbsElement.getChildrenWithName(new QName("event-trigger"));
            while (itr.hasNext()) {
                dataService.addEventTrigger(EventTriggerFactory.createEventTrigger(dataService, (OMElement)itr.next()));
            }
            itr = dbsElement.getChildrenWithName(new QName("query"));
            while (itr.hasNext()) {
                dataService.addQuery(QueryFactory.createQuery(dataService, (OMElement)itr.next()));
            }
            itr = dbsElement.getChildrenWithName(new QName("operation"));
            while (itr.hasNext()) {
                dataService.addOperation(OperationFactory.createOperation(dataService, (OMElement)itr.next()));
            }
            itr = dbsElement.getChildrenWithName(new QName("resource"));
            while (itr.hasNext()) {
                dataService.addResource(ResourceFactory.createResource(dataService, (OMElement)itr.next()));
            }
            dataService.init();
            for (String opName : dataService.getOperationNames()) {
                Result result = dataService.getOperation(opName).getCallQueryGroup().getDefaultCallQuery().getQuery().getResult();
                if (result == null || result.getResultType() != 1) continue;
                throw new DataServiceFault("Cannot create operation " + dataService.getOperation(opName) + "for the result output type RDF");
            }
            if (dataService.isBatchRequestsEnabled()) {
                ArrayList<Operation> tmpOpList = new ArrayList<Operation>();
                for (String opName : dataService.getOperationNames()) {
                    Operation operation;
                    if (DataServiceFactory.isBoxcarringOps(opName) || !DataServiceFactory.isBatchCompatible(operation = dataService.getOperation(opName))) continue;
                    Operation batchOp = new Operation(operation.getDataService(), operation.getName() + "_batch_req", "batch operation for '" + operation.getName() + "'", operation.getCallQueryGroup(), true, operation, operation.isDisableStreamingRequest(), operation.isDisableStreamingEffective());
                    batchOp.setReturnRequestStatus(operation.isReturnRequestStatus());
                    tmpOpList.add(batchOp);
                }
                for (Operation tmpOp : tmpOpList) {
                    dataService.addOperation(tmpOp);
                }
            }
            DataServicesDSComponent.registerEventBrokerServiceListener(dataService);
            return dataService;
        }
        catch (DataServiceFault e) {
            e.setSourceDataService(dataService);
            throw e;
        }
        catch (Exception e) {
            DataServiceFault dsf = new DataServiceFault(e);
            dsf.setSourceDataService(dataService);
            throw dsf;
        }
    }

    private static boolean isBoxcarringOps(String opName) {
        return opName.equals("begin_boxcar") || opName.equals("end_boxcar") || opName.equals("abort_boxcar");
    }

    private static boolean isBatchCompatible(CallableRequest request) {
        return !request.getCallQueryGroup().getDefaultCallQuery().getQuery().hasResult();
    }
}

