/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql.jdbc;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Map;
import java.util.Properties;
import org.apache.cassandra.cql.jdbc.CassandraConnection;
import org.apache.cassandra.cql.jdbc.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraDriver
implements Driver {
    public static final int DVR_MAJOR_VERSION = 1;
    public static final int DVR_MINOR_VERSION = 1;
    public static final int DVR_PATCH_VERSION = 0;
    public static final String DVR_NAME = "Cassandra JDBC Driver";
    private static final Logger logger = LoggerFactory.getLogger(CassandraDriver.class);

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return url.startsWith("jdbc:cassandra:");
    }

    @Override
    public Connection connect(String url, Properties props) throws SQLException {
        if (this.acceptsURL(url)) {
            Properties finalProps = Utils.parseURL(url);
            finalProps.putAll((Map<?, ?>)props);
            if (logger.isDebugEnabled()) {
                logger.debug("Final Properties to Connection: {}", (Object)finalProps);
            }
            return new CassandraConnection(finalProps);
        }
        return null;
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return 1;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties props) throws SQLException {
        if (props == null) {
            props = new Properties();
        }
        DriverPropertyInfo[] info = new DriverPropertyInfo[2];
        info[0] = new DriverPropertyInfo("user", props.getProperty("user"));
        info[0].description = "The 'user' property";
        info[1] = new DriverPropertyInfo("password", props.getProperty("password"));
        info[1].description = "The 'password' property";
        return info;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException(String.format("the Cassandra implementation does not support this method", new Object[0]));
    }

    static {
        try {
            CassandraDriver driverInst = new CassandraDriver();
            DriverManager.registerDriver(driverInst);
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

