/*
 * Decompiled with CFR 0.152.
 */
package org.webharvest.runtime.scripting;

import java.util.Map;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.webharvest.runtime.scripting.ScriptEngine;

public class JavascriptScriptEngine
extends ScriptEngine {
    private Context javascriptContext = null;
    private Scriptable scope = null;

    public JavascriptScriptEngine(Map context) {
        super(context);
    }

    private synchronized void initContextIfNeeded() {
        if (this.javascriptContext == null) {
            this.javascriptContext = Context.enter();
            this.scope = this.javascriptContext.initStandardObjects();
        }
    }

    public void setVariable(String name, Object value) {
        this.initContextIfNeeded();
        Object wrappedOut = Context.javaToJS((Object)value, (Scriptable)this.scope);
        ScriptableObject.putProperty((Scriptable)this.scope, (String)name, (Object)wrappedOut);
    }

    public Object eval(String expression) {
        this.initContextIfNeeded();
        this.pushAllVariablesFromContextToScriptEngine();
        return this.javascriptContext.evaluateString(this.scope, expression, "<cmd>", 1, null);
    }
}

