/*
 * Decompiled with CFR 0.152.
 */
package org.webharvest.runtime.processors;

import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.webharvest.definition.BaseElementDef;
import org.webharvest.definition.XsltDef;
import org.webharvest.exception.XsltException;
import org.webharvest.runtime.Scraper;
import org.webharvest.runtime.ScraperContext;
import org.webharvest.runtime.processors.BaseProcessor;
import org.webharvest.runtime.variables.NodeVariable;
import org.webharvest.runtime.variables.Variable;

public class XsltProcessor
extends BaseProcessor {
    private XsltDef xsltDef;

    public XsltProcessor(XsltDef xsltDef) {
        super(xsltDef);
        this.xsltDef = xsltDef;
    }

    public Variable execute(Scraper scraper, ScraperContext context) {
        BaseElementDef xsltElementDef = this.xsltDef.getXmlDef();
        Variable xmlStr = this.getBodyTextContent(xsltElementDef, scraper, context, true);
        this.debug(xsltElementDef, scraper, xmlStr);
        BaseElementDef stylesheetElementDef = this.xsltDef.getStylesheetDef();
        Variable stylesheetStr = this.getBodyTextContent(stylesheetElementDef, scraper, context, true);
        this.debug(stylesheetElementDef, scraper, stylesheetStr);
        try {
            TransformerFactory xformFactory = TransformerFactory.newInstance();
            StreamSource xsl = new StreamSource(new StringReader(stylesheetStr.toString()));
            Transformer stylesheet = xformFactory.newTransformer(xsl);
            StreamSource request = new StreamSource(new StringReader(xmlStr.toString()));
            StringWriter writer = new StringWriter();
            StreamResult response = new StreamResult(writer);
            stylesheet.transform(request, response);
            return new NodeVariable(writer.toString());
        }
        catch (TransformerException e) {
            throw new XsltException("Error during XSLT transforming!", e);
        }
    }
}

