/*
 * Decompiled with CFR 0.152.
 */
package org.webharvest.runtime.processors;

import net.sf.saxon.trans.XPathException;
import org.webharvest.definition.XPathDef;
import org.webharvest.exception.ScraperXPathException;
import org.webharvest.runtime.RuntimeConfig;
import org.webharvest.runtime.Scraper;
import org.webharvest.runtime.ScraperContext;
import org.webharvest.runtime.processors.BaseProcessor;
import org.webharvest.runtime.templaters.BaseTemplater;
import org.webharvest.runtime.variables.Variable;
import org.webharvest.utils.XmlUtil;

public class XPathProcessor
extends BaseProcessor {
    private XPathDef xpathDef;

    public XPathProcessor(XPathDef xpathDef) {
        super(xpathDef);
        this.xpathDef = xpathDef;
    }

    public Variable execute(Scraper scraper, ScraperContext context) {
        Variable xml = this.getBodyTextContent(this.xpathDef, scraper, context);
        String expression = BaseTemplater.execute(this.xpathDef.getExpression(), scraper.getScriptEngine());
        this.setProperty("Expression", expression);
        try {
            RuntimeConfig runtimeConfig = scraper.getRuntimeConfig();
            return XmlUtil.evaluateXPath(expression, xml.toString(), runtimeConfig);
        }
        catch (XPathException e) {
            throw new ScraperXPathException("Error parsing XPath expression (XPath = [" + expression + "])!", e);
        }
    }
}

