/*
 * Decompiled with CFR 0.152.
 */
package org.webharvest.gui.component;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.webharvest.gui.component.CommonButton;
import org.webharvest.gui.component.DropDownButtonListener;
import org.webharvest.gui.component.WHPopupMenu;

public class DropDownButton
extends CommonButton
implements ActionListener {
    private JPopupMenu popup;
    private ArrayList items = new ArrayList();
    private boolean isChangable;
    private int selectedItem = -1;
    private List listeners = new ArrayList();

    public DropDownButton() {
        this.popup = new WHPopupMenu();
        this.addActionListener(this);
        this.isChangable = true;
    }

    public DropDownButton(String text, Icon icon, boolean isChangable) {
        this();
        this.isChangable = isChangable;
        this.setText(text + "      ");
        if (icon != null) {
            this.setIcon(icon);
        }
    }

    public void addMenuSeparator() {
        this.popup.addSeparator();
    }

    public void addMenuItem(JMenuItem item) {
        this.popup.add(item);
        item.addActionListener(this);
        this.items.add(item);
    }

    public void paint(Graphics g) {
        super.paint(g);
        int w = this.getWidth();
        int h = this.getHeight();
        int[] xPoints = new int[]{w - 14, w - 7, w - 11};
        int[] yPoints = new int[]{h / 2 - 2, h / 2 - 2, h / 2 + 2};
        g.setColor(Color.black);
        g.fillPolygon(xPoints, yPoints, 3);
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this) {
            this.popup.pack();
            this.popup.show(this, 0, this.getHeight());
        } else {
            int oldSelectedItem = this.selectedItem;
            Iterator iterator = this.items.iterator();
            int index = 0;
            while (iterator.hasNext()) {
                Object curr = iterator.next();
                if (curr == source) {
                    this.changeSelectedTo(index);
                    break;
                }
                ++index;
            }
            this.popup.setVisible(false);
            if (!this.isChangable || this.selectedItem != oldSelectedItem) {
                for (DropDownButtonListener curr : this.listeners) {
                    curr.onChange(this);
                }
            }
        }
    }

    public int getSelectedItem() {
        return this.selectedItem;
    }

    public void changeSelectedTo(int index) {
        if (index >= 0 && index < this.items.size()) {
            this.selectedItem = index;
            if (this.isChangable) {
                JMenuItem itemAtIndex = (JMenuItem)this.items.get(index);
                this.setText(itemAtIndex.getText() + "  ");
                this.setIcon(itemAtIndex.getIcon());
                this.invalidate();
            }
        }
    }

    public void addListener(DropDownButtonListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(DropDownButtonListener listener) {
        this.listeners.remove(listener);
    }
}

