/*
 * Decompiled with CFR 0.152.
 */
package org.webharvest.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.webharvest.gui.AboutWindow;
import org.webharvest.gui.ConfigDocument;
import org.webharvest.gui.ConfigPanel;
import org.webharvest.gui.FindReplaceDialog;
import org.webharvest.gui.GuiUtils;
import org.webharvest.gui.HelpFrame;
import org.webharvest.gui.ResourceManager;
import org.webharvest.gui.RunParamsDialog;
import org.webharvest.gui.Settings;
import org.webharvest.gui.SettingsDialog;
import org.webharvest.gui.StatusBar;
import org.webharvest.gui.ViewerFrame;
import org.webharvest.gui.WelcomePanel;
import org.webharvest.gui.component.FixedSizeButton;
import org.webharvest.gui.component.GCPanel;
import org.webharvest.gui.component.MenuElements;
import org.webharvest.gui.component.WHPopupMenu;

public class Ide
extends JFrame
implements ActionListener,
ChangeListener {
    private static final String COMMAND_NEW = "new";
    private static final String COMMAND_OPEN = "open";
    private static final String COMMAND_SAVE = "save";
    private static final String COMMAND_SAVEAS = "saveas";
    private static final String COMMAND_CLOSE = "close";
    private static final String COMMAND_CLOSE_ALL = "closeall";
    private static final String COMMAND_REFRESH = "refresh";
    private static final String COMMAND_UNDO = "undo";
    private static final String COMMAND_REDO = "redo";
    private static final String COMMAND_CUT = "cut";
    private static final String COMMAND_COPY = "copy";
    private static final String COMMAND_PASTE = "paste";
    private static final String COMMAND_DUPLICATE = "duplicate";
    private static final String COMMAND_BREAKPOINT = "breakpoint";
    private static final String COMMAND_COMMENT = "comment";
    private static final String COMMAND_NEXTTAB = "nexttab";
    private static final String COMMAND_PREVTAB = "prevtab";
    private static final String COMMAND_FIND = "find";
    private static final String COMMAND_REPLACE = "replace";
    private static final String COMMAND_FINDNEXT = "findnext";
    private static final String COMMAND_FINDPREV = "findprev";
    private static final String COMMAND_VIEW_HIERARCHY = "viewhierarchy";
    private static final String COMMAND_VIEW_LOG = "viewlog";
    private static final String COMMAND_VIEW_LINENUMBERS = "viewlinenumbers";
    private static final String COMMAND_RUN = "run";
    private static final String COMMAND_PAUSE = "pause";
    private static final String COMMAND_STOP = "stop";
    private static final String COMMAND_VIEWVALUES = "viewvalues";
    private static final String COMMAND_EXIT = "exit";
    private static final String COMMAND_RUNPARAMS = "runparams";
    private static final String COMMAND_SETTINGS = "settings";
    private static final String COMMAND_ABOUT = "about";
    private static final String COMMAND_HOMEPAGE = "homepage";
    private static final String COMMAND_HELP = "help";
    private Map commandSets;
    private JTabbedPane tabbedPane;
    private StatusBar statusBar;
    private JMenu recentsSubmenu;
    private int configCounter;
    private SettingsDialog settingsDialog;
    private RunParamsDialog runParamsDialog;
    private FindReplaceDialog findReplaceDialog;
    private AboutWindow aboutWindow;
    Settings settings;
    private JPopupMenu editorPopupMenu;
    private HelpFrame helpFrame;

    public Ide() {
        super("Web-Harvest");
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            System.err.println("Couldn't use system look and feel.");
        }
        this.commandSets = new HashMap();
        this.configCounter = 0;
        this.aboutWindow = new AboutWindow(this);
        this.settings = new Settings();
        GuiUtils.init(this);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                Ide.this.exitApplication();
            }
        });
        this.settingsDialog = new SettingsDialog(this);
        this.runParamsDialog = new RunParamsDialog(this);
        this.findReplaceDialog = new FindReplaceDialog(this);
    }

    private void exitApplication() {
        int count = this.tabbedPane.getTabCount();
        for (int i = 0; i < count; ++i) {
            ConfigPanel currenConfigPanel;
            ConfigDocument configDocument;
            Component component = this.tabbedPane.getComponentAt(i);
            if (!(component instanceof ConfigPanel) || (configDocument = (currenConfigPanel = (ConfigPanel)component).getConfigDocument()) == null) continue;
            boolean canceled = false;
            int status = currenConfigPanel.getScraperStatus();
            if (status == 1 || status == 2) {
                boolean bl = canceled = GuiUtils.showWarningQuestionBox("Configuration \"" + configDocument.getName() + "\" is still running!\nAre you sure you want to exit Web-Harvest?", false) != 0;
            }
            if (!canceled) {
                boolean bl = canceled = !configDocument.offerToSaveIfChanged();
            }
            if (!canceled) continue;
            return;
        }
        this.settings.writeSilentlyToFile();
        this.dispose();
        System.exit(0);
    }

    private boolean closeTab(int tabIndex) {
        ConfigPanel currenConfigPanel;
        ConfigDocument configDocument;
        Component component = this.tabbedPane.getComponentAt(tabIndex);
        if (component instanceof ConfigPanel && (configDocument = (currenConfigPanel = (ConfigPanel)component).getConfigDocument()) != null) {
            boolean canceled = false;
            int status = currenConfigPanel.getScraperStatus();
            if (status == 1 || status == 2) {
                boolean bl = canceled = GuiUtils.showWarningQuestionBox("Configuration \"" + configDocument.getName() + "\" is still running!\nAre you sure you want to exit Web-Harvest?", false) != 0;
                if (!canceled) {
                    currenConfigPanel.stopScraperExecution();
                }
            }
            if (!canceled) {
                boolean bl = canceled = !configDocument.offerToSaveIfChanged();
            }
            if (canceled) {
                return false;
            }
            currenConfigPanel.dispose();
        }
        this.tabbedPane.remove(tabIndex);
        if (this.tabbedPane.getTabCount() == 0) {
            this.openWelcomeScreen();
        }
        return true;
    }

    private void closeAllTabs() {
        while (this.tabbedPane.getComponentAt(this.tabbedPane.getTabCount() - 1) instanceof ConfigPanel) {
            boolean canceled = !this.closeTab(this.tabbedPane.getTabCount() - 1);
            if (!canceled) continue;
            return;
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(800, 600);
    }

    private void defineToolbarButton(String text, String command, Icon icon, Container container) {
        this.defineToolbarButton(text, command, icon, container, null);
    }

    private void defineToolbarButton(String text, String command, Icon icon, Container container, String label) {
        FixedSizeButton button = new FixedSizeButton(label, icon, 24, 24);
        button.setActionCommand(command);
        button.addActionListener(this);
        button.setToolTipText(text);
        container.add(button);
        this.addComponentForCommand(button, command);
    }

    private void addComponentForCommand(Component component, String command) {
        if (component == null || command == null) {
            return;
        }
        HashSet<Component> set = (HashSet<Component>)this.commandSets.get(command);
        if (set == null) {
            set = new HashSet<Component>();
            this.commandSets.put(command, set);
        }
        set.add(component);
    }

    private void setCommandEnabled(String command, boolean enable) {
        Set set = (Set)this.commandSets.get(command);
        if (set != null) {
            for (Component component : set) {
                component.setEnabled(enable);
            }
        }
    }

    private void setCommandSelected(String command, boolean select) {
        Set set = (Set)this.commandSets.get(command);
        if (set != null) {
            for (Component component : set) {
                if (!(component instanceof JCheckBoxMenuItem)) continue;
                ((JCheckBoxMenuItem)component).setSelected(select);
            }
        }
    }

    public void createAndShowGUI() {
        this.setJMenuBar(this.defineMenuBar());
        this.setDefaultCloseOperation(0);
        this.setIconImage(((ImageIcon)ResourceManager.WEB_HARVEST_ICON).getImage());
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.setOpaque(true);
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        JPanel buttonPanel = new JPanel(new FlowLayout(0, 1, 0));
        toolBar.add(buttonPanel);
        this.defineToolbarButton("New configuration file", COMMAND_NEW, ResourceManager.NEW_ICON, buttonPanel);
        this.defineToolbarButton("Open configuration file", COMMAND_OPEN, ResourceManager.OPEN_ICON, buttonPanel);
        this.defineToolbarButton("Save configuration file", COMMAND_SAVE, ResourceManager.SAVE_ICON, buttonPanel);
        this.defineToolbarButton("Synchronize tree view with XML editor", COMMAND_REFRESH, ResourceManager.REFRESH_ICON, buttonPanel);
        buttonPanel.add(new JSeparator(1));
        buttonPanel.add(new JSeparator(1));
        this.defineToolbarButton("Run", COMMAND_RUN, ResourceManager.RUN_ICON, buttonPanel);
        this.defineToolbarButton("Pause execution", COMMAND_PAUSE, ResourceManager.PAUSE_ICON, buttonPanel);
        this.defineToolbarButton("Stop execution", COMMAND_STOP, ResourceManager.STOP_ICON, buttonPanel);
        this.defineToolbarButton("View Runtime Values", COMMAND_VIEWVALUES, ResourceManager.VIEWVALUES_ICON, buttonPanel);
        buttonPanel.add(new JSeparator(1));
        buttonPanel.add(new JSeparator(1));
        this.defineToolbarButton("Define initial run parameters", COMMAND_RUNPARAMS, ResourceManager.RUN_PARAMS_ICON, buttonPanel);
        buttonPanel.add(new JSeparator(1));
        buttonPanel.add(new JSeparator(1));
        this.defineToolbarButton("Open Settings Dialog", COMMAND_SETTINGS, ResourceManager.SETTINGS_ICON, buttonPanel);
        toolBar.add(new GCPanel(new FlowLayout(2, 1, 0)));
        mainPanel.add((Component)toolBar, "North");
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setTabPlacement(3);
        this.tabbedPane.addChangeListener(this);
        final JPopupMenu tabContextMenu = this.defineTabContextMenu();
        this.tabbedPane.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                super.mouseClicked(e);
                if (e.isPopupTrigger() || e.getButton() == 3) {
                    tabContextMenu.show(e.getComponent(), e.getX(), e.getY());
                } else if (e.getButton() == 2) {
                    Ide.this.closeTab(Ide.this.tabbedPane.getSelectedIndex());
                }
            }

            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger() || e.getButton() == 3) {
                    tabContextMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        this.openWelcomeScreen();
        mainPanel.add((Component)this.tabbedPane, "Center");
        this.setContentPane(mainPanel);
        this.pack();
        this.updateGUI();
        this.setVisible(true);
    }

    private void openWelcomeScreen() {
        WelcomePanel welcomePanel = new WelcomePanel(this);
        this.tabbedPane.addTab("Welcome", new JScrollPane(welcomePanel));
        this.tabbedPane.setSelectedIndex(this.tabbedPane.getTabCount() - 1);
    }

    public void addTab() {
        ++this.configCounter;
        String tabName = "Config " + this.configCounter;
        ConfigPanel configPanel = new ConfigPanel(this, tabName);
        this.tabbedPane.addTab(tabName, configPanel);
        this.tabbedPane.setSelectedIndex(this.tabbedPane.getTabCount() - 1);
    }

    public void addTab(final Object source) {
        final ConfigPanel configPanel = new ConfigPanel(this, "");
        this.tabbedPane.addTab("Loading...", configPanel);
        this.tabbedPane.setSelectedIndex(this.tabbedPane.getTabCount() - 1);
        new Thread(new Runnable(){

            public void run() {
                configPanel.loadConfig(source);
            }
        }).start();
    }

    public void openConfigFromFile() {
        JFileChooser fileChooser = GuiUtils.getFileChooser();
        int returnVal = fileChooser.showOpenDialog(this);
        if (returnVal == 0) {
            File[] files = fileChooser.getSelectedFiles();
            for (int i = 0; i < files.length; ++i) {
                this.addTab(files[i]);
            }
        }
    }

    public void openConfigFromUrl(String url) {
        try {
            this.addTab(new URL(url));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public void defineSettings() {
        this.settingsDialog.setLocationRelativeTo(this);
        this.settingsDialog.setVisible(true);
    }

    public void defineRuntimeParams() {
        this.runParamsDialog.setLocationRelativeTo(this);
        this.runParamsDialog.setVisible(true);
    }

    private void defineMenuItem(JMenu menu, String text, Icon icon, int mnemonic, String command, KeyStroke keyStroke) {
        MenuElements.MenuItem menuItem = new MenuElements.MenuItem(text);
        menuItem.setIcon(icon == null ? ResourceManager.NONE_ICON : icon);
        menuItem.setMnemonic(mnemonic);
        menuItem.setAccelerator(keyStroke);
        menuItem.setActionCommand(command);
        menuItem.addActionListener(this);
        menu.add(menuItem);
        this.addComponentForCommand(menuItem, command);
    }

    private void defineCheckboxMenuItem(JMenu menu, String text, Icon icon, int mnemonic, String command, KeyStroke keyStroke, boolean isChecked) {
        MenuElements.CheckboxMenuItem menuItem = new MenuElements.CheckboxMenuItem(text, isChecked);
        menuItem.setIcon(icon == null ? ResourceManager.NONE_ICON : icon);
        menuItem.setMnemonic(mnemonic);
        menuItem.setAccelerator(keyStroke);
        menuItem.setActionCommand(command);
        menuItem.addActionListener(this);
        menu.add(menuItem);
        this.addComponentForCommand(menuItem, command);
    }

    private void definePopupMenuItem(JPopupMenu menu, String text, Icon icon, int mnemonic, String command, KeyStroke keyStroke) {
        MenuElements.MenuItem menuItem = new MenuElements.MenuItem(text);
        if (icon != null) {
            menuItem.setIcon(icon);
        }
        menuItem.setMnemonic(mnemonic);
        menuItem.setAccelerator(keyStroke);
        menuItem.setActionCommand(command);
        menuItem.addActionListener(this);
        menu.add(menuItem);
        this.addComponentForCommand(menuItem, command);
    }

    private JMenuBar defineMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        MenuElements.Menu menu = new MenuElements.Menu("Config");
        menu.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent e) {
            }

            public void menuDeselected(MenuEvent e) {
            }

            public void menuSelected(MenuEvent e) {
                Ide.this.recentsSubmenu.removeAll();
                List recentFiles = Ide.this.settings.getRecentFiles();
                for (String recentFilename : recentFiles) {
                    Ide.this.defineMenuItem(Ide.this.recentsSubmenu, recentFilename, null, -1, "recent:" + recentFilename, null);
                }
            }
        });
        menu.setMnemonic('C');
        this.defineMenuItem(menu, "New", ResourceManager.NEW_ICON, 78, COMMAND_NEW, KeyStroke.getKeyStroke(78, 2));
        this.defineMenuItem(menu, "Open", ResourceManager.OPEN_ICON, 79, COMMAND_OPEN, KeyStroke.getKeyStroke(79, 2));
        this.recentsSubmenu = new MenuElements.InnerMenu("Open Recent");
        this.recentsSubmenu.setMnemonic(82);
        this.recentsSubmenu.setIcon(ResourceManager.NONE_ICON);
        menu.add(this.recentsSubmenu);
        this.defineMenuItem(menu, "Save", ResourceManager.SAVE_ICON, 83, COMMAND_SAVE, KeyStroke.getKeyStroke(83, 2));
        this.defineMenuItem(menu, "Save As", null, 86, COMMAND_SAVEAS, null);
        menu.addSeparator();
        this.defineMenuItem(menu, "Close", ResourceManager.CLOSE_ICON, 67, COMMAND_CLOSE, KeyStroke.getKeyStroke(115, 2));
        this.defineMenuItem(menu, "Close All", null, 65, COMMAND_CLOSE_ALL, null);
        menu.addSeparator();
        this.defineMenuItem(menu, "Exit", null, 88, COMMAND_EXIT, null);
        menuBar.add(menu);
        menu = new MenuElements.Menu("Edit");
        menu.setMnemonic('E');
        this.defineMenuItem(menu, "Undo", ResourceManager.UNDO_ICON, 85, COMMAND_UNDO, KeyStroke.getKeyStroke(90, 2));
        this.defineMenuItem(menu, "Redo", ResourceManager.REDO_ICON, 82, COMMAND_REDO, KeyStroke.getKeyStroke(89, 2));
        menu.addSeparator();
        this.defineMenuItem(menu, "Find", ResourceManager.FIND_ICON, 70, COMMAND_FIND, KeyStroke.getKeyStroke(70, 2));
        this.defineMenuItem(menu, "Replace", null, 76, COMMAND_REPLACE, KeyStroke.getKeyStroke(82, 2));
        this.defineMenuItem(menu, "Find Next", null, 78, COMMAND_FINDNEXT, KeyStroke.getKeyStroke(114, 0));
        this.defineMenuItem(menu, "Find Previous", null, 86, COMMAND_FINDPREV, KeyStroke.getKeyStroke(114, 1));
        menu.addSeparator();
        this.defineMenuItem(menu, "Cut", ResourceManager.CUT_ICON, 85, COMMAND_CUT, KeyStroke.getKeyStroke(88, 2));
        this.defineMenuItem(menu, "Copy", ResourceManager.COPY_ICON, 67, COMMAND_COPY, KeyStroke.getKeyStroke(67, 2));
        this.defineMenuItem(menu, "Paste", ResourceManager.PASTE_ICON, 80, COMMAND_PASTE, KeyStroke.getKeyStroke(86, 2));
        menu.addSeparator();
        this.defineMenuItem(menu, "Duplicate", ResourceManager.NONE_ICON, 68, COMMAND_DUPLICATE, KeyStroke.getKeyStroke(68, 2));
        this.defineMenuItem(menu, "Comment/Uncomment", ResourceManager.NONE_ICON, 47, COMMAND_COMMENT, KeyStroke.getKeyStroke(47, 2));
        menu.addSeparator();
        this.defineMenuItem(menu, "Toggle Line Breakpoint", ResourceManager.NONE_ICON, 66, COMMAND_BREAKPOINT, KeyStroke.getKeyStroke(119, 2));
        menu.addSeparator();
        this.defineMenuItem(menu, "Next Tab", null, 69, COMMAND_NEXTTAB, KeyStroke.getKeyStroke(39, 10));
        this.defineMenuItem(menu, "Previous Tab", null, 80, COMMAND_PREVTAB, KeyStroke.getKeyStroke(37, 10));
        menuBar.add(menu);
        this.editorPopupMenu = new WHPopupMenu();
        this.definePopupMenuItem(this.editorPopupMenu, "Undo", ResourceManager.UNDO_ICON, 85, COMMAND_UNDO, KeyStroke.getKeyStroke(90, 2));
        this.definePopupMenuItem(this.editorPopupMenu, "Redo", ResourceManager.REDO_ICON, 82, COMMAND_REDO, KeyStroke.getKeyStroke(89, 2));
        this.editorPopupMenu.addSeparator();
        this.definePopupMenuItem(this.editorPopupMenu, "Find", ResourceManager.FIND_ICON, 70, COMMAND_FIND, KeyStroke.getKeyStroke(70, 2));
        this.definePopupMenuItem(this.editorPopupMenu, "Replace", ResourceManager.NONE_ICON, 76, COMMAND_REPLACE, KeyStroke.getKeyStroke(82, 2));
        this.definePopupMenuItem(this.editorPopupMenu, "Find Next", ResourceManager.NONE_ICON, 78, COMMAND_FINDNEXT, KeyStroke.getKeyStroke(114, 0));
        this.definePopupMenuItem(this.editorPopupMenu, "Find Previous", ResourceManager.NONE_ICON, 86, COMMAND_FINDPREV, KeyStroke.getKeyStroke(114, 1));
        this.editorPopupMenu.addSeparator();
        this.definePopupMenuItem(this.editorPopupMenu, "Cut", ResourceManager.CUT_ICON, 85, COMMAND_CUT, KeyStroke.getKeyStroke(88, 2));
        this.definePopupMenuItem(this.editorPopupMenu, "Copy", ResourceManager.COPY_ICON, 67, COMMAND_COPY, KeyStroke.getKeyStroke(67, 2));
        this.definePopupMenuItem(this.editorPopupMenu, "Paste", ResourceManager.PASTE_ICON, 80, COMMAND_PASTE, KeyStroke.getKeyStroke(86, 2));
        this.editorPopupMenu.addSeparator();
        this.definePopupMenuItem(this.editorPopupMenu, "Duplicate", ResourceManager.NONE_ICON, 68, COMMAND_DUPLICATE, KeyStroke.getKeyStroke(68, 2));
        this.definePopupMenuItem(this.editorPopupMenu, "Comment/Uncomment", ResourceManager.NONE_ICON, 47, COMMAND_COMMENT, KeyStroke.getKeyStroke(47, 2));
        this.editorPopupMenu.addSeparator();
        this.definePopupMenuItem(this.editorPopupMenu, "Toggle Line Breakpoint", ResourceManager.NONE_ICON, 66, COMMAND_BREAKPOINT, KeyStroke.getKeyStroke(119, 2));
        menu = new MenuElements.Menu("View");
        menu.setMnemonic('V');
        this.defineMenuItem(menu, "Synchronize tree", ResourceManager.REFRESH_ICON, 82, COMMAND_REFRESH, KeyStroke.getKeyStroke(116, 0));
        menu.addSeparator();
        this.defineCheckboxMenuItem(menu, "Hierarchy", null, 72, COMMAND_VIEW_HIERARCHY, null, false);
        this.defineCheckboxMenuItem(menu, "Log", null, 76, COMMAND_VIEW_LOG, null, false);
        menu.addSeparator();
        this.defineCheckboxMenuItem(menu, "Line numbers", null, 78, COMMAND_VIEW_LINENUMBERS, null, false);
        menuBar.add(menu);
        menu = new MenuElements.Menu("Execution");
        menu.setMnemonic('x');
        this.defineMenuItem(menu, "Run", ResourceManager.RUN_ICON, 82, COMMAND_RUN, KeyStroke.getKeyStroke(120, 0));
        this.defineMenuItem(menu, "Pause", ResourceManager.PAUSE_ICON, 82, COMMAND_PAUSE, null);
        this.defineMenuItem(menu, "Stop", ResourceManager.STOP_ICON, 83, COMMAND_STOP, KeyStroke.getKeyStroke(113, 2));
        this.defineMenuItem(menu, "View Runtime Values", ResourceManager.VIEWVALUES_ICON, 86, COMMAND_VIEWVALUES, KeyStroke.getKeyStroke(119, 8));
        menu.addSeparator();
        this.defineMenuItem(menu, "Define Run Parameters", ResourceManager.RUN_PARAMS_ICON, 80, COMMAND_RUNPARAMS, KeyStroke.getKeyStroke(122, 0));
        menu.addSeparator();
        this.defineMenuItem(menu, "Settings...", ResourceManager.SETTINGS_ICON, 84, COMMAND_SETTINGS, KeyStroke.getKeyStroke(123, 0));
        menuBar.add(menu);
        menu = new MenuElements.Menu("Help");
        menu.setMnemonic('H');
        this.defineMenuItem(menu, "Help", ResourceManager.HELP_ICON, 72, COMMAND_HELP, KeyStroke.getKeyStroke(112, 0));
        menu.addSeparator();
        this.defineMenuItem(menu, "Program Homepage", ResourceManager.HOMEPAGE_ICON, 72, COMMAND_HOMEPAGE, null);
        menu.addSeparator();
        this.defineMenuItem(menu, "About Web-Harvest", null, 65, COMMAND_ABOUT, null);
        menuBar.add(menu);
        return menuBar;
    }

    private JPopupMenu defineTabContextMenu() {
        WHPopupMenu menu = new WHPopupMenu();
        this.definePopupMenuItem(menu, "New", null, 78, COMMAND_NEW, null);
        ((JPopupMenu)menu).addSeparator();
        this.definePopupMenuItem(menu, "Close", null, 67, COMMAND_CLOSE, null);
        this.definePopupMenuItem(menu, "Close All", null, 65, COMMAND_CLOSE_ALL, null);
        return menu;
    }

    public void updateGUI() {
        ConfigPanel configPanel = this.getActiveConfigPanel();
        this.setCommandEnabled(COMMAND_SAVE, configPanel != null);
        this.setCommandEnabled(COMMAND_SAVEAS, configPanel != null);
        this.setCommandEnabled(COMMAND_REFRESH, configPanel != null && configPanel.getScraperStatus() != 1 && configPanel.getScraperStatus() != 2);
        this.setCommandEnabled(COMMAND_RUN, configPanel != null && configPanel.getScraperStatus() != 1);
        this.setCommandEnabled(COMMAND_PAUSE, configPanel != null && configPanel.getScraperStatus() == 1);
        this.setCommandEnabled(COMMAND_STOP, configPanel != null && configPanel.getScraperStatus() == 1);
        this.setCommandEnabled(COMMAND_VIEWVALUES, configPanel != null && configPanel.getScraper() != null);
        this.setCommandEnabled(COMMAND_RUNPARAMS, configPanel != null);
        this.setCommandEnabled(COMMAND_UNDO, configPanel != null);
        this.setCommandEnabled(COMMAND_REDO, configPanel != null);
        boolean hasSelection = configPanel != null && configPanel.getXmlPane().hasSelection();
        this.setCommandEnabled(COMMAND_CUT, hasSelection);
        this.setCommandEnabled(COMMAND_COPY, hasSelection);
        this.setCommandEnabled(COMMAND_PASTE, configPanel != null);
        this.setCommandEnabled(COMMAND_DUPLICATE, configPanel != null);
        this.setCommandEnabled(COMMAND_COMMENT, configPanel != null);
        this.setCommandEnabled(COMMAND_BREAKPOINT, configPanel != null);
        int tabCount = this.tabbedPane.getTabCount();
        this.setCommandEnabled(COMMAND_NEXTTAB, tabCount > 1);
        this.setCommandEnabled(COMMAND_PREVTAB, this.tabbedPane.getTabCount() > 1);
        String textToFind = this.findReplaceDialog.getSearchText();
        this.setCommandEnabled(COMMAND_FIND, configPanel != null);
        this.setCommandEnabled(COMMAND_REPLACE, configPanel != null);
        this.setCommandEnabled(COMMAND_FINDNEXT, configPanel != null && textToFind != null && !"".equals(textToFind));
        this.setCommandEnabled(COMMAND_FINDPREV, configPanel != null && textToFind != null && !"".equals(textToFind));
        this.setCommandEnabled(COMMAND_VIEW_HIERARCHY, configPanel != null);
        this.setCommandSelected(COMMAND_VIEW_HIERARCHY, configPanel != null && configPanel.isHierarchyVisible());
        this.setCommandEnabled(COMMAND_VIEW_LOG, configPanel != null);
        this.setCommandSelected(COMMAND_VIEW_LOG, configPanel != null && configPanel.isLogVisible());
        this.setCommandEnabled(COMMAND_VIEW_LOG, configPanel != null);
        this.setCommandSelected(COMMAND_VIEW_LINENUMBERS, configPanel != null && configPanel.getXmlEditorScrollPane().isShowLineNumbers());
        this.setCommandEnabled(COMMAND_VIEW_LINENUMBERS, configPanel != null);
        this.recentsSubmenu.setEnabled(!this.settings.getRecentFiles().isEmpty());
    }

    public ConfigPanel getActiveConfigPanel() {
        Component component = this.tabbedPane.getSelectedComponent();
        return component instanceof ConfigPanel ? (ConfigPanel)component : null;
    }

    public JPopupMenu getEditorPopupMenu() {
        return this.editorPopupMenu;
    }

    private ConfigDocument getActiveConfigDocument() {
        ConfigPanel activeConfigPanel = this.getActiveConfigPanel();
        return activeConfigPanel != null ? activeConfigPanel.getConfigDocument() : null;
    }

    int findTabIndex(ConfigPanel configPanel) {
        int tabCount = this.tabbedPane.getTabCount();
        for (int i = 0; i < tabCount; ++i) {
            if (configPanel != this.tabbedPane.getComponentAt(i)) continue;
            return i;
        }
        return -1;
    }

    public void setTabIcon(ConfigPanel configPanel, Icon icon) {
        int index = this.findTabIndex(configPanel);
        if (index >= 0 && index < this.tabbedPane.getTabCount()) {
            this.tabbedPane.setIconAt(index, icon);
        }
    }

    public void actionPerformed(ActionEvent e) {
        ConfigPanel activeConfigPanel;
        ConfigDocument configDocument;
        String cmd = e.getActionCommand();
        if (COMMAND_NEW.equals(cmd)) {
            this.addTab();
            this.grabFocusToActiveEditor();
        }
        if (COMMAND_OPEN.equals(cmd)) {
            this.openConfigFromFile();
            this.grabFocusToActiveEditor();
        }
        if (COMMAND_SAVE.equals(cmd) && (configDocument = this.getActiveConfigDocument()) != null) {
            configDocument.saveConfigToFile(false);
        }
        if (COMMAND_SAVEAS.equals(cmd) && (configDocument = this.getActiveConfigDocument()) != null) {
            configDocument.saveConfigToFile(true);
        }
        if (COMMAND_CLOSE.equals(cmd)) {
            this.closeTab(this.tabbedPane.getSelectedIndex());
        }
        if (COMMAND_CLOSE_ALL.equals(cmd)) {
            this.closeAllTabs();
        } else if (COMMAND_REFRESH.equals(cmd)) {
            activeConfigPanel = this.getActiveConfigPanel();
            if (activeConfigPanel != null) {
                activeConfigPanel.refreshTree();
            }
        } else if (COMMAND_RUN.equals(cmd)) {
            activeConfigPanel = this.getActiveConfigPanel();
            if (activeConfigPanel != null) {
                activeConfigPanel.runConfiguration();
            }
        } else if (COMMAND_PAUSE.equals(cmd)) {
            activeConfigPanel = this.getActiveConfigPanel();
            if (activeConfigPanel != null && activeConfigPanel.getScraperStatus() == 1) {
                activeConfigPanel.pauseScraperExecution();
            }
        } else if (COMMAND_STOP.equals(cmd)) {
            activeConfigPanel = this.getActiveConfigPanel();
            if (activeConfigPanel != null) {
                activeConfigPanel.stopScraperExecution();
            }
        } else if (COMMAND_VIEWVALUES.equals(cmd)) {
            activeConfigPanel = this.getActiveConfigPanel();
            if (activeConfigPanel != null) {
                final ViewerFrame viewerFrame = new ViewerFrame(activeConfigPanel.getScraper(), null, "", null, 0);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        viewerFrame.setVisible(true);
                        viewerFrame.toFront();
                    }
                });
            }
        } else if (COMMAND_RUNPARAMS.equals(cmd)) {
            this.defineRuntimeParams();
        } else if (COMMAND_SETTINGS.equals(cmd)) {
            this.defineSettings();
        } else if (COMMAND_ABOUT.equals(cmd)) {
            this.aboutWindow.open();
        } else if (COMMAND_HOMEPAGE.equals(cmd)) {
            this.openURLInBrowser("http://web-harvest.sourceforge.net");
        } else if (COMMAND_EXIT.equals(cmd)) {
            this.exitApplication();
        } else if (COMMAND_HELP.equals(cmd)) {
            this.showHelp();
        } else if (COMMAND_UNDO.equals(cmd)) {
            activeConfigPanel = this.getActiveConfigPanel();
            if (activeConfigPanel != null) {
                activeConfigPanel.undo();
            }
        } else if (COMMAND_REDO.equals(cmd)) {
            activeConfigPanel = this.getActiveConfigPanel();
            if (activeConfigPanel != null) {
                activeConfigPanel.redo();
            }
        } else if (COMMAND_FIND.equals(cmd)) {
            activeConfigPanel = this.getActiveConfigPanel();
            if (activeConfigPanel != null) {
                this.findReplaceDialog.open(activeConfigPanel.getXmlPane(), false);
            }
        } else if (COMMAND_REPLACE.equals(cmd)) {
            activeConfigPanel = this.getActiveConfigPanel();
            if (activeConfigPanel != null) {
                this.findReplaceDialog.open(activeConfigPanel.getXmlPane(), true);
            }
        } else if (COMMAND_FINDNEXT.equals(cmd)) {
            activeConfigPanel = this.getActiveConfigPanel();
            if (activeConfigPanel != null) {
                this.findReplaceDialog.findNext(activeConfigPanel.getXmlPane());
            }
        } else if (COMMAND_FINDPREV.equals(cmd)) {
            activeConfigPanel = this.getActiveConfigPanel();
            if (activeConfigPanel != null) {
                this.findReplaceDialog.findPrev(activeConfigPanel.getXmlPane());
            }
        } else if (COMMAND_CUT.equals(cmd)) {
            activeConfigPanel = this.getActiveConfigPanel();
            if (activeConfigPanel != null) {
                activeConfigPanel.getXmlPane().cut();
            }
        } else if (COMMAND_COPY.equals(cmd)) {
            activeConfigPanel = this.getActiveConfigPanel();
            if (activeConfigPanel != null) {
                activeConfigPanel.getXmlPane().copy();
            }
        } else if (COMMAND_PASTE.equals(cmd)) {
            activeConfigPanel = this.getActiveConfigPanel();
            if (activeConfigPanel != null) {
                activeConfigPanel.getXmlPane().paste();
            }
        } else if (COMMAND_DUPLICATE.equals(cmd)) {
            activeConfigPanel = this.getActiveConfigPanel();
            if (activeConfigPanel != null) {
                activeConfigPanel.getXmlPane().duplicate();
            }
        } else if (COMMAND_COMMENT.equals(cmd)) {
            activeConfigPanel = this.getActiveConfigPanel();
            if (activeConfigPanel != null) {
                activeConfigPanel.getXmlPane().comment();
            }
        } else if (COMMAND_BREAKPOINT.equals(cmd)) {
            activeConfigPanel = this.getActiveConfigPanel();
            if (activeConfigPanel != null) {
                activeConfigPanel.getXmlPane().toggleBreakpoint();
            }
        } else if (COMMAND_NEXTTAB.equals(cmd)) {
            int tabCount = this.tabbedPane.getTabCount();
            int selectedTab = this.tabbedPane.getSelectedIndex();
            this.tabbedPane.setSelectedIndex(selectedTab >= tabCount - 1 ? 0 : selectedTab + 1);
            this.grabFocusToActiveEditor();
        } else if (COMMAND_PREVTAB.equals(cmd)) {
            int tabCount = this.tabbedPane.getTabCount();
            int selectedTab = this.tabbedPane.getSelectedIndex();
            this.tabbedPane.setSelectedIndex(selectedTab > 0 ? selectedTab - 1 : tabCount - 1);
            this.grabFocusToActiveEditor();
        } else if (COMMAND_VIEW_HIERARCHY.equals(cmd)) {
            activeConfigPanel = this.getActiveConfigPanel();
            if (activeConfigPanel != null) {
                activeConfigPanel.showHierarchy();
            }
        } else if (COMMAND_VIEW_LOG.equals(cmd)) {
            activeConfigPanel = this.getActiveConfigPanel();
            if (activeConfigPanel != null) {
                activeConfigPanel.showLog();
            }
        } else if (COMMAND_VIEW_LINENUMBERS.equals(cmd)) {
            activeConfigPanel = this.getActiveConfigPanel();
            if (activeConfigPanel != null) {
                activeConfigPanel.getXmlEditorScrollPane().toggleShowLineNumbers();
            }
        } else if (cmd.startsWith("recent:")) {
            String filename = cmd.substring(7);
            this.addTab(new File(filename));
        }
        this.updateGUI();
    }

    private void grabFocusToActiveEditor() {
        ConfigPanel activeConfigPanel = this.getActiveConfigPanel();
        if (activeConfigPanel != null) {
            activeConfigPanel.getXmlPane().grabFocus();
        }
    }

    public void stateChanged(ChangeEvent event) {
        Object source = event.getSource();
        if (source == this.tabbedPane) {
            this.updateGUI();
        }
    }

    public Settings getSettings() {
        return this.settings;
    }

    public JTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    public void openURLInBrowser(String url) {
        String osName = System.getProperty("os.name");
        try {
            if (osName.startsWith("Mac OS")) {
                Class<?> fileMgr = Class.forName("com.apple.eio.FileManager");
                Method openURL = fileMgr.getDeclaredMethod("openURL", String.class);
                openURL.invoke(null, url);
            } else if (osName.startsWith("Windows")) {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
            } else {
                String[] browsers = new String[]{"firefox", "opera", "konqueror", "epiphany", "mozilla", "netscape"};
                String browser = null;
                for (int count = 0; count < browsers.length && browser == null; ++count) {
                    if (Runtime.getRuntime().exec(new String[]{"which", browsers[count]}).waitFor() != 0) continue;
                    browser = browsers[count];
                }
                if (browser == null) {
                    throw new Exception("Could not find web browser");
                }
                Runtime.getRuntime().exec(new String[]{browser, url});
            }
        }
        catch (Exception e) {
            GuiUtils.showErrorMessage("Error attempting to launch web browser:\n" + e.getLocalizedMessage());
        }
    }

    public void showHelp() {
        if (this.helpFrame == null) {
            this.helpFrame = new HelpFrame();
            this.helpFrame.setLocationRelativeTo(this);
        }
        this.helpFrame.setVisible(true);
    }
}

