/*
 * Decompiled with CFR 0.152.
 */
package org.webharvest.gui;

import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.border.EmptyBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.webharvest.definition.DefinitionResolver;
import org.webharvest.definition.ElementInfo;
import org.webharvest.gui.XmlTextPane;
import org.webharvest.gui.component.WHScrollPane;

public class AutoCompleter {
    private static final int TAG_CONTEXT = 0;
    private static final int ATTRIBUTE_CONTEXT = 1;
    private static final int ATTRIBUTE_VALUE_CONTEXT = 2;
    private static final String CDATA_NAME = "<![CDATA[ ... ]]>";
    private static final String XML_COMMENT_NAME = "<!-- ... -->";
    private static final Color BG_COLOR = new Color(235, 244, 254);
    private static final Font POPUP_FONT = new Font("Monospaced", 0, 12);
    private JPopupMenu popupMenu = new JPopupMenu();
    private DefaultListModel model = new DefaultListModel(){

        public void addElement(Object obj) {
            super.addElement(" " + obj + " ");
        }
    };
    private JList list = new JList(this.model);
    private XmlTextPane xmlPane;
    private transient int context = 0;
    private int prefixLength;
    private Map elementInfos;

    public AutoCompleter(XmlTextPane xmlPane) {
        this.xmlPane = xmlPane;
        this.list.setBackground(BG_COLOR);
        this.list.setFont(POPUP_FONT);
        this.list.setSelectionMode(0);
        this.list.addKeyListener(new CompleterKeyListener());
        this.list.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    AutoCompleter.this.popupMenu.setVisible(false);
                    AutoCompleter.this.doComplete();
                }
            }
        });
        this.popupMenu.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.elementInfos = DefinitionResolver.getElementInfos();
    }

    private void defineTagsMenu(String prefix) {
        if (prefix != null) {
            prefix = prefix.toLowerCase();
        }
        this.model.clear();
        for (Map.Entry entry : this.elementInfos.entrySet()) {
            String key = (String)entry.getKey();
            if (prefix != null && !key.toLowerCase().startsWith(prefix)) continue;
            ElementInfo elementInfo = (ElementInfo)entry.getValue();
            this.model.addElement(elementInfo.getName());
        }
        boolean addCData = CDATA_NAME.toLowerCase().startsWith("<" + prefix);
        boolean addXmlComment = XML_COMMENT_NAME.toLowerCase().startsWith("<" + prefix);
        if (addCData || addXmlComment) {
            if (addCData) {
                this.model.addElement(CDATA_NAME);
            }
            if (addXmlComment) {
                this.model.addElement(XML_COMMENT_NAME);
            }
        }
    }

    private void defineAttributesMenu(String elementName, String prefix) {
        elementName = elementName.toLowerCase();
        prefix = prefix.toLowerCase();
        this.model.clear();
        ElementInfo elementInfo = DefinitionResolver.getElementInfo(elementName);
        if (elementInfo != null) {
            for (Object attObj : elementInfo.getAttsSet()) {
                String att;
                if (attObj == null || !(att = ((String)attObj).toLowerCase()).startsWith(prefix) || "id".equals(att)) continue;
                this.model.addElement(att);
            }
        }
    }

    private void defineAttributeValuesMenu(String tagName, String attributeName, String attValuePrefix) {
        String[] suggs;
        this.model.clear();
        ElementInfo elementInfo = DefinitionResolver.getElementInfo(tagName);
        if (elementInfo != null && (suggs = elementInfo.getAttributeValueSuggestions(attributeName)) != null) {
            for (String s : suggs) {
                if (!s.toLowerCase().startsWith(attValuePrefix)) continue;
                this.model.addElement(s);
            }
        }
    }

    public void autoComplete() {
        try {
            Document document = this.xmlPane.getDocument();
            int offset = this.xmlPane.getCaretPosition();
            String text = document.getText(0, offset);
            int openindex = text.lastIndexOf(60);
            int closeindex = text.lastIndexOf(62);
            if (openindex > closeindex) {
                int eqIndex;
                int quoteIndex;
                String tagName = (text = text.substring(openindex)).length() > 1 ? this.getIdentifierAtStart(text.substring(1)) : null;
                String trimmedText = text.trim();
                this.context = 0;
                if (tagName != null && tagName.length() > 0 && (quoteIndex = Math.max(trimmedText.lastIndexOf("\""), trimmedText.lastIndexOf("'"))) > 0 && (eqIndex = trimmedText.lastIndexOf("=")) >= 0 && eqIndex < quoteIndex && "".equals(trimmedText.substring(eqIndex + 1, quoteIndex).trim())) {
                    int firstQuoteIndex = trimmedText.indexOf("\"", eqIndex);
                    if (firstQuoteIndex < 0) {
                        firstQuoteIndex = trimmedText.indexOf("'", eqIndex);
                    }
                    if (firstQuoteIndex < 0 || firstQuoteIndex == quoteIndex) {
                        String attValuePrefix = trimmedText.substring(quoteIndex + 1);
                        String attName = this.getIdentifierFromEnd(trimmedText = trimmedText.substring(0, eqIndex).trim());
                        if (attName != null && attName.length() > 0) {
                            this.context = 2;
                            this.defineAttributeValuesMenu(tagName.toLowerCase().trim(), attName.toLowerCase().trim(), attValuePrefix.toLowerCase().trim());
                        }
                    }
                }
                if (this.context != 2) {
                    String identifier = this.getIdentifierFromEnd(text);
                    if (this.containWhitespaces(text)) {
                        this.context = 1;
                        String elementName = this.getIdentifierFromStart(text);
                        this.defineAttributesMenu(elementName, identifier);
                        this.prefixLength = identifier.length();
                    } else {
                        this.context = 0;
                        this.defineTagsMenu(identifier);
                        this.prefixLength = identifier.length() + 1;
                    }
                }
            } else {
                this.context = 0;
                this.defineTagsMenu("");
                this.prefixLength = 0;
            }
            Rectangle position = this.xmlPane.modelToView(offset);
            if (this.model.getSize() > 0) {
                this.popupMenu.removeAll();
                this.list.setVisibleRowCount(Math.min(12, this.model.getSize()));
                WHScrollPane scrollPane = new WHScrollPane(this.list);
                this.popupMenu.add(scrollPane);
                this.popupMenu.show(this.xmlPane, (int)position.getX(), (int)(position.getY() + position.getHeight()));
                this.list.grabFocus();
                this.list.setSelectedIndex(0);
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    private boolean containWhitespaces(String text) {
        int len = text.length();
        for (int i = 0; i < len; ++i) {
            if (!Character.isWhitespace(text.charAt(i))) continue;
            return true;
        }
        return false;
    }

    private String getIdentifierFromStart(String text) {
        char ch;
        if (text.startsWith("<")) {
            text = text.substring(1);
        }
        StringBuffer result = new StringBuffer();
        int len = text.length();
        for (int i = 0; i < len && (Character.isLetter(ch = text.charAt(i)) || ch == '-' || ch == '_' || ch == '!'); ++i) {
            result.append(ch);
        }
        return result.toString();
    }

    private String getIdentifierFromEnd(String text) {
        char ch;
        StringBuffer result = new StringBuffer();
        for (int i = text.length() - 1; i >= 0 && (Character.isLetter(ch = text.charAt(i)) || ch == '-' || ch == '_' || ch == '!'); --i) {
            result.insert(0, ch);
        }
        return result.toString();
    }

    private String getIdentifierAtStart(String text) {
        char ch;
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < text.length() && (Character.isLetter(ch = text.charAt(i)) || i != 0 && (ch == '-' || ch == '_' || ch == '!')); ++i) {
            result.append(ch);
        }
        return result.toString();
    }

    public void doComplete() {
        String selectedValue = (String)this.list.getSelectedValue();
        if (selectedValue != null) {
            selectedValue = selectedValue.trim();
            try {
                if (this.context == 0) {
                    this.completeTag(selectedValue);
                } else if (this.context == 2) {
                    this.completeAttributeValue(selectedValue);
                } else {
                    this.completeAttribute(selectedValue);
                }
            }
            catch (BadLocationException e1) {
                e1.printStackTrace();
            }
        }
    }

    private void completeAttribute(String name) throws BadLocationException {
        int pos;
        Document document = this.xmlPane.getDocument();
        String cursorChar = document.getText(pos = this.xmlPane.getCaretPosition(), 1);
        boolean toAppendSpace = !">".equals(cursorChar) && !"".equals(cursorChar.trim()) && !"/".equals(cursorChar);
        String template = (name + "=\"\"" + (toAppendSpace ? " " : "")).substring(this.prefixLength);
        document.insertString(pos, template, null);
        this.xmlPane.setCaretPosition(this.xmlPane.getCaretPosition() - 1);
    }

    private void completeAttributeValue(String value) throws BadLocationException {
        int quoteIndex;
        int pos;
        Document document = this.xmlPane.getDocument();
        String text = document.getText(0, pos = this.xmlPane.getCaretPosition());
        int startTagIndex = text.lastIndexOf("<");
        if (startTagIndex >= 0 && (quoteIndex = Math.max(text.lastIndexOf("\""), text.lastIndexOf("'"))) > 0 && quoteIndex > startTagIndex) {
            document.remove(quoteIndex + 1, pos - quoteIndex - 1);
            document.insertString(quoteIndex + 1, value, null);
        }
    }

    private void completeTag(String name) throws BadLocationException {
        Document document = this.xmlPane.getDocument();
        int pos = this.xmlPane.getCaretPosition();
        if (CDATA_NAME.equals(name)) {
            document.insertString(pos, "<![CDATA[  ]]>".substring(this.prefixLength), null);
            this.xmlPane.setCaretPosition(this.xmlPane.getCaretPosition() - 4);
        } else if (XML_COMMENT_NAME.equals(name)) {
            document.insertString(pos, "<!--  -->".substring(this.prefixLength), null);
            this.xmlPane.setCaretPosition(this.xmlPane.getCaretPosition() - 4);
        } else {
            ElementInfo info = DefinitionResolver.getElementInfo(name);
            if (info != null) {
                String template = info.getTemplate(true).substring(this.prefixLength);
                document.insertString(pos, template, null);
                int closingIndex = template.lastIndexOf("</");
                if (closingIndex >= 0) {
                    this.xmlPane.setCaretPosition(this.xmlPane.getCaretPosition() - template.length() + closingIndex);
                }
            }
        }
    }

    private class CompleterKeyListener
    extends KeyAdapter {
        private CompleterKeyListener() {
        }

        public void keyPressed(KeyEvent e) {
            char ch = e.getKeyChar();
            int code = e.getKeyCode();
            if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch == '-' || code == 8) {
                Document document = AutoCompleter.this.xmlPane.getDocument();
                int pos = AutoCompleter.this.xmlPane.getCaretPosition();
                try {
                    if (code == 8) {
                        if (pos > 0 && document.getLength() > 0) {
                            document.remove(pos - 1, 1);
                        }
                    } else {
                        document.insertString(pos, String.valueOf(ch), null);
                    }
                }
                catch (BadLocationException e1) {
                    e1.printStackTrace();
                }
                AutoCompleter.this.popupMenu.setVisible(false);
                AutoCompleter.this.autoComplete();
            } else if (code == 10) {
                AutoCompleter.this.popupMenu.setVisible(false);
                AutoCompleter.this.doComplete();
            }
        }
    }
}

