/*
 * Decompiled with CFR 0.152.
 */
package org.webharvest.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URL;
import java.util.Calendar;
import javax.swing.JEditorPane;
import javax.swing.JWindow;
import javax.swing.border.LineBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import org.webharvest.gui.Ide;
import org.webharvest.gui.ResourceManager;
import org.webharvest.utils.CommonUtil;

public class AboutWindow
extends JWindow
implements HyperlinkListener {
    private static final Dimension WINDOW_DIMENSION = new Dimension(350, 280);
    private Ide ide;

    public AboutWindow(Ide ide) throws HeadlessException {
        super(ide);
        this.ide = ide;
        this.createGUI();
    }

    private void createGUI() {
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JEditorPane htmlPane = new JEditorPane();
        htmlPane.setEditable(false);
        htmlPane.setContentType("text/html");
        htmlPane.setEditorKit(new HTMLEditorKit());
        htmlPane.setBorder(new LineBorder(Color.black));
        htmlPane.addHyperlinkListener(this);
        htmlPane.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                AboutWindow.this.setVisible(false);
            }
        });
        htmlPane.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                AboutWindow.this.setVisible(false);
            }
        });
        try {
            URL aboutUrl = ResourceManager.getAboutUrl();
            String content = CommonUtil.readStringFromUrl(aboutUrl);
            content = content.replaceAll("#program.version#", "2.001");
            content = content.replaceAll("#program.date#", "17th February, 2010");
            content = content.replaceAll("#java.version#", System.getProperty("java.version"));
            content = content.replaceAll("#java.vendor#", System.getProperty("java.vendor"));
            content = content.replaceAll("#year#", String.valueOf(Calendar.getInstance().get(1)));
            ((HTMLDocument)htmlPane.getDocument()).setBase(ResourceManager.getAboutUrl());
            htmlPane.setText(content);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        contentPane.add((Component)htmlPane, "Center");
        this.pack();
    }

    public Dimension getPreferredSize() {
        return WINDOW_DIMENSION;
    }

    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            String url = e.getDescription().toString();
            this.ide.openURLInBrowser(url);
        }
    }

    public void open() {
        this.setLocationRelativeTo(this.ide);
        this.setVisible(true);
    }
}

